/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class AsyncSendEventJobHandler
implements JobHandler {
    public static final String TYPE = "async-send-event";

    public String getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        ExecutionEntity executionEntity = (ExecutionEntity)variableScope;
        FlowElement flowElement = executionEntity.getCurrentFlowElement();
        if (!(flowElement instanceof SendEventServiceTask)) {
            throw new FlowableException(String.format("Unexpected activity type found for job %s, at activity %s", job.getId(), flowElement.getId()));
        }
        Object behavior = ((SendEventServiceTask)flowElement).getBehavior();
        if (!(behavior instanceof ActivityBehavior)) {
            throw new FlowableException(String.format("Unexpected activity behavior found for job %s, at activity %s: %s", job.getId(), flowElement.getId(), behavior.getClass()));
        }
        try {
            ActivityBehavior activityBehavior = (ActivityBehavior)behavior;
            commandContext.addAttribute(TYPE, (Object)true);
            activityBehavior.execute(executionEntity);
        }
        finally {
            commandContext.removeAttribute(TYPE);
        }
    }
}

