/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.AbstractHistoryManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.history.async.AsyncHistorySession;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class AsyncHistoryManager
extends AbstractHistoryManager {
    public AsyncHistoryManager(ProcessEngineConfigurationImpl processEngineConfiguration, HistoryLevel historyLevel, boolean usePrefixId) {
        super(processEngineConfiguration, historyLevel, usePrefixId);
    }

    public AsyncHistorySession getAsyncHistorySession() {
        return this.getSession(AsyncHistorySession.class);
    }

    @Override
    public void recordProcessInstanceStart(ExecutionEntity processInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processInstance.getProcessDefinitionId())) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonProcessInstanceFields(processInstance, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-start", data, processInstance.getTenantId());
        }
    }

    @Override
    public void recordProcessInstanceEnd(ExecutionEntity processInstance, String deleteReason, String activityId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processInstance.getProcessDefinitionId())) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonProcessInstanceFields(processInstance, data);
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"deleteReason", (String)deleteReason);
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"endTime", (Date)this.getClock().getCurrentTime());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityId", (String)activityId);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-end", data);
        }
    }

    protected void addCommonProcessInstanceFields(ExecutionEntity processInstance, Map<String, String> data) {
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)processInstance.getId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"revision", (int)processInstance.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)processInstance.getProcessInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"name", (String)processInstance.getName());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"businessKey", (String)processInstance.getBusinessKey());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"deploymentId", (String)processInstance.getDeploymentId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"startTime", (Date)processInstance.getStartTime());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"startUserId", (String)processInstance.getStartUserId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"startActivityId", (String)processInstance.getStartActivityId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"superProcessInstanceId", processInstance.getSuperExecution() != null ? processInstance.getSuperExecution().getProcessInstanceId() : null);
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"callbackId", (String)processInstance.getCallbackId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"callbackType", (String)processInstance.getCallbackType());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"tenantId", (String)processInstance.getTenantId());
        this.addProcessDefinitionFields(data, processInstance.getProcessDefinitionId());
    }

    protected void addProcessDefinitionFields(Map<String, String> data, String processDefinitionId) {
        ProcessDefinition processDefinition;
        if (processDefinitionId != null && (processDefinition = this.processEngineConfiguration.getDeploymentManager().findDeployedProcessDefinitionById(processDefinitionId)) != null) {
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionId", (String)processDefinition.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionKey", (String)processDefinition.getKey());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionName", (String)processDefinition.getName());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionVersion", (int)processDefinition.getVersion());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionCategory", (String)processDefinition.getCategory());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"deploymentId", (String)processDefinition.getDeploymentId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionDerivedFrom", (String)processDefinition.getDerivedFrom());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionDerivedFromRoot", (String)processDefinition.getDerivedFromRoot());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionDerivedVersion", (int)processDefinition.getDerivedVersion());
        }
    }

    @Override
    public void recordProcessInstanceNameChange(ExecutionEntity processInstanceExecution, String newName) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processInstanceExecution.getProcessDefinitionId())) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)processInstanceExecution.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"name", (String)newName);
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"revision", (int)processInstanceExecution.getRevision());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"property", (String)"name");
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-property-changed", data);
        }
    }

    @Override
    public void recordProcessInstanceDeleted(String processInstanceId, String processDefinitionId) {
        if (this.isHistoryEnabled(processDefinitionId)) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)processInstanceId);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-deleted", data);
        }
    }

    @Override
    public void recordDeleteHistoricProcessInstancesByProcessDefinitionId(String processDefinitionId) {
        if (this.isHistoryEnabled(processDefinitionId)) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionId", (String)processDefinitionId);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-deleted-by-process-definition-id", data);
        }
    }

    @Override
    public void recordActivityStart(ActivityInstance activityInstance) {
        if (activityInstance != null && this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, activityInstance.getProcessDefinitionId()) && activityInstance.getActivityId() != null) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"runtimeActivityInstanceId", (String)activityInstance.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionId", (String)activityInstance.getProcessDefinitionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)activityInstance.getProcessInstanceId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"executionId", (String)activityInstance.getExecutionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityId", (String)activityInstance.getActivityId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"startTime", (Date)activityInstance.getStartTime());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityName", (String)activityInstance.getActivityName());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityType", (String)activityInstance.getActivityType());
            if (activityInstance.getTenantId() != null) {
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"tenantId", (String)activityInstance.getTenantId());
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-start", data, activityInstance.getTenantId());
        }
    }

    @Override
    public void recordActivityEnd(ExecutionEntity executionEntity, String deleteReason) {
        String activityId;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, executionEntity.getProcessDefinitionId()) && StringUtils.isNotEmpty((CharSequence)(activityId = this.getActivityIdForExecution(executionEntity)))) {
            HashMap<String, String> data = new HashMap<String, String>();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionId", (String)executionEntity.getProcessDefinitionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)executionEntity.getProcessInstanceId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"executionId", (String)executionEntity.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityId", (String)activityId);
            if (executionEntity.getCurrentFlowElement() != null) {
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityName", (String)executionEntity.getCurrentFlowElement().getName());
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityType", (String)this.parseActivityType(executionEntity.getCurrentFlowElement()));
            }
            if (executionEntity.getTenantId() != null) {
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"tenantId", (String)executionEntity.getTenantId());
            }
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"deleteReason", (String)deleteReason);
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"endTime", (Date)this.getClock().getCurrentTime());
            Map<String, String> correspondingActivityStartData = this.getActivityStart(executionEntity.getId(), activityId, true);
            if (correspondingActivityStartData == null) {
                this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-end", data);
            } else {
                data.put("startTime", correspondingActivityStartData.get("startTime"));
                this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-full", data);
            }
        }
    }

    @Override
    public void recordActivityEnd(ActivityInstance activityInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, activityInstance.getProcessDefinitionId()) && StringUtils.isNotEmpty((CharSequence)activityInstance.getActivityId())) {
            HashMap<String, String> data = new HashMap<String, String>();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"runtimeActivityInstanceId", (String)activityInstance.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionId", (String)activityInstance.getProcessDefinitionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)activityInstance.getProcessInstanceId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"executionId", (String)activityInstance.getExecutionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityId", (String)activityInstance.getActivityId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityName", (String)activityInstance.getActivityName());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityType", (String)activityInstance.getActivityType());
            if (activityInstance.getTenantId() != null) {
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"tenantId", (String)activityInstance.getTenantId());
            }
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"deleteReason", (String)activityInstance.getDeleteReason());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"endTime", (Date)activityInstance.getEndTime());
            Map<String, String> correspondingActivityStartData = this.getActivityStart(activityInstance.getExecutionId(), activityInstance.getActivityId(), true);
            if (correspondingActivityStartData == null) {
                this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-end", data);
            } else {
                data.put("startTime", correspondingActivityStartData.get("startTime"));
                this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-full", data);
            }
        }
    }

    @Override
    public void recordProcessDefinitionChange(String processInstanceId, String processDefinitionId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processDefinitionId)) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)processInstanceId);
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionId", (String)processDefinitionId);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "set-process-definition", data);
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task, ExecutionEntity execution) {
        String processDefinitionId = null;
        if (execution != null) {
            processDefinitionId = execution.getProcessDefinitionId();
        } else if (task != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonTaskFields(task, execution, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "task-created", data, task.getTenantId());
        }
    }

    protected void addCommonTaskFields(TaskEntity task, ExecutionEntity execution, Map<String, String> data) {
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)task.getId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"revision", (int)task.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"name", (String)task.getName());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"parentTaskId", (String)task.getParentTaskId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"description", (String)task.getDescription());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"owner", (String)task.getOwner());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"assignee", (String)task.getAssignee());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"createTime", (Date)task.getCreateTime());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"taskDefinitionKey", (String)task.getTaskDefinitionKey());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"taskDefinitionId", (String)task.getTaskDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"formKey", (String)task.getFormKey());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"priority", (int)task.getPriority());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"dueDate", (Date)task.getDueDate());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"category", (String)task.getCategory());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"claimTime", (Date)task.getClaimTime());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"tenantId", (String)task.getTenantId());
        if (execution != null) {
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)execution.getProcessInstanceId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"executionId", (String)execution.getId());
            this.addProcessDefinitionFields(data, execution.getProcessDefinitionId());
        } else if (task.getProcessDefinitionId() != null) {
            this.addProcessDefinitionFields(data, task.getProcessDefinitionId());
        }
    }

    @Override
    public void recordTaskEnd(TaskEntity task, ExecutionEntity execution, String deleteReason) {
        String processDefinitionId = null;
        if (execution != null) {
            processDefinitionId = execution.getProcessDefinitionId();
        } else if (task != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonTaskFields(task, execution, data);
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"deleteReason", (String)deleteReason);
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"endTime", (Date)this.getClock().getCurrentTime());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "task-ended", data);
        }
    }

    @Override
    public void recordTaskInfoChange(TaskEntity taskEntity, String runtimeActivityInstanceId) {
        Map originalPersistentState;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, taskEntity.getProcessDefinitionId())) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonTaskFields(taskEntity, null, data);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "task-property-changed", data);
        }
        if ((originalPersistentState = (Map)taskEntity.getOriginalPersistentState()) == null && taskEntity.getAssignee() != null || originalPersistentState != null && !Objects.equals(originalPersistentState.get("assignee"), taskEntity.getAssignee())) {
            this.handleTaskAssigneeChange(taskEntity, runtimeActivityInstanceId);
        }
        if (originalPersistentState == null && taskEntity.getOwner() != null || originalPersistentState != null && !Objects.equals(originalPersistentState.get("owner"), taskEntity.getOwner())) {
            this.handleTaskOwnerChange(taskEntity, runtimeActivityInstanceId);
        }
    }

    protected void handleTaskAssigneeChange(TaskEntity taskEntity, String activityInstanceId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, taskEntity.getProcessDefinitionId())) {
            HashMap<String, String> data = new HashMap<String, String>();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"assignee", (String)taskEntity.getAssignee());
            if (taskEntity.getExecutionId() != null) {
                ExecutionEntity executionEntity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(taskEntity.getExecutionId());
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"executionId", (String)executionEntity.getId());
                String activityId = this.getActivityIdForExecution(executionEntity);
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityId", (String)activityId);
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"runtimeActivityInstanceId", (String)activityInstanceId);
                if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, taskEntity.getProcessDefinitionId())) {
                    Map<String, String> activityStartData = this.getActivityStart(executionEntity.getId(), activityId, false);
                    if (activityStartData != null) {
                        AsyncHistoryJsonUtil.putIfNotNull(activityStartData, (String)"assignee", (String)taskEntity.getAssignee());
                        data.put("activityAssigneeHandled", String.valueOf(true));
                    }
                } else {
                    data.put("activityAssigneeHandled", String.valueOf(true));
                }
            }
            if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, taskEntity.getProcessDefinitionId())) {
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)taskEntity.getId());
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"createTime", (Date)this.getClock().getCurrentTime());
                this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "task-assignee-changed", data);
            }
        }
    }

    protected void handleTaskOwnerChange(TaskEntity taskEntity, String activityInstanceId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, taskEntity.getProcessDefinitionId())) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)taskEntity.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"owner", (String)taskEntity.getOwner());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"createTime", (Date)this.getClock().getCurrentTime());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"runtimeActivityInstanceId", (String)activityInstanceId);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "task-owner-changed", data);
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable) {
        String processDefinitionId = null;
        if (this.enableProcessDefinitionHistoryLevel && variable.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceExecution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(variable.getProcessInstanceId());
            processDefinitionId = processInstanceExecution.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processDefinitionId)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonVariableFields(variable, data);
            Date time = this.getClock().getCurrentTime();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"createTime", (Date)time);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "variable-created", data);
        }
    }

    protected void addCommonVariableFields(VariableInstanceEntity variable, Map<String, String> data) {
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)variable.getId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)variable.getProcessInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"executionId", (String)variable.getExecutionId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"taskId", (String)variable.getTaskId());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"revision", (int)variable.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"name", (String)variable.getName());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"variableType", (String)variable.getType().getTypeName());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"variableTextValue", (String)variable.getTextValue());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"variableTextValue2", (String)variable.getTextValue2());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"variableDoubleValue", (Double)variable.getDoubleValue());
        AsyncHistoryJsonUtil.putIfNotNull(data, (String)"variableLongValue", (Long)variable.getLongValue());
        if (variable.getByteArrayRef() != null) {
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"variableBytesValue", (String)AsyncHistoryJsonUtil.convertToBase64((VariableInstanceEntity)variable));
        }
        if (variable.getExecutionId() != null) {
            this.addProcessDefinitionFields(data, variable.getProcessDefinitionId());
        }
    }

    @Override
    public void recordHistoricDetailVariableCreate(VariableInstanceEntity variable, ExecutionEntity sourceActivityExecution, boolean useActivityId, String activityInstanceId) {
        TaskEntity taskEntity;
        String processDefinitionId = null;
        if (sourceActivityExecution != null) {
            processDefinitionId = sourceActivityExecution.getProcessDefinitionId();
        } else if (variable.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceExecution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(variable.getProcessInstanceId());
            if (processInstanceExecution != null) {
                processDefinitionId = processInstanceExecution.getProcessDefinitionId();
            }
        } else if (variable.getTaskId() != null && (taskEntity = CommandContextUtil.getTaskService().getTask(variable.getTaskId())) != null) {
            processDefinitionId = taskEntity.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.FULL, processDefinitionId)) {
            String activityId;
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonVariableFields(variable, data);
            if (sourceActivityExecution != null && sourceActivityExecution.isMultiInstanceRoot()) {
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"isMiRootExecution", (Boolean)true);
            }
            Date time = this.getClock().getCurrentTime();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"createTime", (Date)time);
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"runtimeActivityInstanceId", (String)activityInstanceId);
            if (useActivityId && sourceActivityExecution != null && (activityId = this.getActivityIdForExecution(sourceActivityExecution)) != null) {
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityId", (String)activityId);
                AsyncHistoryJsonUtil.putIfNotNull(data, (String)"sourceExecutionId", (String)sourceActivityExecution.getId());
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "historic-detail-variable-update", data);
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variable) {
        String processDefinitionId = null;
        if (this.enableProcessDefinitionHistoryLevel && variable.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceExecution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(variable.getProcessInstanceId());
            processDefinitionId = processInstanceExecution.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processDefinitionId)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.addCommonVariableFields(variable, data);
            Date time = this.getClock().getCurrentTime();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"lastUpdatedTime", (Date)time);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "variable-updated", data);
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variable) {
        String processDefinitionId = null;
        if (this.enableProcessDefinitionHistoryLevel && variable.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceExecution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(variable.getProcessInstanceId());
            processDefinitionId = processInstanceExecution.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processDefinitionId)) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)variable.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"revision", (int)variable.getRevision());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "variable-removed", data);
        }
    }

    @Override
    public void recordFormPropertiesSubmitted(ExecutionEntity execution, Map<String, String> properties, String taskId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, execution.getProcessDefinitionId())) {
            HashMap<String, String> data = new HashMap<String, String>();
            if (execution != null) {
                this.addProcessDefinitionFields(data, execution.getProcessDefinitionId());
            }
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)execution.getProcessInstanceId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"executionId", (String)execution.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"taskId", (String)taskId);
            String activityId = this.getActivityIdForExecution(execution);
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityId", (String)activityId);
            Date currentTime = this.getClock().getCurrentTime();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"createTime", (Date)currentTime);
            int counter = 1;
            for (String propertyId : properties.keySet()) {
                String propertyValue = properties.get(propertyId);
                data.put("formPropertyId" + counter, propertyId);
                data.put("formPropertyValue" + counter, propertyValue);
                ++counter;
            }
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "form-properties-submitted", data);
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        TaskEntity task;
        String processDefinitionId = null;
        if (identityLink.getProcessInstanceId() != null) {
            ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(identityLink.getProcessInstanceId());
            if (execution != null) {
                processDefinitionId = execution.getProcessDefinitionId();
            }
        } else if (identityLink.getTaskId() != null && (task = CommandContextUtil.getTaskService().getTask(identityLink.getTaskId())) != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId) && (identityLink.getProcessInstanceId() != null || identityLink.getTaskId() != null)) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)identityLink.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"groupId", (String)identityLink.getGroupId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionId", (String)identityLink.getProcessDefinitionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)identityLink.getProcessInstanceId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"taskId", (String)identityLink.getTaskId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"identityLinkType", (String)identityLink.getType());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"userId", (String)identityLink.getUserId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "identitylink-created", data);
        }
    }

    @Override
    public void recordIdentityLinkDeleted(IdentityLinkEntity identityLink) {
        TaskEntity task;
        String processDefinitionId = null;
        if (identityLink.getProcessInstanceId() != null) {
            ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(identityLink.getProcessInstanceId());
            if (execution != null) {
                processDefinitionId = execution.getProcessDefinitionId();
            }
        } else if (identityLink.getTaskId() != null && (task = CommandContextUtil.getTaskService().getTask(identityLink.getTaskId())) != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId)) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)identityLink.getId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "identitylink-deleted", data);
        }
    }

    @Override
    public void recordEntityLinkCreated(EntityLinkEntity entityLink) {
        TaskEntity task;
        String processDefinitionId = null;
        if ("bpmn".equals(entityLink.getScopeType()) && entityLink.getScopeId() != null) {
            ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(entityLink.getScopeId());
            if (execution != null) {
                processDefinitionId = execution.getProcessDefinitionId();
            }
        } else if ("task".equals(entityLink.getScopeType()) && entityLink.getScopeId() != null && (task = CommandContextUtil.getTaskService().getTask(entityLink.getScopeId())) != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId)) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)entityLink.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"entityLinkType", (String)entityLink.getLinkType());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"createTime", (Date)entityLink.getCreateTime());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeId", (String)entityLink.getScopeId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeType", (String)entityLink.getScopeType());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeDefinitionId", (String)entityLink.getScopeDefinitionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"referenceScopeId", (String)entityLink.getReferenceScopeId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"referenceScopeType", (String)entityLink.getReferenceScopeType());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"referenceScopeDefinitionId", (String)entityLink.getReferenceScopeDefinitionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"hierarchyType", (String)entityLink.getHierarchyType());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "entitylink-created", data);
        }
    }

    @Override
    public void recordEntityLinkDeleted(EntityLinkEntity entityLink) {
        TaskEntity task;
        String processDefinitionId = null;
        if ("bpmn".equals(entityLink.getScopeType()) && entityLink.getScopeId() != null) {
            ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(entityLink.getScopeId());
            if (execution != null) {
                processDefinitionId = execution.getProcessDefinitionId();
            }
        } else if ("task".equals(entityLink.getScopeType()) && entityLink.getScopeId() != null && (task = CommandContextUtil.getTaskService().getTask(entityLink.getScopeId())) != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId)) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"id", (String)entityLink.getId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "entitylink-deleted", data);
        }
    }

    @Override
    public void updateProcessBusinessKeyInHistory(ExecutionEntity processInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processInstance.getProcessDefinitionId())) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)processInstance.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"businessKey", (String)processInstance.getBusinessKey());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"property", (String)"businessKey");
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "process-instance-property-changed", data);
        }
    }

    @Override
    public void updateProcessDefinitionIdInHistory(ProcessDefinitionEntity processDefinitionEntity, ExecutionEntity processInstance) {
        if (this.isHistoryEnabled(processDefinitionEntity.getId())) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionId", (String)processDefinitionEntity.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)processInstance.getId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "update-process-definition-cascade", data);
        }
    }

    @Override
    public void updateHistoricActivityInstance(ActivityInstance activityInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, activityInstance.getProcessDefinitionId()) && activityInstance.getExecutionId() != null) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"runtimeActivityInstanceId", (String)activityInstance.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"taskId", (String)activityInstance.getTaskId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"assignee", (String)activityInstance.getAssignee());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"calledProcessInstanceId", (String)activityInstance.getCalledProcessInstanceId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-update", data);
        }
    }

    @Override
    public void createHistoricActivityInstance(ActivityInstance activityInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, activityInstance.getProcessDefinitionId()) && activityInstance.getExecutionId() != null) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"runtimeActivityInstanceId", (String)activityInstance.getId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionId", (String)activityInstance.getProcessDefinitionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)activityInstance.getProcessInstanceId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"executionId", (String)activityInstance.getExecutionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityId", (String)activityInstance.getActivityId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityName", (String)activityInstance.getActivityName());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"activityType", (String)activityInstance.getActivityType());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"startTime", (Date)activityInstance.getStartTime());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"endTime", (Date)activityInstance.getEndTime());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"tenantId", (String)activityInstance.getTenantId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "activity-full", data);
        }
    }

    @Override
    public void recordHistoricUserTaskLogEntry(HistoricTaskLogEntryBuilder taskLogEntryBuilder) {
        if (this.processEngineConfiguration.isEnableHistoricTaskLogging()) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"logEntryData", (String)taskLogEntryBuilder.getData());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processInstanceId", (String)taskLogEntryBuilder.getProcessInstanceId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"executionId", (String)taskLogEntryBuilder.getExecutionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"processDefinitionId", (String)taskLogEntryBuilder.getProcessDefinitionId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"taskId", (String)taskLogEntryBuilder.getTaskId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"tenantId", (String)taskLogEntryBuilder.getTenantId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"createTime", (Date)taskLogEntryBuilder.getTimeStamp());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"userId", (String)taskLogEntryBuilder.getUserId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"logEntryType", (String)taskLogEntryBuilder.getType());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeId", (String)taskLogEntryBuilder.getScopeId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"subScopeId", (String)taskLogEntryBuilder.getSubScopeId());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeType", (String)taskLogEntryBuilder.getScopeType());
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"scopeDefinitionId", (String)taskLogEntryBuilder.getScopeDefinitionId());
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "historic-user-task-log-record", data, taskLogEntryBuilder.getTenantId());
        }
    }

    @Override
    public void deleteHistoryUserTaskLog(long logNumber) {
        if (this.processEngineConfiguration.isEnableHistoricTaskLogging()) {
            HashMap data = new HashMap();
            AsyncHistoryJsonUtil.putIfNotNull(data, (String)"logNumber", (Long)logNumber);
            this.getAsyncHistorySession().addHistoricData(this.getJobServiceConfiguration(), "historic-user-task-log-delete", data);
        }
    }

    protected Map<String, String> getActivityStart(String executionId, String activityId, boolean removeFromAsyncHistorySession) {
        Map jobData;
        AsyncHistorySession.AsyncHistorySessionData asyncHistorySessionData;
        Map sessionData = this.getAsyncHistorySession().getSessionData();
        if (sessionData != null && (asyncHistorySessionData = (AsyncHistorySession.AsyncHistorySessionData)sessionData.get(this.getJobServiceConfiguration())) != null && (jobData = asyncHistorySessionData.getJobData()) != null && jobData.containsKey("activity-start")) {
            List activityStartDataList = (List)jobData.get("activity-start");
            Iterator activityStartDataIterator = activityStartDataList.iterator();
            while (activityStartDataIterator.hasNext()) {
                Map activityStartData = (Map)activityStartDataIterator.next();
                if (!activityId.equals(activityStartData.get("activityId")) || !executionId.equals(activityStartData.get("executionId"))) continue;
                if (removeFromAsyncHistorySession) {
                    activityStartDataIterator.remove();
                }
                return activityStartData;
            }
        }
        return null;
    }

    protected JobServiceConfiguration getJobServiceConfiguration() {
        return this.getProcessEngineConfiguration().getJobServiceConfiguration();
    }
}

