/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.common.impl.history.HistoryLevel;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.AbstractHistoryManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.identitylink.service.HistoricIdentityLinkService;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHistoryManager
extends AbstractHistoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DefaultHistoryManager.class.getName());

    public DefaultHistoryManager(ProcessEngineConfigurationImpl processEngineConfiguration, HistoryLevel historyLevel) {
        super(processEngineConfiguration, historyLevel);
    }

    @Override
    public void recordProcessInstanceEnd(ExecutionEntity processInstance, String deleteReason, String activityId) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstance.getId())) != null) {
            historicProcessInstance.markEnded(deleteReason);
            historicProcessInstance.setEndActivityId(activityId);
            FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_ENDED, historicProcessInstance));
            }
        }
    }

    @Override
    public void recordProcessInstanceNameChange(String processInstanceId, String newName) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceId)) != null) {
            historicProcessInstance.setName(newName);
        }
    }

    @Override
    public void recordProcessInstanceStart(ExecutionEntity processInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricProcessInstanceEntity historicProcessInstance = this.getHistoricProcessInstanceEntityManager().create(processInstance);
            this.getHistoricProcessInstanceEntityManager().insert(historicProcessInstance, false);
            FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_CREATED, historicProcessInstance));
            }
        }
    }

    @Override
    public void recordSubProcessInstanceStart(ExecutionEntity parentExecution, ExecutionEntity subProcessInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricActivityInstanceEntity activityInstance;
            HistoricProcessInstanceEntity historicProcessInstance = this.getHistoricProcessInstanceEntityManager().create(subProcessInstance);
            this.getHistoricProcessInstanceEntityManager().insert(historicProcessInstance, false);
            FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_CREATED, historicProcessInstance));
            }
            if ((activityInstance = this.findActivityInstance(parentExecution, false, true)) != null) {
                activityInstance.setCalledProcessInstanceId(subProcessInstance.getProcessInstanceId());
            }
        }
    }

    @Override
    public void recordProcessInstanceDeleted(String processInstanceId) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceId);
            this.getHistoricDetailEntityManager().deleteHistoricDetailsByProcessInstanceId(processInstanceId);
            CommandContextUtil.getHistoricVariableService().deleteHistoricVariableInstancesByProcessInstanceId(processInstanceId);
            this.getHistoricActivityInstanceEntityManager().deleteHistoricActivityInstancesByProcessInstanceId(processInstanceId);
            TaskHelper.deleteHistoricTaskInstancesByProcessInstanceId(processInstanceId);
            CommandContextUtil.getHistoricIdentityLinkService().deleteHistoricIdentityLinksByProcessInstanceId(processInstanceId);
            this.getCommentEntityManager().deleteCommentsByProcessInstanceId(processInstanceId);
            if (historicProcessInstance != null) {
                this.getHistoricProcessInstanceEntityManager().delete(historicProcessInstance, false);
            }
            List<HistoricProcessInstance> selectList = this.getHistoricProcessInstanceEntityManager().findHistoricProcessInstancesBySuperProcessInstanceId(processInstanceId);
            for (HistoricProcessInstance child : selectList) {
                this.recordProcessInstanceDeleted(child.getId());
            }
        }
    }

    @Override
    public void recordDeleteHistoricProcessInstancesByProcessDefinitionId(String processDefinitionId) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            List<String> historicProcessInstanceIds = this.getHistoricProcessInstanceEntityManager().findHistoricProcessInstanceIdsByProcessDefinitionId(processDefinitionId);
            for (String historicProcessInstanceId : historicProcessInstanceIds) {
                this.recordProcessInstanceDeleted(historicProcessInstanceId);
            }
        }
    }

    @Override
    public void recordActivityStart(ExecutionEntity executionEntity) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && executionEntity.getActivityId() != null && executionEntity.getCurrentFlowElement() != null) {
            HistoricActivityInstanceEntity historicActivityInstanceEntity = null;
            HistoricActivityInstanceEntity historicActivityInstanceEntityFromCache = this.getHistoricActivityInstanceFromCache(executionEntity.getId(), executionEntity.getActivityId(), true);
            historicActivityInstanceEntity = historicActivityInstanceEntityFromCache != null ? historicActivityInstanceEntityFromCache : this.createHistoricActivityInstanceEntity(executionEntity);
            FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_ACTIVITY_INSTANCE_CREATED, historicActivityInstanceEntity));
            }
        }
    }

    @Override
    public void recordActivityEnd(ExecutionEntity executionEntity, String deleteReason) {
        HistoricActivityInstanceEntity historicActivityInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicActivityInstance = this.findActivityInstance(executionEntity, false, true)) != null) {
            historicActivityInstance.markEnded(deleteReason);
            FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_ACTIVITY_INSTANCE_ENDED, historicActivityInstance));
            }
        }
    }

    @Override
    public void recordProcessDefinitionChange(String processInstanceId, String processDefinitionId) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceId)) != null) {
            historicProcessInstance.setProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task, ExecutionEntity execution) {
        HistoricActivityInstanceEntity historicActivityInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            if (execution != null) {
                task.setExecutionId(execution.getId());
                task.setProcessInstanceId(execution.getProcessInstanceId());
                task.setProcessDefinitionId(execution.getProcessDefinitionId());
                if (execution.getTenantId() != null) {
                    task.setTenantId(execution.getTenantId());
                }
            }
            HistoricTaskInstanceEntity historicTaskInstance = CommandContextUtil.getHistoricTaskService().recordTaskCreated(task);
            historicTaskInstance.setLastUpdateTime(this.processEngineConfiguration.getClock().getCurrentTime());
            if (execution != null) {
                historicTaskInstance.setExecutionId(execution.getId());
            }
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && execution != null && (historicActivityInstance = this.findActivityInstance(execution, false, true)) != null) {
            historicActivityInstance.setTaskId(task.getId());
        }
    }

    @Override
    public void recordTaskEnd(TaskEntity task, ExecutionEntity execution, String deleteReason) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = CommandContextUtil.getHistoricTaskService().recordTaskEnd(task, deleteReason)) != null) {
            historicTaskInstance.setLastUpdateTime(this.processEngineConfiguration.getClock().getCurrentTime());
        }
    }

    @Override
    public void recordTaskInfoChange(TaskEntity taskEntity) {
        ExecutionEntity executionEntity;
        HistoricActivityInstanceEntity historicActivityInstance;
        HistoricTaskInstanceEntity historicTaskInstance;
        HistoricTaskService historicTaskService = CommandContextUtil.getHistoricTaskService();
        HistoricTaskInstanceEntity originalHistoricTaskInstanceEntity = historicTaskService.getHistoricTask(taskEntity.getId());
        String originalAssignee = null;
        if (originalHistoricTaskInstanceEntity != null) {
            originalAssignee = originalHistoricTaskInstanceEntity.getAssignee();
        }
        boolean assigneeChanged = false;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = historicTaskService.recordTaskInfoChange(taskEntity)) != null && !Objects.equals(originalAssignee, taskEntity.getAssignee())) {
            assigneeChanged = true;
        }
        if (assigneeChanged && this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && taskEntity.getExecutionId() != null && (historicActivityInstance = this.findActivityInstance(executionEntity = (ExecutionEntity)this.getExecutionEntityManager().findById(taskEntity.getExecutionId()), false, true)) != null) {
            historicActivityInstance.setAssignee(taskEntity.getAssignee());
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            CommandContextUtil.getHistoricVariableService().createAndInsert(variable);
        }
    }

    @Override
    public void recordHistoricDetailVariableCreate(VariableInstanceEntity variable, ExecutionEntity sourceActivityExecution, boolean useActivityId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.FULL)) {
            HistoricActivityInstanceEntity historicActivityInstance;
            HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = this.getHistoricDetailEntityManager().copyAndInsertHistoricDetailVariableInstanceUpdateEntity(variable);
            if (useActivityId && sourceActivityExecution != null && (historicActivityInstance = this.findActivityInstance(sourceActivityExecution, false, false)) != null) {
                historicVariableUpdate.setActivityInstanceId(historicActivityInstance.getId());
            }
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variableInstanceEntity) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            CommandContextUtil.getHistoricVariableService().recordVariableUpdate(variableInstanceEntity);
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variableInstanceEntity) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            CommandContextUtil.getHistoricVariableService().recordVariableRemoved(variableInstanceEntity);
        }
    }

    @Override
    public void recordFormPropertiesSubmitted(ExecutionEntity processInstance, Map<String, String> properties, String taskId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            for (String propertyId : properties.keySet()) {
                String propertyValue = properties.get(propertyId);
                this.getHistoricDetailEntityManager().insertHistoricFormPropertyEntity(processInstance, propertyId, propertyValue, taskId);
            }
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (identityLink.getProcessInstanceId() != null || identityLink.getTaskId() != null)) {
            HistoricIdentityLinkService historicIdentityLinkService = CommandContextUtil.getHistoricIdentityLinkService();
            HistoricIdentityLinkEntity historicIdentityLinkEntity = historicIdentityLinkService.createHistoricIdentityLink();
            historicIdentityLinkEntity.setId(identityLink.getId());
            historicIdentityLinkEntity.setGroupId(identityLink.getGroupId());
            historicIdentityLinkEntity.setProcessInstanceId(identityLink.getProcessInstanceId());
            historicIdentityLinkEntity.setTaskId(identityLink.getTaskId());
            historicIdentityLinkEntity.setType(identityLink.getType());
            historicIdentityLinkEntity.setUserId(identityLink.getUserId());
            historicIdentityLinkService.insertHistoricIdentityLink(historicIdentityLinkEntity, false);
        }
    }

    @Override
    public void recordIdentityLinkDeleted(String identityLinkId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            CommandContextUtil.getHistoricIdentityLinkService().deleteHistoricIdentityLink(identityLinkId);
        }
    }

    @Override
    public void updateProcessBusinessKeyInHistory(ExecutionEntity processInstance) {
        if (this.isHistoryEnabled()) {
            HistoricProcessInstanceEntity historicProcessInstance;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("updateProcessBusinessKeyInHistory : {}", (Object)processInstance.getId());
            }
            if (processInstance != null && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstance.getId())) != null) {
                historicProcessInstance.setBusinessKey(processInstance.getProcessInstanceBusinessKey());
                this.getHistoricProcessInstanceEntityManager().update(historicProcessInstance, false);
            }
        }
    }
}

