/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.AdhocSubProcess;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.InclusiveGateway;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.util.CollectionUtil;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.el.UelExpressionCondition;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.condition.ConditionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakeOutgoingSequenceFlowsOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TakeOutgoingSequenceFlowsOperation.class);
    protected boolean evaluateConditions;

    public TakeOutgoingSequenceFlowsOperation(CommandContext commandContext, ExecutionEntity executionEntity, boolean evaluateConditions) {
        super(commandContext, executionEntity);
        this.evaluateConditions = evaluateConditions;
    }

    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        if (currentFlowElement instanceof Activity && ((Activity)currentFlowElement).isForCompensation()) {
            this.cleanupCompensation();
            return;
        }
        this.cleanupExecutions(currentFlowElement);
        if (currentFlowElement instanceof FlowNode) {
            this.handleFlowNode((FlowNode)currentFlowElement);
        } else if (currentFlowElement instanceof SequenceFlow) {
            this.handleSequenceFlow();
        }
    }

    protected void handleFlowNode(FlowNode flowNode) {
        this.handleActivityEnd(flowNode);
        if (flowNode.getParentContainer() != null && flowNode.getParentContainer() instanceof AdhocSubProcess) {
            this.handleAdhocSubProcess(flowNode);
        } else {
            this.leaveFlowNode(flowNode);
        }
    }

    protected void handleActivityEnd(FlowNode flowNode) {
        if (!this.execution.isProcessInstanceType()) {
            if (CollectionUtil.isNotEmpty((Collection)flowNode.getExecutionListeners())) {
                this.executeExecutionListeners((HasExecutionListeners)flowNode, "end");
            }
            if (!(!this.execution.isActive() || flowNode.getOutgoingFlows().isEmpty() || flowNode instanceof ParallelGateway || flowNode instanceof InclusiveGateway || flowNode instanceof SubProcess || flowNode instanceof Activity && ((Activity)flowNode).getLoopCharacteristics() != null)) {
                CommandContextUtil.getHistoryManager(this.commandContext).recordActivityEnd(this.execution, null);
            }
            if (!(this.execution.getCurrentFlowElement() instanceof SubProcess)) {
                CommandContextUtil.getEventDispatcher(this.commandContext).dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_COMPLETED, flowNode.getId(), flowNode.getName(), this.execution.getId(), this.execution.getProcessInstanceId(), this.execution.getProcessDefinitionId(), (FlowElement)flowNode));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void leaveFlowNode(FlowNode flowNode) {
        LOGGER.debug("Leaving flow node {} with id '{}' by following it's {} outgoing sequenceflow", new Object[]{flowNode.getClass(), flowNode.getId(), flowNode.getOutgoingFlows().size()});
        String defaultSequenceFlowId = null;
        if (flowNode instanceof Activity) {
            defaultSequenceFlowId = ((Activity)flowNode).getDefaultFlow();
        } else if (flowNode instanceof Gateway) {
            defaultSequenceFlowId = ((Gateway)flowNode).getDefaultFlow();
        }
        ArrayList<SequenceFlow> outgoingSequenceFlows = new ArrayList<SequenceFlow>();
        for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
            String skipExpressionString = sequenceFlow.getSkipExpression();
            if (!SkipExpressionUtil.isSkipExpressionEnabled((DelegateExecution)this.execution, skipExpressionString)) {
                if (this.evaluateConditions && (!this.evaluateConditions || !ConditionUtil.hasTrueCondition(sequenceFlow, this.execution) || defaultSequenceFlowId != null && defaultSequenceFlowId.equals(sequenceFlow.getId()))) continue;
                outgoingSequenceFlows.add(sequenceFlow);
                continue;
            }
            if (flowNode.getOutgoingFlows().size() != 1 && !SkipExpressionUtil.shouldSkipFlowElement(this.commandContext, this.execution, skipExpressionString)) continue;
            outgoingSequenceFlows.add(sequenceFlow);
        }
        if (outgoingSequenceFlows.size() == 0 && this.evaluateConditions && defaultSequenceFlowId != null) {
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                if (!defaultSequenceFlowId.equals(sequenceFlow.getId())) continue;
                outgoingSequenceFlows.add(sequenceFlow);
                break;
            }
        }
        if (outgoingSequenceFlows.size() == 0) {
            if (flowNode.getOutgoingFlows() != null && flowNode.getOutgoingFlows().size() != 0) throw new FlowableException("No outgoing sequence flow of element '" + flowNode.getId() + "' could be selected for continuing the process");
            LOGGER.debug("No outgoing sequence flow found for flow node '{}'.", (Object)flowNode.getId());
            this.agenda.planEndExecutionOperation(this.execution);
            return;
        } else {
            ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(this.commandContext);
            ArrayList<ExecutionEntity> outgoingExecutions = new ArrayList<ExecutionEntity>(flowNode.getOutgoingFlows().size());
            SequenceFlow sequenceFlow = (SequenceFlow)outgoingSequenceFlows.get(0);
            this.execution.setCurrentFlowElement((FlowElement)sequenceFlow);
            this.execution.setActive(false);
            outgoingExecutions.add(this.execution);
            if (outgoingSequenceFlows.size() > 1) {
                for (int i = 1; i < outgoingSequenceFlows.size(); ++i) {
                    ExecutionEntity parent = this.execution.getParentId() != null ? this.execution.getParent() : this.execution;
                    ExecutionEntity outgoingExecutionEntity = CommandContextUtil.getExecutionEntityManager(this.commandContext).createChildExecution(parent);
                    SequenceFlow outgoingSequenceFlow = (SequenceFlow)outgoingSequenceFlows.get(i);
                    outgoingExecutionEntity.setActive(false);
                    outgoingExecutionEntity.setCurrentFlowElement((FlowElement)outgoingSequenceFlow);
                    executionEntityManager.insert(outgoingExecutionEntity);
                    outgoingExecutions.add(outgoingExecutionEntity);
                }
            }
            for (ExecutionEntity outgoingExecution : outgoingExecutions) {
                this.agenda.planContinueProcessOperation(outgoingExecution);
            }
        }
    }

    protected void handleAdhocSubProcess(FlowNode flowNode) {
        Expression expression;
        UelExpressionCondition condition;
        boolean completeAdhocSubProcess = false;
        AdhocSubProcess adhocSubProcess = (AdhocSubProcess)flowNode.getParentContainer();
        if (adhocSubProcess.getCompletionCondition() != null && (condition = new UelExpressionCondition(expression = CommandContextUtil.getProcessEngineConfiguration(this.commandContext).getExpressionManager().createExpression(adhocSubProcess.getCompletionCondition()))).evaluate(adhocSubProcess.getId(), this.execution)) {
            completeAdhocSubProcess = true;
        }
        if (flowNode.getOutgoingFlows().size() > 0) {
            this.leaveFlowNode(flowNode);
        } else {
            CommandContextUtil.getExecutionEntityManager(this.commandContext).deleteExecutionAndRelatedData(this.execution, null);
        }
        if (completeAdhocSubProcess) {
            boolean endAdhocSubProcess = true;
            if (!adhocSubProcess.isCancelRemainingInstances()) {
                List<ExecutionEntity> childExecutions = CommandContextUtil.getExecutionEntityManager(this.commandContext).findChildExecutionsByParentExecutionId(this.execution.getParentId());
                for (ExecutionEntity executionEntity : childExecutions) {
                    if (executionEntity.getId().equals(this.execution.getId())) continue;
                    endAdhocSubProcess = false;
                    break;
                }
            }
            if (endAdhocSubProcess) {
                this.agenda.planEndExecutionOperation(this.execution.getParent());
            }
        }
    }

    protected void handleSequenceFlow() {
        CommandContextUtil.getHistoryManager(this.commandContext).recordActivityEnd(this.execution, null);
        this.agenda.planContinueProcessOperation(this.execution);
    }

    protected void cleanupCompensation() {
        CommandContextUtil.getExecutionEntityManager(this.commandContext).deleteExecutionAndRelatedData(this.execution, null);
        ExecutionEntity parentExecutionEntity = this.execution.getParent();
        if (parentExecutionEntity.isScope() && !parentExecutionEntity.isProcessInstanceType() && this.allChildExecutionsEnded(parentExecutionEntity, null)) {
            ExecutionEntity executionEntityToEnd = parentExecutionEntity;
            ExecutionEntity scopeExecutionEntity = this.findNextParentScopeExecutionWithAllEndedChildExecutions(parentExecutionEntity, parentExecutionEntity);
            while (scopeExecutionEntity != null) {
                executionEntityToEnd = scopeExecutionEntity;
                scopeExecutionEntity = this.findNextParentScopeExecutionWithAllEndedChildExecutions(scopeExecutionEntity, parentExecutionEntity);
            }
            if (executionEntityToEnd.isProcessInstanceType()) {
                this.agenda.planEndExecutionOperation(executionEntityToEnd);
            } else {
                this.agenda.planDestroyScopeOperation(executionEntityToEnd);
            }
        }
    }

    protected void cleanupExecutions(FlowElement currentFlowElement) {
        Activity activity;
        if (this.execution.getParentId() != null && this.execution.isScope()) {
            this.agenda.planDestroyScopeOperation(this.execution);
        } else if (currentFlowElement instanceof Activity && CollectionUtil.isNotEmpty((Collection)(activity = (Activity)currentFlowElement).getBoundaryEvents())) {
            ArrayList<String> notToDeleteEvents = new ArrayList<String>();
            for (BoundaryEvent event : activity.getBoundaryEvents()) {
                if (!CollectionUtil.isNotEmpty((Collection)event.getEventDefinitions()) || !(event.getEventDefinitions().get(0) instanceof CancelEventDefinition)) continue;
                notToDeleteEvents.add(event.getId());
            }
            List<ExecutionEntity> childExecutions = CommandContextUtil.getExecutionEntityManager(this.commandContext).findChildExecutionsByParentExecutionId(this.execution.getId());
            for (ExecutionEntity childExecution : childExecutions) {
                if (childExecution.getCurrentFlowElement() != null && notToDeleteEvents.contains(childExecution.getCurrentFlowElement().getId())) continue;
                CommandContextUtil.getExecutionEntityManager(this.commandContext).deleteExecutionAndRelatedData(childExecution, null);
            }
        }
    }

    protected ExecutionEntity findNextParentScopeExecutionWithAllEndedChildExecutions(ExecutionEntity executionEntity, ExecutionEntity executionEntityToIgnore) {
        if (executionEntity.getParentId() != null) {
            ExecutionEntity scopeExecutionEntity = executionEntity.getParent();
            while (!scopeExecutionEntity.isScope() || !scopeExecutionEntity.isProcessInstanceType()) {
                scopeExecutionEntity = scopeExecutionEntity.getParent();
            }
            if (this.allChildExecutionsEnded(scopeExecutionEntity, executionEntityToIgnore)) {
                return scopeExecutionEntity;
            }
        }
        return null;
    }

    protected boolean allChildExecutionsEnded(ExecutionEntity parentExecutionEntity, ExecutionEntity executionEntityToIgnore) {
        for (ExecutionEntity executionEntity : parentExecutionEntity.getExecutions()) {
            if (executionEntityToIgnore != null && executionEntityToIgnore.getId().equals(executionEntity.getId())) continue;
            if (!executionEntity.isEnded()) {
                return false;
            }
            if (executionEntity.getExecutions() == null || executionEntity.getExecutions().size() <= 0 || this.allChildExecutionsEnded(executionEntity, executionEntityToIgnore)) continue;
            return false;
        }
        return true;
    }
}

