/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.api.delegate.event;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.event.FlowableEventType;

public enum FlowableEngineEventType implements FlowableEventType
{
    ENTITY_CREATED,
    ENTITY_INITIALIZED,
    ENTITY_UPDATED,
    ENTITY_DELETED,
    ENTITY_SUSPENDED,
    ENTITY_ACTIVATED,
    TIMER_SCHEDULED,
    TIMER_FIRED,
    JOB_CANCELED,
    JOB_EXECUTION_SUCCESS,
    JOB_EXECUTION_FAILURE,
    JOB_RETRIES_DECREMENTED,
    JOB_RESCHEDULED,
    CUSTOM,
    ENGINE_CREATED,
    ENGINE_CLOSED,
    ACTIVITY_STARTED,
    ACTIVITY_COMPLETED,
    ACTIVITY_CANCELLED,
    ACTIVITY_SIGNAL_WAITING,
    ACTIVITY_SIGNALED,
    ACTIVITY_COMPENSATE,
    ACTIVITY_MESSAGE_WAITING,
    ACTIVITY_MESSAGE_RECEIVED,
    ACTIVITY_MESSAGE_CANCELLED,
    ACTIVITY_ERROR_RECEIVED,
    HISTORIC_ACTIVITY_INSTANCE_CREATED,
    HISTORIC_ACTIVITY_INSTANCE_ENDED,
    SEQUENCEFLOW_TAKEN,
    VARIABLE_CREATED,
    VARIABLE_UPDATED,
    VARIABLE_DELETED,
    TASK_CREATED,
    TASK_ASSIGNED,
    TASK_COMPLETED,
    PROCESS_CREATED,
    PROCESS_STARTED,
    PROCESS_COMPLETED,
    PROCESS_COMPLETED_WITH_TERMINATE_END_EVENT,
    PROCESS_COMPLETED_WITH_ERROR_END_EVENT,
    PROCESS_CANCELLED,
    HISTORIC_PROCESS_INSTANCE_CREATED,
    HISTORIC_PROCESS_INSTANCE_ENDED;

    public static final FlowableEngineEventType[] EMPTY_ARRAY;

    public static FlowableEngineEventType[] getTypesFromString(String string) {
        ArrayList<FlowableEngineEventType> result = new ArrayList<FlowableEngineEventType>();
        if (string != null && !string.isEmpty()) {
            String[] split;
            for (String typeName : split = StringUtils.split((String)string, (String)",")) {
                boolean found = false;
                for (FlowableEngineEventType type : FlowableEngineEventType.values()) {
                    if (!typeName.equals(type.name())) continue;
                    result.add(type);
                    found = true;
                    break;
                }
                if (found) continue;
                throw new FlowableIllegalArgumentException("Invalid event-type: " + typeName);
            }
        }
        return result.toArray(EMPTY_ARRAY);
    }

    static {
        EMPTY_ARRAY = new FlowableEngineEventType[0];
    }
}

