/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.spring;

import java.util.Map;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.spring.SpringDmnEngineConfiguration;
import org.flowable.dmn.spring.SpringDmnExpressionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DmnEngineFactoryBean
implements FactoryBean<DmnEngine>,
DisposableBean,
ApplicationContextAware {
    protected DmnEngineConfiguration dmnEngineConfiguration;
    protected ApplicationContext applicationContext;
    protected DmnEngine dmnEngine;

    public void destroy() throws Exception {
        if (this.dmnEngine != null) {
            this.dmnEngine.close();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public DmnEngine getObject() throws Exception {
        this.configureExpressionManager();
        this.configureExternallyManagedTransactions();
        if (this.dmnEngineConfiguration.getBeans() == null) {
            this.dmnEngineConfiguration.setBeans((Map)new SpringBeanFactoryProxyMap((BeanFactory)this.applicationContext));
        }
        this.dmnEngine = this.dmnEngineConfiguration.buildDmnEngine();
        return this.dmnEngine;
    }

    protected void configureExpressionManager() {
        if (this.dmnEngineConfiguration.getExpressionManager() == null && this.applicationContext != null) {
            this.dmnEngineConfiguration.setExpressionManager((ExpressionManager)new SpringDmnExpressionManager(this.applicationContext, this.dmnEngineConfiguration.getBeans()));
        }
    }

    protected void configureExternallyManagedTransactions() {
        SpringDmnEngineConfiguration engineConfiguration;
        if (this.dmnEngineConfiguration instanceof SpringDmnEngineConfiguration && (engineConfiguration = (SpringDmnEngineConfiguration)this.dmnEngineConfiguration).getTransactionManager() != null) {
            this.dmnEngineConfiguration.setTransactionsExternallyManaged(true);
        }
    }

    public Class<DmnEngine> getObjectType() {
        return DmnEngine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public DmnEngineConfiguration getDmnEngineConfiguration() {
        return this.dmnEngineConfiguration;
    }

    public void setDmnEngineConfiguration(DmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngineConfiguration = dmnEngineConfiguration;
    }
}

