/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.DmnDeploymentQueryImpl;
import org.flowable.dmn.engine.impl.ExecuteDecisionBuilderImpl;
import org.flowable.dmn.engine.impl.ExecuteDecisionInfo;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntityManager;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.Decision;

public abstract class AbstractExecuteDecisionCmd
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ExecuteDecisionInfo executeDecisionInfo = new ExecuteDecisionInfo();

    public AbstractExecuteDecisionCmd(ExecuteDecisionBuilderImpl decisionBuilder) {
        this.executeDecisionInfo.setDecisionKey(decisionBuilder.getDecisionKey());
        this.executeDecisionInfo.setParentDeploymentId(decisionBuilder.getParentDeploymentId());
        this.executeDecisionInfo.setInstanceId(decisionBuilder.getInstanceId());
        this.executeDecisionInfo.setExecutionId(decisionBuilder.getExecutionId());
        this.executeDecisionInfo.setActivityId(decisionBuilder.getActivityId());
        this.executeDecisionInfo.setScopeType(decisionBuilder.getScopeType());
        this.executeDecisionInfo.setVariables(decisionBuilder.getVariables());
        this.executeDecisionInfo.setTenantId(decisionBuilder.getTenantId());
        this.executeDecisionInfo.setFallbackToDefaultTenant(decisionBuilder.isFallbackToDefaultTenant());
    }

    public AbstractExecuteDecisionCmd(String decisionKey, Map<String, Object> variables) {
        this.executeDecisionInfo.setDecisionKey(decisionKey);
        this.executeDecisionInfo.setVariables(variables);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DmnDecisionTable resolveDecisionTable() {
        DecisionTableEntity decisionTable = null;
        DmnEngineConfiguration dmnEngineConfiguration = CommandContextUtil.getDmnEngineConfiguration();
        DecisionTableEntityManager decisionTableManager = dmnEngineConfiguration.getDecisionTableEntityManager();
        String decisionKey = this.executeDecisionInfo.getDecisionKey();
        String parentDeploymentId = this.executeDecisionInfo.getParentDeploymentId();
        String tenantId = this.executeDecisionInfo.getTenantId();
        if (StringUtils.isNotEmpty((CharSequence)decisionKey) && StringUtils.isNotEmpty((CharSequence)parentDeploymentId) && StringUtils.isNotEmpty((CharSequence)tenantId)) {
            List<DmnDeployment> dmnDeployments = CommandContextUtil.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new DmnDeploymentQueryImpl().parentDeploymentId(parentDeploymentId));
            if (dmnDeployments != null && dmnDeployments.size() != 0) {
                decisionTable = decisionTableManager.findDecisionTableByDeploymentAndKeyAndTenantId(dmnDeployments.get(0).getId(), decisionKey, tenantId);
            }
            if (decisionTable == null && (decisionTable = decisionTableManager.findLatestDecisionTableByKeyAndTenantId(decisionKey, tenantId)) == null) {
                if (!this.executeDecisionInfo.isFallbackToDefaultTenant() && !dmnEngineConfiguration.isFallbackToDefaultTenant()) throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + ", parent deployment id " + parentDeploymentId + " and tenant id: " + tenantId + ". There was also no fall back decision table found without parent deployment id.");
                if (StringUtils.isNotEmpty((CharSequence)dmnEngineConfiguration.getDefaultTenantValue())) {
                    decisionTable = decisionTableManager.findLatestDecisionTableByKeyAndTenantId(decisionKey, dmnEngineConfiguration.getDefaultTenantValue());
                    if (decisionTable == null) {
                        throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + ". There was also no fall back decision table found for default tenant " + dmnEngineConfiguration.getDefaultTenantValue());
                    }
                } else {
                    decisionTable = decisionTableManager.findLatestDecisionTableByKey(decisionKey);
                    if (decisionTable == null) {
                        throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + ". There was also no fall back decision table found without tenant.");
                    }
                }
            }
        } else if (StringUtils.isNotEmpty((CharSequence)decisionKey) && StringUtils.isNotEmpty((CharSequence)parentDeploymentId)) {
            List<DmnDeployment> dmnDeployments = CommandContextUtil.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new DmnDeploymentQueryImpl().parentDeploymentId(parentDeploymentId));
            if (dmnDeployments != null && dmnDeployments.size() != 0) {
                decisionTable = decisionTableManager.findDecisionTableByDeploymentAndKey(dmnDeployments.get(0).getId(), decisionKey);
            }
            if (decisionTable == null && (decisionTable = decisionTableManager.findLatestDecisionTableByKey(decisionKey)) == null) {
                throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + " and parent deployment id " + parentDeploymentId + ". There was also no fall back decision table found without parent deployment id.");
            }
        } else if (StringUtils.isNotEmpty((CharSequence)decisionKey) && StringUtils.isNotEmpty((CharSequence)tenantId)) {
            decisionTable = decisionTableManager.findLatestDecisionTableByKeyAndTenantId(decisionKey, tenantId);
            if (decisionTable == null) {
                if (!this.executeDecisionInfo.isFallbackToDefaultTenant() && !dmnEngineConfiguration.isFallbackToDefaultTenant()) throw new FlowableObjectNotFoundException("Decision table for key [" + decisionKey + "] and tenantId [" + tenantId + "] was not found");
                if (StringUtils.isNotEmpty((CharSequence)dmnEngineConfiguration.getDefaultTenantValue())) {
                    decisionTable = decisionTableManager.findLatestDecisionTableByKeyAndTenantId(decisionKey, dmnEngineConfiguration.getDefaultTenantValue());
                    if (decisionTable == null) {
                        throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + ". There was also no fall back decision table found for default tenant " + dmnEngineConfiguration.getDefaultTenantValue() + ".");
                    }
                } else {
                    decisionTable = decisionTableManager.findLatestDecisionTableByKey(decisionKey);
                    if (decisionTable == null) {
                        throw new FlowableObjectNotFoundException("No decision found for key: " + decisionKey + ". There was also no fall back decision table found without tenant.");
                    }
                }
            }
        } else {
            if (!StringUtils.isNotEmpty((CharSequence)decisionKey)) throw new FlowableIllegalArgumentException("decisionKey is null");
            decisionTable = decisionTableManager.findLatestDecisionTableByKey(decisionKey);
            if (decisionTable == null) {
                throw new FlowableObjectNotFoundException("Decision table for key [" + decisionKey + "] was not found");
            }
        }
        this.executeDecisionInfo.setDecisionDefinitionId(decisionTable.getId());
        this.executeDecisionInfo.setDeploymentId(decisionTable.getDeploymentId());
        return decisionTable;
    }

    protected Decision resolveDecision(DmnDecisionTable decisionTable) {
        if (decisionTable == null) {
            throw new FlowableIllegalArgumentException("decisionTable is null");
        }
        DecisionTableCacheEntry decisionTableCacheEntry = CommandContextUtil.getDmnEngineConfiguration().getDeploymentManager().resolveDecisionTable(decisionTable);
        Decision decision = decisionTableCacheEntry.getDecision();
        return decision;
    }
}

