/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity.data.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.data.AbstractCmmnDataManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CaseInstanceDataManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.impl.matcher.CaseInstanceByCaseDefinitionIdMatcher;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryImpl;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.common.engine.impl.persistence.cache.EntityCache;
import org.flowable.common.engine.impl.persistence.entity.Entity;

public class MybatisCaseInstanceDataManagerImpl
extends AbstractCmmnDataManager<CaseInstanceEntity>
implements CaseInstanceDataManager {
    protected CaseInstanceByCaseDefinitionIdMatcher caseInstanceByCaseDefinitionIdMatcher = new CaseInstanceByCaseDefinitionIdMatcher();

    public MybatisCaseInstanceDataManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(cmmnEngineConfiguration);
    }

    public Class<? extends CaseInstanceEntity> getManagedEntityClass() {
        return CaseInstanceEntityImpl.class;
    }

    public CaseInstanceEntity create() {
        CaseInstanceEntityImpl caseInstanceEntityImpl = new CaseInstanceEntityImpl();
        caseInstanceEntityImpl.setChildPlanItemInstances(new ArrayList<PlanItemInstanceEntity>(1));
        caseInstanceEntityImpl.setSatisfiedSentryPartInstances(new ArrayList<SentryPartInstanceEntity>(1));
        caseInstanceEntityImpl.internalSetVariableInstances(new HashMap(1));
        return caseInstanceEntityImpl;
    }

    public CaseInstanceEntity findById(String caseInstanceId) {
        return this.findCaseInstanceEntityEagerFetchPlanItemInstances(caseInstanceId, null);
    }

    @Override
    public CaseInstanceEntity findCaseInstanceEntityEagerFetchPlanItemInstances(String caseInstanceId, String planItemInstanceId) {
        EntityCache entityCache = this.getEntityCache();
        CaseInstanceEntity cachedCaseInstanceEntity = (CaseInstanceEntity)entityCache.findInCache(this.getManagedEntityClass(), caseInstanceId);
        if (cachedCaseInstanceEntity != null) {
            return cachedCaseInstanceEntity;
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        if (caseInstanceId != null) {
            params.put("caseInstanceId", caseInstanceId);
        } else if (planItemInstanceId != null) {
            params.put("planItemInstanceId", planItemInstanceId);
        }
        CaseInstanceEntityImpl caseInstanceEntity = (CaseInstanceEntityImpl)this.getDbSqlSession().selectOne("selectCaseInstanceEagerFetchPlanItemInstances", params);
        if (caseInstanceEntity != null) {
            List<PlanItemInstanceEntity> allPlanItemInstances = caseInstanceEntity.getChildPlanItemInstances();
            ArrayList<PlanItemInstanceEntity> directPlanItemInstances = new ArrayList<PlanItemInstanceEntity>();
            HashMap<String, PlanItemInstanceEntity> planItemInstanceMap = new HashMap<String, PlanItemInstanceEntity>(allPlanItemInstances.size());
            Iterator<PlanItemInstanceEntity> iterator = allPlanItemInstances.iterator();
            while (iterator.hasNext()) {
                PlanItemInstanceEntity planItemInstanceEntity;
                PlanItemInstanceEntity currentPlanItemInstanceEntity = planItemInstanceEntity = iterator.next();
                PlanItemInstanceEntity planItemInstanceFromCache = (PlanItemInstanceEntity)entityCache.findInCache(PlanItemInstanceEntityImpl.class, planItemInstanceEntity.getId());
                if (planItemInstanceFromCache != null) {
                    planItemInstanceMap.put(planItemInstanceFromCache.getId(), planItemInstanceFromCache);
                    currentPlanItemInstanceEntity = planItemInstanceFromCache;
                } else {
                    planItemInstanceMap.put(planItemInstanceEntity.getId(), planItemInstanceEntity);
                    entityCache.put((Entity)planItemInstanceEntity, true);
                }
                if (currentPlanItemInstanceEntity.getStageInstanceId() == null) {
                    directPlanItemInstances.add(currentPlanItemInstanceEntity);
                }
                currentPlanItemInstanceEntity.setChildPlanItemInstances(new ArrayList());
            }
            if (directPlanItemInstances.size() != planItemInstanceMap.size()) {
                for (PlanItemInstanceEntity planItemInstanceEntity : allPlanItemInstances) {
                    PlanItemInstanceEntity parentPlanItemInstanceEntity;
                    if (planItemInstanceEntity.getStageInstanceId() == null || (parentPlanItemInstanceEntity = (PlanItemInstanceEntity)planItemInstanceMap.get(planItemInstanceEntity.getStageInstanceId())) == null) continue;
                    parentPlanItemInstanceEntity.getChildPlanItemInstances().add(planItemInstanceMap.get(planItemInstanceEntity.getId()));
                }
            }
            caseInstanceEntity.setChildPlanItemInstances(directPlanItemInstances);
            return caseInstanceEntity;
        }
        return null;
    }

    @Override
    public List<CaseInstanceEntity> findCaseInstancesByCaseDefinitionId(String caseDefinitionId) {
        return this.getList("selectCaseInstancesByCaseDefinitionId", caseDefinitionId, (CachedEntityMatcher)this.caseInstanceByCaseDefinitionIdMatcher, true);
    }

    @Override
    public List<CaseInstance> findByCriteria(CaseInstanceQueryImpl query) {
        return this.getDbSqlSession().selectListNoCacheCheck("selectCaseInstancesByQueryCriteria", (ListQueryParameterObject)query);
    }

    @Override
    public List<CaseInstance> findWithVariablesByCriteria(CaseInstanceQueryImpl query) {
        CaseInstanceQueryImpl caseInstanceQuery = query;
        int firstResult = caseInstanceQuery.getFirstResult();
        int maxResults = caseInstanceQuery.getMaxResults();
        if (caseInstanceQuery.getCaseInstanceVariablesLimit() != null) {
            caseInstanceQuery.setMaxResults(caseInstanceQuery.getCaseInstanceVariablesLimit());
        } else {
            caseInstanceQuery.setMaxResults(this.cmmnEngineConfiguration.getCaseQueryLimit());
        }
        caseInstanceQuery.setFirstResult(0);
        List instanceList = this.getDbSqlSession().selectListWithRawParameterNoCacheCheck("selectCaseInstanceWithVariablesByQueryCriteria", (ListQueryParameterObject)caseInstanceQuery);
        if (instanceList != null && !instanceList.isEmpty()) {
            if (firstResult > 0) {
                if (firstResult <= instanceList.size()) {
                    int toIndex = firstResult + Math.min(maxResults, instanceList.size() - firstResult);
                    return instanceList.subList(firstResult, toIndex);
                }
                return Collections.EMPTY_LIST;
            }
            int toIndex = maxResults > 0 ? Math.min(maxResults, instanceList.size()) : instanceList.size();
            return instanceList.subList(0, toIndex);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public long countByCriteria(CaseInstanceQueryImpl query) {
        return (Long)this.getDbSqlSession().selectOne("selectCaseInstanceCountByQueryCriteria", (Object)query);
    }

    @Override
    public void updateLockTime(String caseInstanceId, Date lockDate, Date expirationTime) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", caseInstanceId);
        params.put("lockTime", lockDate);
        params.put("expirationTime", expirationTime);
        int result = this.getDbSqlSession().update("updateCaseInstanceLockTime", params);
        if (result == 0) {
            throw new FlowableOptimisticLockingException("Could not lock case instance");
        }
    }

    @Override
    public void clearLockTime(String caseInstanceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", caseInstanceId);
        this.getDbSqlSession().update("clearCaseInstanceLockTime", params);
    }
}

