/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.flowable.cmmn.engine.impl.history.async.json.transformer.AbstractTaskHistoryJsonTransformer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUpdatedHistoryJsonTransformer
extends AbstractTaskHistoryJsonTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskUpdatedHistoryJsonTransformer.class);

    public List<String> getTypes() {
        return Collections.singletonList("cmmn-task-updated");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return this.getHistoricTaskEntity(historicalData, commandContext) != null;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricTaskInstanceEntity historicTaskInstance = this.getHistoricTaskEntity(historicalData, commandContext);
        Date lastUpdateTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"__timeStamp");
        if (historicTaskInstance.getLastUpdateTime() == null || !historicTaskInstance.getLastUpdateTime().after(lastUpdateTime)) {
            this.copyCommonHistoricTaskInstanceFields(historicalData, historicTaskInstance);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("History job (id={}) has expired and will be ignored.", (Object)job.getId());
        }
    }
}

