/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.api.history.HistoricTaskLogEntryType;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.impl.BaseHistoricTaskLogEntryBuilderImpl;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class CompleteTaskCmd
implements Command<Void> {
    protected String taskId;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;

    public CompleteTaskCmd(String taskId, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this.taskId = taskId;
        this.variables = variables;
        this.transientVariables = transientVariables;
    }

    public Void execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new FlowableIllegalArgumentException("Null task id");
        }
        TaskEntity taskEntity = CommandContextUtil.getTaskService(commandContext).getTask(this.taskId);
        if (taskEntity == null) {
            throw new FlowableObjectNotFoundException("Could not find task entity for id " + this.taskId, TaskEntity.class);
        }
        String planItemInstanceId = taskEntity.getSubScopeId();
        PlanItemInstanceEntity planItemInstanceEntity = null;
        if (planItemInstanceId != null && (planItemInstanceEntity = (PlanItemInstanceEntity)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(planItemInstanceId)) == null) {
            throw new FlowableException("Could not find plan item instance for task " + this.taskId);
        }
        if (this.variables != null) {
            taskEntity.setVariables(this.variables);
        }
        if (this.transientVariables != null) {
            taskEntity.setTransientVariables(this.transientVariables);
        }
        this.logUserTaskCompleted(taskEntity);
        CommandContextUtil.getInternalTaskAssignmentManager(commandContext).addUserIdentityLinkToParent((Task)taskEntity, Authentication.getAuthenticatedUserId());
        CommandContextUtil.getCmmnEngineConfiguration(commandContext).getListenerNotificationHelper().executeTaskListeners(taskEntity, "complete");
        if (planItemInstanceEntity != null) {
            CommandContextUtil.getAgenda(commandContext).planTriggerPlanItemInstanceOperation(planItemInstanceEntity);
        } else {
            TaskHelper.deleteTask(taskEntity, null, false, true);
        }
        return null;
    }

    protected void logUserTaskCompleted(TaskEntity taskEntity) {
        TaskServiceConfiguration taskServiceConfiguration = CommandContextUtil.getTaskServiceConfiguration();
        if (taskServiceConfiguration.isEnableHistoricTaskLogging()) {
            BaseHistoricTaskLogEntryBuilderImpl taskLogEntryBuilder = new BaseHistoricTaskLogEntryBuilderImpl((TaskInfo)taskEntity);
            ObjectNode data = taskServiceConfiguration.getObjectMapper().createObjectNode();
            taskLogEntryBuilder.timeStamp(taskServiceConfiguration.getClock().getCurrentTime());
            taskLogEntryBuilder.userId(Authentication.getAuthenticatedUserId());
            taskLogEntryBuilder.data(data.toString());
            taskLogEntryBuilder.type(HistoricTaskLogEntryType.USER_TASK_COMPLETED.name());
            taskServiceConfiguration.getInternalHistoryTaskManager().recordHistoryUserTaskLog((HistoricTaskLogEntryBuilder)taskLogEntryBuilder);
        }
    }
}

