/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version13;

import java.io.IOException;
import java.sql.SQLException;
import java.util.BitSet;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.FieldValue;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.version12.V12Statement;

public class V13Statement
extends V12Statement {
    public V13Statement(FbWireDatabase database) {
        super(database);
    }

    @Override
    protected RowValue readSqlData() throws SQLException, IOException {
        RowDescriptor rowDescriptor = this.getFieldDescriptor();
        RowValue rowValue = rowDescriptor.createDefaultFieldValues();
        BlrCalculator blrCalculator = this.getDatabase().getBlrCalculator();
        XdrInputStream xdrIn = this.getXdrIn();
        int nullBitsLen = (rowDescriptor.getCount() + 7) / 8;
        byte[] nullBitsBytes = xdrIn.readRawBuffer(nullBitsLen);
        xdrIn.skipPadding(nullBitsLen);
        BitSet nullBits = BitSet.valueOf(nullBitsBytes);
        for (int idx = 0; idx < rowDescriptor.getCount(); ++idx) {
            FieldDescriptor fieldDescriptor = rowDescriptor.getFieldDescriptor(idx);
            FieldValue fieldValue = rowValue.getFieldValue(idx);
            if (nullBits.get(idx)) {
                fieldValue.setFieldData(null);
                continue;
            }
            int len = blrCalculator.calculateIoLength(fieldDescriptor);
            byte[] buffer = this.readColumnData(xdrIn, len);
            fieldValue.setFieldData(buffer);
        }
        return rowValue;
    }

    @Override
    protected void writeSqlData(RowDescriptor rowDescriptor, RowValue fieldValues) throws IOException, SQLException {
        XdrOutputStream xdrOut = this.getXdrOut();
        BlrCalculator blrCalculator = this.getDatabase().getBlrCalculator();
        BitSet nullBits = new BitSet(fieldValues.getCount());
        for (int idx = 0; idx < fieldValues.getCount(); ++idx) {
            FieldValue fieldValue = fieldValues.getFieldValue(idx);
            nullBits.set(idx, fieldValue.getFieldData() == null);
        }
        byte[] nullBitsBytes = nullBits.toByteArray();
        xdrOut.write(nullBitsBytes);
        int requiredBytes = (rowDescriptor.getCount() + 7) / 8;
        int remainingBytes = requiredBytes - nullBitsBytes.length;
        if (remainingBytes > 0) {
            xdrOut.write(new byte[remainingBytes]);
        }
        xdrOut.writeAlignment(requiredBytes);
        for (int idx = 0; idx < fieldValues.getCount(); ++idx) {
            if (nullBits.get(idx)) continue;
            FieldValue fieldValue = fieldValues.getFieldValue(idx);
            FieldDescriptor fieldDescriptor = rowDescriptor.getFieldDescriptor(idx);
            int len = blrCalculator.calculateIoLength(fieldDescriptor, fieldValue);
            byte[] buffer = fieldValue.getFieldData();
            int fieldType = fieldDescriptor.getType();
            this.writeColumnData(xdrOut, len, buffer, fieldType);
        }
    }
}

