/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.xsd;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.xsd.CUT;
import org.evosuite.xsd.CUTUtil;
import org.evosuite.xsd.Generation;
import org.evosuite.xsd.GenerationUtil;
import org.evosuite.xsd.Project;

public abstract class ProjectUtil {
    public static int getTotalNumberTestedClasses(Project project) {
        return project.getCut().size();
    }

    public static int getNumberLatestTestedClasses(Project project) {
        if (project.getCut().isEmpty()) {
            return 0;
        }
        OptionalInt highestID = project.getCut().parallelStream().mapToInt(c -> CUTUtil.getLatestGeneration(c).getId().intValue()).reduce(Integer::max);
        return (int)project.getCut().parallelStream().filter(c -> CUTUtil.getTimeBudget(c, highestID.getAsInt()) > 0).count();
    }

    public static int getNumberTestableClasses(Project project) {
        return project.getTotalNumberOfTestableClasses().intValue();
    }

    public static int getTotalEffort(Project project) {
        if (project.getCut().isEmpty()) {
            return 0;
        }
        OptionalInt highestID = project.getCut().parallelStream().mapToInt(c -> CUTUtil.getLatestGeneration(c).getId().intValue()).reduce(Integer::max);
        return (int)Math.ceil(project.getCut().parallelStream().mapToDouble(c -> CUTUtil.getTotalEffort(c, highestID.getAsInt())).sum());
    }

    public static int getTimeBudget(Project project) {
        if (project.getCut().isEmpty()) {
            return 0;
        }
        OptionalInt highestID = project.getCut().parallelStream().mapToInt(c -> CUTUtil.getLatestGeneration(c).getId().intValue()).reduce(Integer::max);
        return (int)Math.ceil(project.getCut().parallelStream().mapToDouble(c -> CUTUtil.getTimeBudget(c, highestID.getAsInt())).sum());
    }

    public static int getNumberGeneratedTestSuites(Project project) {
        if (project.getCut().isEmpty()) {
            return 0;
        }
        return ProjectUtil.getAllSuccessfulGenerations(project).size();
    }

    public static Set<String> getUnionCriteria(Project project) {
        LinkedHashSet<String> criteria = new LinkedHashSet<String>();
        if (project.getCut().isEmpty()) {
            return criteria;
        }
        return ProjectUtil.getAllSuccessfulGenerations(project).parallelStream().map(g -> GenerationUtil.getCriteria(g)).flatMap(s -> s.stream()).collect(Collectors.toSet());
    }

    public static double getAverageNumberStatements(Project project) {
        if (project.getCut().isEmpty()) {
            return 0.0;
        }
        return ProjectUtil.getAllSuccessfulGenerations(project).parallelStream().mapToDouble(g -> g.getSuite().getTotalNumberOfStatements().doubleValue()).sum() / project.getTotalNumberOfTestableClasses().doubleValue();
    }

    public static double getOverallCoverage(Project project) {
        if (project.getCut().isEmpty()) {
            return 0.0;
        }
        return ProjectUtil.getAllSuccessfulGenerations(project).parallelStream().mapToDouble(g -> GenerationUtil.getOverallCoverage(g)).sum() / project.getTotalNumberOfTestableClasses().doubleValue();
    }

    public static double getAverageCriterionCoverage(Project project, String criterionName) {
        if (project.getCut().isEmpty()) {
            return 0.0;
        }
        return ProjectUtil.getAllSuccessfulGenerations(project).parallelStream().mapToDouble(g -> GenerationUtil.getCriterionCoverage(g, criterionName)).sum() / project.getTotalNumberOfTestableClasses().doubleValue();
    }

    public static double getAverageNumberTests(Project project) {
        if (project.getCut().isEmpty()) {
            return 0.0;
        }
        return ProjectUtil.getAllSuccessfulGenerations(project).parallelStream().mapToDouble(g -> g.getSuite().getNumberOfTests().doubleValue()).sum() / project.getTotalNumberOfTestableClasses().doubleValue();
    }

    public static CUT getCUT(Project project, String className) {
        return project.getCut().parallelStream().filter(p -> p.getFullNameOfTargetClass().equals(className)).findFirst().orElse(null);
    }

    protected static List<Generation> getAllSuccessfulGenerations(Project project) {
        ArrayList<Generation> all = new ArrayList<Generation>();
        if (project.getCut().isEmpty()) {
            return all;
        }
        for (CUT cut : project.getCut()) {
            Generation lastSuccessfulGeneration = CUTUtil.getLatestSuccessfulGeneration(cut);
            if (lastSuccessfulGeneration == null) continue;
            all.add(lastSuccessfulGeneration);
        }
        return all;
    }
}

