/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.xsd;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.xsd.CUT;
import org.evosuite.xsd.Generation;
import org.evosuite.xsd.GenerationUtil;

public abstract class CUTUtil {
    public static int getNumberStatements(CUT cut) {
        Generation latestSuccessfulGeneration = CUTUtil.getLatestSuccessfulGeneration(cut);
        if (latestSuccessfulGeneration == null) {
            return 0;
        }
        return GenerationUtil.getNumberStatements(latestSuccessfulGeneration);
    }

    public static int getTotalEffort(CUT cut) {
        Generation latestSuccessfulGeneration = CUTUtil.getLatestGeneration(cut);
        return GenerationUtil.getTotalEffort(latestSuccessfulGeneration);
    }

    public static int getTimeBudget(CUT cut) {
        Generation latestSuccessfulGeneration = CUTUtil.getLatestGeneration(cut);
        return GenerationUtil.getTimeBudget(latestSuccessfulGeneration);
    }

    public static int getTotalEffort(CUT cut, int generationID) {
        if (generationID >= cut.getGeneration().size()) {
            return 0;
        }
        Generation generation = cut.getGeneration().get(generationID);
        return GenerationUtil.getTotalEffort(generation);
    }

    public static int getTimeBudget(CUT cut, int generationID) {
        if (generationID >= cut.getGeneration().size()) {
            return 0;
        }
        Generation generation = cut.getGeneration().get(generationID);
        return GenerationUtil.getTimeBudget(generation);
    }

    public static int getNumberTests(CUT cut) {
        Generation latestSuccessfulGeneration = CUTUtil.getLatestSuccessfulGeneration(cut);
        if (latestSuccessfulGeneration == null) {
            return 0;
        }
        return GenerationUtil.getNumberTests(latestSuccessfulGeneration);
    }

    public static Set<String> getCriteria(CUT cut) {
        Generation latestSuccessfulGeneration = CUTUtil.getLatestSuccessfulGeneration(cut);
        if (latestSuccessfulGeneration == null) {
            return new HashSet<String>();
        }
        return GenerationUtil.getCriteria(latestSuccessfulGeneration);
    }

    public static double getCriterionCoverage(CUT cut, String criterionName) {
        Generation latestSuccessfulGeneration = CUTUtil.getLatestSuccessfulGeneration(cut);
        if (latestSuccessfulGeneration == null) {
            return 0.0;
        }
        return GenerationUtil.getCriterionCoverage(latestSuccessfulGeneration, criterionName);
    }

    public static double getOverallCoverage(CUT cut) {
        Generation latestSuccessfulGeneration = CUTUtil.getLatestSuccessfulGeneration(cut);
        if (latestSuccessfulGeneration == null) {
            return 0.0;
        }
        return GenerationUtil.getOverallCoverage(latestSuccessfulGeneration);
    }

    public static Generation getLatestGeneration(CUT cut) {
        return cut.getGeneration().get(cut.getGeneration().size() - 1);
    }

    public static Generation getLatestSuccessfulGeneration(CUT cut) {
        for (int i = cut.getGeneration().size() - 1; i >= 0; --i) {
            Generation g = cut.getGeneration().get(i);
            if (g.isFailed() && g.isModified()) {
                return null;
            }
            if (g.isFailed() || g.getSuite() == null) continue;
            return g;
        }
        return null;
    }
}

