/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils.generic;

import com.googlecode.gentyref.GenericTypeReflector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.evosuite.TestGenerationContext;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.shaded.org.apache.commons.lang3.ArrayUtils;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.generic.GenericAccessibleObject;
import org.evosuite.utils.generic.GenericClass;

public class GenericField
extends GenericAccessibleObject<GenericField> {
    private static final long serialVersionUID = -2344346234923642901L;
    private transient Field field;

    public GenericField(Field field, GenericClass owner) {
        super(new GenericClass(owner));
        this.field = field;
        field.setAccessible(true);
    }

    public GenericField(Field field, Class<?> owner) {
        super(new GenericClass(owner));
        this.field = field;
        field.setAccessible(true);
    }

    public GenericField(Field field, Type owner) {
        super(new GenericClass(owner));
        this.field = field;
        field.setAccessible(true);
    }

    @Override
    public GenericField copyWithNewOwner(GenericClass newOwner) {
        return new GenericField(this.field, newOwner);
    }

    @Override
    public GenericField copyWithOwnerFromReturnType(GenericClass returnType) throws ConstructionFailedException {
        return new GenericField(this.field, this.getOwnerClass().getGenericInstantiation(returnType.getTypeVariableMap()));
    }

    @Override
    public TypeVariable<?>[] getTypeParameters() {
        if (this.field.getGenericType() instanceof TypeVariable) {
            return ArrayUtils.toArray((TypeVariable)this.field.getGenericType());
        }
        return super.getTypeParameters();
    }

    @Override
    public GenericField copy() {
        return new GenericField(this.field, new GenericClass(this.owner));
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public AccessibleObject getAccessibleObject() {
        return this.field;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public Type getGeneratedType() {
        return this.getFieldType();
    }

    @Override
    public Class<?> getRawGeneratedType() {
        return this.field.getType();
    }

    @Override
    public Type getGenericGeneratedType() {
        return this.field.getGenericType();
    }

    public Type getFieldType() {
        return GenericTypeReflector.getExactFieldType(this.field, this.owner.getType());
    }

    public Type getGenericFieldType() {
        return this.field.getGenericType();
    }

    @Override
    public boolean isAccessible() {
        return TestUsageChecker.canUse(this.field);
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    public boolean isFinal() {
        return TestClusterGenerator.isFinalField(this.field);
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public String toString() {
        return this.field.toGenericString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.field.getDeclaringClass().getName());
        oos.writeObject(this.field.getName());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        Class<?> methodClass = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass((String)ois.readObject());
        String fieldName = (String)ois.readObject();
        try {
            this.field = methodClass.getDeclaredField(fieldName);
            this.field.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unknown field for " + fieldName + " in class " + methodClass.getCanonicalName());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Unknown field for " + fieldName + " in class " + methodClass.getCanonicalName());
        }
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        super.changeClassLoader(loader);
        try {
            Class<?> oldClass = this.field.getDeclaringClass();
            Class<?> newClass = loader.loadClass(oldClass.getName());
            this.field = newClass.getDeclaredField(this.field.getName());
            this.field.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            LoggingUtils.getEvoLogger().info("Class not found - keeping old class loader ", e);
        }
        catch (SecurityException e) {
            LoggingUtils.getEvoLogger().info("Class not found - keeping old class loader ", e);
        }
        catch (NoSuchFieldException e) {
            LoggingUtils.getEvoLogger().info("Field " + this.field.getName() + " not found in class " + this.field.getDeclaringClass());
        }
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.field.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.field.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.field.getModifiers());
    }

    @Override
    public boolean isDefault() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericField other = (GenericField)obj;
        return !(this.field == null ? other.field != null : !this.field.equals(other.field));
    }
}

