/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils.generic;

import com.googlecode.gentyref.GenericTypeReflector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.evosuite.TestGenerationContext;
import org.evosuite.setup.TestClusterUtils;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.generic.GenericAccessibleObject;
import org.evosuite.utils.generic.GenericClass;

public class GenericConstructor
extends GenericAccessibleObject<GenericConstructor> {
    private static final long serialVersionUID = 1361882947700615341L;
    private transient Constructor<?> constructor;

    public GenericConstructor(Constructor<?> constructor, Class<?> clazz) {
        super(new GenericClass(clazz));
        this.constructor = constructor;
    }

    public GenericConstructor(Constructor<?> constructor, GenericClass owner) {
        super(new GenericClass(owner));
        this.constructor = constructor;
    }

    public GenericConstructor(Constructor<?> constructor, Type type) {
        super(new GenericClass(type));
        this.constructor = constructor;
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        super.changeClassLoader(loader);
        try {
            Class<?> oldClass = this.constructor.getDeclaringClass();
            Class<?> newClass = loader.loadClass(oldClass.getName());
            for (Constructor<?> newConstructor : TestClusterUtils.getConstructors(newClass)) {
                Class<?>[] newParameters;
                boolean equals = true;
                Class<?>[] oldParameters = this.constructor.getParameterTypes();
                if (oldParameters.length != (newParameters = newConstructor.getParameterTypes()).length) continue;
                for (int i = 0; i < newParameters.length; ++i) {
                    if (oldParameters[i].getName().equals(newParameters[i].getName())) continue;
                    equals = false;
                    break;
                }
                if (!equals) continue;
                this.constructor = newConstructor;
                this.constructor.setAccessible(true);
                break;
            }
        }
        catch (ClassNotFoundException e) {
            LoggingUtils.getEvoLogger().info("Class not found - keeping old class loader ", e);
        }
        catch (SecurityException e) {
            LoggingUtils.getEvoLogger().info("Class not found - keeping old class loader ", e);
        }
    }

    @Override
    public GenericConstructor copy() {
        GenericConstructor copy = new GenericConstructor(this.constructor, new GenericClass(this.owner));
        this.copyTypeVariables(copy);
        return copy;
    }

    @Override
    public GenericConstructor copyWithNewOwner(GenericClass newOwner) {
        GenericConstructor copy = new GenericConstructor(this.constructor, newOwner);
        this.copyTypeVariables(copy);
        return copy;
    }

    @Override
    public GenericConstructor copyWithOwnerFromReturnType(GenericClass returnType) {
        GenericConstructor copy = new GenericConstructor(this.constructor, returnType);
        this.copyTypeVariables(copy);
        return copy;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    @Override
    public AccessibleObject getAccessibleObject() {
        return this.constructor;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.constructor.getDeclaringClass();
    }

    public Type[] getExactParameterTypes(Constructor<?> m, Type type) {
        Type[] parameterTypes = m.getGenericParameterTypes();
        Type exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type), m.getDeclaringClass());
        if (exactDeclaringType == null) {
            throw new IllegalArgumentException("The constructor " + m + " is not a member of type " + type);
        }
        Type[] result = new Type[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            result[i] = this.mapTypeParameters(parameterTypes[i], exactDeclaringType);
        }
        return result;
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.constructor.getGenericParameterTypes();
    }

    @Override
    public Type getGeneratedType() {
        return this.getReturnType();
    }

    @Override
    public Class<?> getRawGeneratedType() {
        return this.constructor.getDeclaringClass();
    }

    @Override
    public Type getGenericGeneratedType() {
        return this.getRawGeneratedType();
    }

    @Override
    public String getName() {
        return this.constructor.getName();
    }

    public String getNameWithDescriptor() {
        return "<init>" + org.evosuite.shaded.org.objectweb.asm.Type.getConstructorDescriptor(this.constructor);
    }

    public String getDescriptor() {
        return org.evosuite.shaded.org.objectweb.asm.Type.getConstructorDescriptor(this.constructor);
    }

    @Override
    public int getNumParameters() {
        return this.constructor.getGenericParameterTypes().length;
    }

    public Type[] getParameterTypes() {
        Type[] types = this.getExactParameterTypes(this.constructor, this.owner.getType());
        Class<?>[] rawTypes = this.constructor.getParameterTypes();
        if (rawTypes.length != types.length && this.owner.isParameterizedType()) {
            Type[] actualTypes = new Type[rawTypes.length];
            actualTypes[0] = this.owner.getOwnerType().getType();
            int pos = 1;
            for (Type parameterType : types) {
                actualTypes[pos++] = parameterType;
            }
            return actualTypes;
        }
        return types;
    }

    public Type[] getRawParameterTypes() {
        return this.constructor.getParameterTypes();
    }

    public Type getReturnType() {
        return this.owner.getType();
    }

    @Override
    public TypeVariable<?>[] getTypeParameters() {
        return this.constructor.getTypeParameters();
    }

    @Override
    public boolean isAccessible() {
        return TestUsageChecker.canUse(this.constructor);
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.constructor.getModifiers());
    }

    public boolean isOverloaded(List<VariableReference> parameters) {
        Class<?> declaringClass = this.constructor.getDeclaringClass();
        Class<?>[] parameterTypes = this.constructor.getParameterTypes();
        boolean isExact = true;
        Class[] parameterClasses = new Class[parameters.size()];
        int num = 0;
        for (VariableReference parameter : parameters) {
            parameterClasses[num] = parameter.getVariableClass();
            if (parameterClasses[num].equals(parameterTypes[num])) continue;
            isExact = false;
            break;
        }
        if (isExact) {
            return false;
        }
        try {
            for (Constructor<?> otherConstructor : declaringClass.getConstructors()) {
                if (otherConstructor.equals(this.constructor) || parameterTypes.length != otherConstructor.getParameterCount()) continue;
                boolean parametersEqual = true;
                Class<?>[] otherParameterTypes = otherConstructor.getParameterTypes();
                for (int i = 0; i < parameterClasses.length; ++i) {
                    if (parameters.get(i).isAssignableTo(parameterTypes[i]) == parameters.get(i).isAssignableTo(otherParameterTypes[i])) continue;
                    parametersEqual = false;
                    break;
                }
                if (!parametersEqual) continue;
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        Class<?> constructorClass = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass((String)ois.readObject());
        String constructorDesc = (String)ois.readObject();
        for (Constructor<?> constructor : constructorClass.getDeclaredConstructors()) {
            if (!org.evosuite.shaded.org.objectweb.asm.Type.getConstructorDescriptor(constructor).equals(constructorDesc)) continue;
            this.constructor = constructor;
            return;
        }
        throw new IllegalStateException("Unknown constructor in class " + constructorClass.getCanonicalName());
    }

    @Override
    public String toString() {
        return this.constructor.toGenericString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.constructor.getDeclaringClass().getName());
        oos.writeObject(org.evosuite.shaded.org.objectweb.asm.Type.getConstructorDescriptor(this.constructor));
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.constructor.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.constructor.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.constructor.getModifiers());
    }

    @Override
    public boolean isDefault() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constructor == null ? 0 : this.constructor.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericConstructor other = (GenericConstructor)obj;
        return !(this.constructor == null ? other.constructor != null : !this.constructor.equals(other.constructor));
    }
}

