/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import org.evosuite.shaded.org.apache.commons.lang3.StringEscapeUtils;
import org.evosuite.testcase.TestCodeVisitor;

public class NumberFormatter {
    public static String getNumberString(Object value) {
        return NumberFormatter.getNumberString(value, null);
    }

    public static String getNumberString(Object value, TestCodeVisitor visitor) {
        if (value == null) {
            return "null";
        }
        if (value.getClass().equals(Character.TYPE) || value.getClass().equals(Character.class)) {
            if (Character.valueOf('\'').equals(value)) {
                return "'\\''";
            }
            return "'" + StringEscapeUtils.escapeJava(Character.toString(((Character)value).charValue())) + "'";
        }
        if (value.getClass().equals(String.class)) {
            return "\"" + StringEscapeUtils.escapeJava((String)value) + "\"";
        }
        if (value.getClass().equals(Float.TYPE) || value.getClass().equals(Float.class)) {
            if (value.toString().equals("NaN")) {
                return "Float.NaN";
            }
            if (value.toString().equals("-Infinity")) {
                return "Float.NEGATIVE_INFINITY";
            }
            if (value.toString().equals("Infinity")) {
                return "Float.POSITIVE_INFINITY";
            }
            if (((Float)value).floatValue() < 0.0f) {
                return "(" + value + "F)";
            }
            return value + "F";
        }
        if (value.getClass().equals(Double.TYPE) || value.getClass().equals(Double.class)) {
            if (value.toString().equals("NaN")) {
                return "Double.NaN";
            }
            if (value.toString().equals("-Infinity")) {
                return "Double.NEGATIVE_INFINITY";
            }
            if (value.toString().equals("Infinity")) {
                return "Double.POSITIVE_INFINITY";
            }
            if ((Double)value < 0.0) {
                return "(" + value + ")";
            }
            return value.toString();
        }
        if (value.getClass().equals(Long.TYPE) || value.getClass().equals(Long.class)) {
            if ((Long)value < 0L) {
                return "(" + value + "L)";
            }
            return value + "L";
        }
        if (value.getClass().equals(Byte.TYPE) || value.getClass().equals(Byte.class)) {
            if ((Byte)value < 0) {
                return "(byte) (" + value + ")";
            }
            return "(byte)" + value;
        }
        if (value.getClass().equals(Short.TYPE) || value.getClass().equals(Short.class)) {
            if ((Short)value < 0) {
                return "(short) (" + value + ")";
            }
            return "(short)" + value;
        }
        if (value.getClass().equals(Integer.TYPE) || value.getClass().equals(Integer.class)) {
            int val = (Integer)value;
            if (val == Integer.MAX_VALUE) {
                return "Integer.MAX_VALUE";
            }
            if (val == Integer.MIN_VALUE) {
                return "Integer.MIN_VALUE";
            }
            if ((Integer)value < 0) {
                return "(" + value + ")";
            }
            return "" + val;
        }
        if (value.getClass().isEnum() || value instanceof Enum) {
            String className;
            Class<?> enumClass = value.getClass();
            if (enumClass.isAnonymousClass()) {
                enumClass = enumClass.getEnclosingClass();
            }
            if (visitor != null) {
                className = visitor.getClassName(enumClass);
            } else {
                Class<?> clazz = enumClass;
                className = clazz.getSimpleName();
                while (clazz.getEnclosingClass() != null) {
                    String enclosingName = clazz.getEnclosingClass().getSimpleName();
                    className = enclosingName + "." + className;
                    clazz = clazz.getEnclosingClass();
                }
            }
            if (!className.endsWith(".")) {
                className = className + ".";
            }
            try {
                if (value.getClass().getField(value.toString()) != null) {
                    return className + value;
                }
                if (((Enum)value).name() != null) {
                    return className + ((Enum)value).name();
                }
                return "Enum.valueOf(" + className + "class, \"" + value + "\")";
            }
            catch (Throwable t) {
                if (((Enum)value).name() != null) {
                    return className + ((Enum)value).name();
                }
                return "Enum.valueOf(" + className + "class /* " + t + " */, \"" + value + "\")";
            }
        }
        if (value.getClass().equals(Boolean.class)) {
            return value.toString();
        }
        assert (false);
        return value.toString();
    }

    public static String getBoxedClassName(Object value) {
        if (value.getClass().equals(Double.class)) {
            return "double";
        }
        if (value.getClass().equals(Float.class)) {
            return "float";
        }
        if (value.getClass().equals(Long.class)) {
            return "long";
        }
        if (value.getClass().equals(Boolean.class)) {
            return "boolean";
        }
        if (value.getClass().equals(Short.class)) {
            return "short";
        }
        if (value.getClass().equals(Integer.class)) {
            return "int";
        }
        if (value.getClass().equals(Byte.class)) {
            return "byte";
        }
        if (value.getClass().equals(Character.class)) {
            return "char";
        }
        return value.getClass().getSimpleName();
    }
}

