/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.evosuite.Properties;
import org.evosuite.utils.Randomness;

public abstract class ListUtil {
    public static <T> List<T> tail(List<T> list) {
        return list.subList(1, list.size());
    }

    public static <T> boolean anyEquals(List<T> list, T obj) {
        for (T item : list) {
            if (!item.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> shuffledList(List<T> list) {
        ArrayList<T> result = new ArrayList<T>(list);
        Collections.shuffle(result);
        return result;
    }

    public static <T> List<T> shuffledList(List<T> list, Random rnd) {
        ArrayList<T> result = new ArrayList<T>(list);
        Collections.shuffle(result, rnd);
        return result;
    }

    private static int getIndex(List<?> population) {
        double r = Randomness.nextDouble();
        double d = Properties.RANK_BIAS - Math.sqrt(Properties.RANK_BIAS * Properties.RANK_BIAS - 4.0 * (Properties.RANK_BIAS - 1.0) * r);
        int length = population.size();
        d = d / 2.0 / (Properties.RANK_BIAS - 1.0);
        int index = (int)((double)length * d);
        return index;
    }

    public static <T> T selectRankBiased(List<T> list) {
        int index = ListUtil.getIndex(list);
        return list.get(index);
    }
}

