/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.shaded.org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIOUtils {
    private static Logger logger = LoggerFactory.getLogger(FileIOUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile(File file) {
        LinkedList<String> content = new LinkedList<String>();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
            try (BufferedReader in = new BufferedReader(reader);){
                String str;
                while ((str = in.readLine()) != null) {
                    content.add(str);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while reading file " + file.getName() + " , " + e.getMessage(), e);
        }
        return content;
    }

    public static void writeFile(String content, String fileName) {
        try {
            FileUtils.writeStringToFile(new File(fileName), content);
        }
        catch (IOException e) {
            logger.error("Error while writing file " + fileName + " , " + e.getMessage(), e);
        }
    }

    public static void writeFile(String content, File file) {
        try {
            FileUtils.writeStringToFile(file, content);
        }
        catch (Exception e) {
            logger.error("Error while reading file " + file.getName() + " , " + e.getMessage(), e);
        }
    }

    public static void writeXML(Object data, String fileName) {
        try {
            XStream xstream = new XStream();
            FileUtils.writeStringToFile(new File(fileName), xstream.toXML(data));
        }
        catch (Exception e) {
            logger.error("Error while writing file " + fileName + " , " + e.getMessage(), e);
        }
    }

    public static <T> T readXML(String fileName) {
        XStream xstream = new XStream();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileName), "utf-8");
            BufferedReader in = new BufferedReader(reader);
            return (T)xstream.fromXML(in);
        }
        catch (Exception e) {
            logger.error("Error while reading file " + fileName + " , " + e.getMessage(), e);
            return null;
        }
    }

    public static List<File> getRecursivelyAllFilesInAllSubfolders(File folder, String suffix) throws IllegalArgumentException {
        Inputs.checkNull(folder, suffix);
        ArrayList<File> buffer = new ArrayList<File>();
        FileIOUtils._recursiveAllFiles(folder, suffix, buffer);
        return buffer;
    }

    public static List<File> getRecursivelyAllFilesInAllSubfolders(String base, String suffix) throws IllegalArgumentException {
        Inputs.checkNull(base, suffix);
        return FileIOUtils.getRecursivelyAllFilesInAllSubfolders(new File(base), suffix);
    }

    private static void _recursiveAllFiles(File folder, String suffix, List<File> buffer) {
        if (!folder.exists()) {
            throw new IllegalArgumentException("Folder does not exist: " + folder.getAbsolutePath());
        }
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("File is not a folder: " + folder.getAbsolutePath());
        }
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                FileIOUtils._recursiveAllFiles(file, suffix, buffer);
                continue;
            }
            if (!file.getName().endsWith(suffix)) continue;
            buffer.add(file);
        }
    }

    public static void copyDirectoryAndOverwriteFilesIfNeeded(File srcDir, File destDir) throws IllegalArgumentException, IOException {
        if (srcDir == null || destDir == null) {
            throw new IllegalArgumentException("Null inputs");
        }
        if (!srcDir.exists()) {
            throw new IllegalArgumentException("Source folder does not exist: " + srcDir.getAbsolutePath());
        }
        FileIOUtils.recursiveCopy(srcDir, destDir);
    }

    private static void recursiveCopy(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdirs();
            }
            for (String file : src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                FileIOUtils.recursiveCopy(srcFile, destFile);
            }
        } else {
            boolean sameTime;
            boolean bl = sameTime = src.lastModified() == dest.lastModified();
            if (sameTime) {
                return;
            }
            try (FileInputStream in = new FileInputStream(src);
                 FileOutputStream out = new FileOutputStream(dest);){
                int length;
                byte[] buffer = new byte[2048];
                while ((length = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, length);
                }
            }
            dest.setLastModified(src.lastModified());
        }
    }
}

