/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.evosuite.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalProcessUtilities {
    protected static final Logger logger = LoggerFactory.getLogger(ExternalProcessUtilities.class);
    protected Socket connection;
    protected ObjectOutputStream out;
    protected ObjectInputStream in;

    public boolean connectToMainProcess() {
        try {
            this.connection = new Socket("127.0.0.1", Properties.PROCESS_COMMUNICATION_PORT);
            this.out = new ObjectOutputStream(this.connection.getOutputStream());
            this.in = new ObjectInputStream(this.connection.getInputStream());
        }
        catch (Exception e) {
            logger.error("not possible to connect to main process", e);
            return false;
        }
        return true;
    }

    public Object receiveInstruction() {
        try {
            String message = (String)this.in.readObject();
            if (message.equals("NEW_SEARCH")) {
                return null;
            }
            if (message.equals("CONTINUE_SEARCH")) {
                Object population_data = this.in.readObject();
                return population_data;
            }
        }
        catch (Exception e) {
            logger.error("error in receiving message", e);
        }
        throw new RuntimeException("no valid message received");
    }

    public void askForRestart(Object population_data) {
        this.sendFinalMessage("NEED_RESTART", population_data);
    }

    public void informSearchIsFinished(Object population_data) {
        this.sendFinalMessage("FINISHED_COMPUTATION", population_data);
    }

    public void sendFinalMessage(String message, Object population_data) {
        try {
            this.out.writeObject(message);
            this.out.flush();
            if (Properties.SERIALIZE_RESULT) {
                this.out.writeObject(population_data);
            } else {
                this.out.writeObject(null);
            }
            this.out.flush();
        }
        catch (Exception e) {
            logger.error("error in sending messages", e);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            logger.debug("Thread interrupted while waiting after sending results from client to master", e);
        }
    }
}

