/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TimeController;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.junit.CoverageAnalysis;
import org.evosuite.junit.writer.TestSuiteWriter;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.rmi.service.ClientStateInformation;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCaseMinimizer;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteMinimizer {
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteMinimizer.class);
    private final List<TestFitnessFactory<?>> testFitnessFactories = new ArrayList();
    protected static long startTime = 0L;

    public TestSuiteMinimizer(TestFitnessFactory<?> factory) {
        this.testFitnessFactories.add(factory);
    }

    public TestSuiteMinimizer(List<TestFitnessFactory<? extends TestFitnessFunction>> factories) {
        this.testFitnessFactories.addAll(factories);
    }

    public void minimize(TestSuiteChromosome suite, boolean minimizePerTest) {
        startTime = System.currentTimeMillis();
        Properties.SecondaryObjective strategy = Properties.SECONDARY_OBJECTIVE[0];
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Result_Size, suite.size());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Result_Length, suite.totalLengthOfTestCases());
        logger.info("Minimization Strategy: " + (Object)((Object)strategy) + ", " + suite.size() + " tests");
        suite.clearMutationHistory();
        if (minimizePerTest) {
            this.minimizeTests(suite);
        } else {
            this.minimizeSuite(suite);
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Minimized_Size, suite.size());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Minimized_Length, suite.totalLengthOfTestCases());
    }

    private void updateClientStatus(int progress) {
        ClientState state = ClientState.MINIMIZATION;
        ClientStateInformation information = new ClientStateInformation(state);
        information.setProgress(progress);
        ClientServices.getInstance().getClientNode().changeState(state, information);
    }

    private void filterJUnitCoveredGoals(List<TestFitnessFunction> goals) {
        String[] testClasses;
        if (Properties.JUNIT.isEmpty()) {
            return;
        }
        LoggingUtils.getEvoLogger().info("* Determining coverage of existing tests");
        for (String testClass : testClasses = Properties.JUNIT.split(":")) {
            try {
                Class<?> junitClass = Class.forName(testClass, true, TestGenerationContext.getInstance().getClassLoaderForSUT());
                Set<TestFitnessFunction> coveredGoals = CoverageAnalysis.getCoveredGoals(junitClass, goals);
                LoggingUtils.getEvoLogger().info("* Removing " + coveredGoals.size() + " goals already covered by JUnit (total: " + goals.size() + ")");
                goals.removeAll(coveredGoals);
                logger.info("Remaining goals: " + goals.size() + ": " + goals);
            }
            catch (ClassNotFoundException e) {
                LoggingUtils.getEvoLogger().warn("* Failed to find JUnit test suite: " + Properties.JUNIT);
            }
        }
    }

    private void minimizeTests(TestSuiteChromosome suite) {
        logger.info("Minimizing per test");
        ExecutionTracer.enableTraceCalls();
        for (Object test : suite.getTestChromosomes()) {
            ((TestChromosome)test).setChanged(true);
        }
        ArrayList<TestFitnessFunction> goals = new ArrayList<TestFitnessFunction>();
        for (TestFitnessFactory testFitnessFactory : this.testFitnessFactories) {
            goals.addAll(testFitnessFactory.getCoverageGoals());
        }
        this.filterJUnitCoveredGoals(goals);
        int currentGoal = 0;
        int n = goals.size();
        if (Properties.MINIMIZE_SORT) {
            Collections.sort(goals);
        }
        LinkedHashSet<TestFitnessFunction> covered = new LinkedHashSet<TestFitnessFunction>();
        ArrayList<TestChromosome> minimizedTests = new ArrayList<TestChromosome>();
        TestSuiteWriter minimizedSuite = new TestSuiteWriter();
        for (TestFitnessFunction goal : goals) {
            this.updateClientStatus(n > 0 ? 100 * currentGoal / n : 100);
            ++currentGoal;
            if (this.isTimeoutReached()) {
                logger.warn("Minimization timeout. Roll back to original test suite");
                return;
            }
            logger.info("Considering goal: " + goal);
            if (Properties.MINIMIZE_SKIP_COINCIDENTAL) {
                for (TestChromosome testChromosome : minimizedTests) {
                    if (this.isTimeoutReached()) {
                        logger.warn("Minimization timeout. Roll back to original test suite");
                        return;
                    }
                    if (!goal.isCovered(testChromosome)) continue;
                    logger.info("Covered by minimized test: " + goal);
                    covered.add(goal);
                    break;
                }
            }
            if (covered.contains(goal)) {
                logger.info("Already covered: " + goal);
                logger.info("Now the suite covers " + covered.size() + "/" + goals.size() + " goals");
                continue;
            }
            ArrayList<TestChromosome> coveringTests = new ArrayList<TestChromosome>();
            for (TestChromosome test3 : suite.getTestChromosomes()) {
                if (!goal.isCovered(test3)) continue;
                coveringTests.add(test3);
            }
            Collections.sort(coveringTests);
            if (!coveringTests.isEmpty()) {
                TestChromosome testChromosome = (TestChromosome)coveringTests.get(0);
                TestCaseMinimizer minimizer = new TestCaseMinimizer(goal);
                TestChromosome copy = (TestChromosome)testChromosome.clone();
                minimizer.minimize(copy);
                if (this.isTimeoutReached()) {
                    logger.warn("Minimization timeout. Roll back to original test suite");
                    return;
                }
                copy.getTestCase().clearCoveredGoals();
                for (TestFitnessFunction g : goals) {
                    if (!g.isCovered(copy)) continue;
                    covered.add(g);
                    logger.info("Goal covered by minimized test: " + g);
                }
                minimizedTests.add(copy);
                minimizedSuite.insertTest(copy.getTestCase());
                logger.info("After new test the suite covers " + covered.size() + "/" + goals.size() + " goals");
                continue;
            }
            logger.info("Goal is not covered: " + goal);
        }
        logger.info("Minimized suite covers " + covered.size() + "/" + goals.size() + " goals");
        suite.tests.clear();
        for (TestCase test : minimizedSuite.getTestCases()) {
            suite.addTest(test);
        }
        if (Properties.MINIMIZE_SECOND_PASS) {
            this.removeRedundantTestCases(suite, goals);
        }
        double suiteCoverage = suite.getCoverage();
        logger.info("Setting coverage to: " + suiteCoverage);
        ClientState state = ClientState.MINIMIZATION;
        ClientStateInformation clientStateInformation = new ClientStateInformation(state);
        clientStateInformation.setProgress(100);
        clientStateInformation.setCoverage((int)Math.round(suiteCoverage * 100.0));
        ClientServices.getInstance().getClientNode().changeState(state, clientStateInformation);
        for (TestFitnessFunction goal : goals) {
            if (covered.contains(goal)) continue;
            logger.info("Failed to cover: " + goal);
        }
    }

    private boolean isTimeoutReached() {
        return !TimeController.getInstance().isThereStillTimeInThisPhase();
    }

    private void minimizeSuite(TestSuiteChromosome suite) {
        for (ExecutableChromosome test : suite.getTestChromosomes()) {
            test.setChanged(true);
            test.clearCachedResults();
        }
        Properties.SecondaryObjective strategy = Properties.SECONDARY_OBJECTIVE[0];
        boolean size = false;
        if (strategy.equals("size")) {
            size = true;
            Collections.sort(suite.tests, new Comparator<TestChromosome>(){

                @Override
                public int compare(TestChromosome chromosome1, TestChromosome chromosome2) {
                    return chromosome1.size() - chromosome2.size();
                }
            });
        } else if (strategy.equals("maxlength")) {
            Collections.sort(suite.tests, new Comparator<TestChromosome>(){

                @Override
                public int compare(TestChromosome chromosome1, TestChromosome chromosome2) {
                    return chromosome2.size() - chromosome1.size();
                }
            });
        }
        ArrayList<TestFitnessFunction> goals = new ArrayList<TestFitnessFunction>();
        ArrayList<Double> fitness = new ArrayList<Double>();
        for (TestFitnessFactory<?> ff : this.testFitnessFactories) {
            goals.addAll(ff.getCoverageGoals());
            fitness.add(ff.getFitness(suite));
        }
        boolean changed = true;
        block4: while (changed && !this.isTimeoutReached()) {
            changed = false;
            this.removeEmptyTestCases(suite);
            block5: for (TestChromosome testChromosome : suite.tests) {
                if (this.isTimeoutReached()) continue block4;
                for (int i = testChromosome.size() - 1; i >= 0 && !this.isTimeoutReached(); --i) {
                    logger.debug("Current size: " + suite.size() + "/" + suite.totalLengthOfTestCases());
                    logger.debug("Deleting statement " + testChromosome.getTestCase().getStatement(i).getCode() + " from test");
                    TestChromosome originalTestChromosome = (TestChromosome)testChromosome.clone();
                    boolean modified = false;
                    try {
                        TestFactory testFactory = TestFactory.getInstance();
                        modified = testFactory.deleteStatementGracefully(testChromosome.getTestCase(), i);
                    }
                    catch (ConstructionFailedException e) {
                        modified = false;
                    }
                    if (!modified) {
                        testChromosome.setChanged(false);
                        testChromosome.setTestCase(originalTestChromosome.getTestCase());
                        logger.debug("Deleting failed");
                        continue;
                    }
                    testChromosome.setChanged(true);
                    testChromosome.getTestCase().clearCoveredGoals();
                    ArrayList<Double> modifiedVerFitness = new ArrayList<Double>();
                    for (TestFitnessFactory<?> ff : this.testFitnessFactories) {
                        modifiedVerFitness.add(ff.getFitness(suite));
                    }
                    int compare_ff = 0;
                    for (int i_fit = 0; i_fit < modifiedVerFitness.size(); ++i_fit) {
                        if (Double.compare((Double)modifiedVerFitness.get(i_fit), (Double)fitness.get(i_fit)) < 0) {
                            compare_ff = -1;
                            break;
                        }
                        if (Double.compare((Double)modifiedVerFitness.get(i_fit), (Double)fitness.get(i_fit)) <= 0) continue;
                        compare_ff = 1;
                        break;
                    }
                    if (compare_ff == 0) continue;
                    if (compare_ff < -1) {
                        fitness = modifiedVerFitness;
                        changed = true;
                        if (size) continue;
                        continue block5;
                    }
                    if (compare_ff != 1) continue;
                    logger.debug("Can't remove statement " + originalTestChromosome.getTestCase().getStatement(i).getCode());
                    logger.debug("Restoring fitness from " + modifiedVerFitness + " to " + fitness);
                    testChromosome.setTestCase(originalTestChromosome.getTestCase());
                    testChromosome.setLastExecutionResult(originalTestChromosome.getLastExecutionResult());
                    testChromosome.setChanged(false);
                }
            }
        }
        this.removeEmptyTestCases(suite);
        this.removeRedundantTestCases(suite, goals);
    }

    private void removeEmptyTestCases(TestSuiteChromosome suite) {
        Iterator it = suite.tests.iterator();
        while (it.hasNext()) {
            ExecutableChromosome test = (ExecutableChromosome)it.next();
            if (test.size() != 0) continue;
            logger.debug("Removing empty test case");
            it.remove();
        }
    }

    private void removeRedundantTestCases(TestSuiteChromosome suite, List<TestFitnessFunction> goals) {
        List tests = suite.getTestChromosomes();
        logger.debug("Before removing redundant tests: " + tests.size());
        Collections.reverse(tests);
        ArrayList<TestChromosome> finalTests = new ArrayList<TestChromosome>();
        LinkedHashSet<TestFitnessFunction> coveredGoals = new LinkedHashSet<TestFitnessFunction>();
        for (TestChromosome test : tests) {
            boolean addsNewGoals = false;
            for (TestFitnessFunction goal : goals) {
                if (coveredGoals.contains(goal) || !goal.isCovered(test)) continue;
                addsNewGoals = true;
                coveredGoals.add(goal);
            }
            if (!addsNewGoals) continue;
            coveredGoals.addAll(test.getTestCase().getCoveredGoals());
            finalTests.add(test);
        }
        Collections.reverse(finalTests);
        suite.getTestChromosomes().clear();
        suite.getTestChromosomes().addAll(finalTests);
        logger.debug("After removing redundant tests: " + tests.size());
    }
}

