/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.SecondaryObjective;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.localsearch.TestSuiteLocalSearch;

public class TestSuiteChromosome
extends AbstractTestSuiteChromosome<TestChromosome> {
    private static final List<SecondaryObjective<?>> secondaryObjectives = new ArrayList();
    private static int secondaryObjIndex = 0;
    private static final long serialVersionUID = 88380759969800800L;

    public static void addSecondaryObjective(SecondaryObjective<?> objective) {
        secondaryObjectives.add(objective);
    }

    public static void ShuffleSecondaryObjective() {
        Collections.shuffle(secondaryObjectives);
    }

    public static int getSecondaryObjectivesSize() {
        return secondaryObjectives.size();
    }

    public static boolean isFirstSecondaryObjectiveEnabled() {
        return secondaryObjIndex == 0;
    }

    public static void disableFirstSecondaryObjective() {
        if (secondaryObjIndex != 1) {
            secondaryObjIndex = 1;
        }
    }

    public static void enableFirstSecondaryObjective() {
        if (secondaryObjIndex != 0) {
            secondaryObjIndex = 0;
        }
    }

    public static void reverseSecondaryObjective() {
        Collections.reverse(secondaryObjectives);
    }

    public static void removeSecondaryObjective(SecondaryObjective<TestSuiteChromosome> objective) {
        secondaryObjectives.remove(objective);
    }

    public static void removeAllSecondaryObjectives() {
        secondaryObjectives.clear();
    }

    public TestSuiteChromosome() {
    }

    public TestSuiteChromosome(ChromosomeFactory<TestChromosome> testChromosomeFactory) {
        super(testChromosomeFactory);
    }

    protected TestSuiteChromosome(TestSuiteChromosome source) {
        super(source);
    }

    public TestChromosome addTest(TestCase test) {
        TestChromosome c = new TestChromosome();
        c.setTestCase(test);
        this.addTest(c);
        return c;
    }

    public void clearMutationHistory() {
        for (TestChromosome test : this.tests) {
            test.getMutationHistory().clear();
        }
    }

    public void clearTests() {
        this.tests.clear();
    }

    @Override
    public TestSuiteChromosome clone() {
        return new TestSuiteChromosome(this);
    }

    @Override
    public <T extends Chromosome> int compareSecondaryObjective(T o) {
        SecondaryObjective<?> so;
        int objective = secondaryObjIndex;
        int c = 0;
        while (c == 0 && objective < secondaryObjectives.size() && (so = secondaryObjectives.get(objective++)) != null) {
            c = so.compareChromosomes(this, o);
        }
        return c;
    }

    @Override
    public void deleteTest(TestCase testCase) {
        if (testCase != null) {
            for (int i = 0; i < this.tests.size(); ++i) {
                if (!((TestChromosome)this.tests.get(i)).getTestCase().equals(testCase)) continue;
                this.tests.remove(i);
            }
        }
    }

    public Set<TestFitnessFunction> getCoveredGoals() {
        LinkedHashSet<TestFitnessFunction> goals = new LinkedHashSet<TestFitnessFunction>();
        for (TestChromosome test : this.tests) {
            Set<TestFitnessFunction> goalsForTest = test.getTestCase().getCoveredGoals();
            goals.addAll(goalsForTest);
        }
        return goals;
    }

    public void removeCoveredGoal(TestFitnessFunction f) {
        for (TestChromosome test : this.tests) {
            if (!test.getTestCase().getCoveredGoals().remove(f)) continue;
        }
    }

    public List<TestCase> getTests() {
        ArrayList<TestCase> testcases = new ArrayList<TestCase>();
        for (TestChromosome test : this.tests) {
            testcases.add(test.getTestCase());
        }
        return testcases;
    }

    @Override
    public boolean localSearch(LocalSearchObjective<? extends Chromosome> objective) {
        TestSuiteLocalSearch localSearch = TestSuiteLocalSearch.selectTestSuiteLocalSearch();
        return localSearch.doSearch(this, objective);
    }

    @Override
    public void mutate() {
        for (int i = 0; i < Properties.NUMBER_OF_MUTATIONS; ++i) {
            super.mutate();
        }
    }

    public String toString() {
        String result = "TestSuite: " + this.tests.size() + "\n";
        int i = 0;
        for (TestChromosome test : this.tests) {
            result = result + "Test " + i + ": \n";
            ++i;
            if (test.getLastExecutionResult() != null) {
                result = result + test.getTestCase().toCode(test.getLastExecutionResult().exposeExceptionMapping());
                continue;
            }
            result = result + test.getTestCase().toCode() + "\n";
        }
        return result;
    }
}

