/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.bloatcontrol.BloatControlFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;

public class RelativeSuiteLengthBloatControl
implements BloatControlFunction,
SearchListener {
    private static final long serialVersionUID = -2352882640530431653L;
    protected int current_max = 0;
    protected double best_fitness = Double.MAX_VALUE;

    @Override
    public boolean isTooLong(Chromosome chromosome) {
        if (chromosome.getFitness() < this.best_fitness) {
            return false;
        }
        if (this.current_max > 0) {
            int length = 0;
            if (chromosome instanceof TestSuiteChromosome) {
                length = ((TestSuiteChromosome)chromosome).totalLengthOfTestCases();
            }
            if (chromosome instanceof TestChromosome) {
                length = ((TestChromosome)chromosome).size();
            }
            return length > Properties.BLOAT_FACTOR * this.current_max;
        }
        return false;
    }

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
        Object best = algorithm.getBestIndividual();
        if (best instanceof TestSuiteChromosome) {
            this.current_max = ((TestSuiteChromosome)best).totalLengthOfTestCases();
        }
        if (best instanceof TestChromosome) {
            this.current_max = ((TestChromosome)best).size();
        }
        this.best_fitness = ((Chromosome)best).getFitness();
    }

    @Override
    public void searchFinished(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void fitnessEvaluation(Chromosome result) {
    }

    @Override
    public void modification(Chromosome individual) {
    }
}

