/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TestSuiteGeneratorHelper;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.junit.JUnitAnalyzer;
import org.evosuite.junit.writer.TestSuiteWriter;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteSerialization;
import org.evosuite.utils.LoggingUtils;

public class RegressionSuiteSerializer {
    private static final String BASE_PATH = Properties.SEED_DIR + File.separator + Properties.TARGET_CLASS;
    private static final String REGRESSION_FILE = BASE_PATH + ".regression";
    private static final String REGRESSION_ARCHIVE_FILE = BASE_PATH + ".regression_archive";
    private static final String JUNIT_ARCHIVE_SUFFIX = "_ESArchiveTest";

    public static void appendToRegressionTestSuite(TestSuiteChromosome testSuite) {
        List<TestChromosome> previousSuite = TestSuiteSerialization.loadTests(REGRESSION_FILE);
        LoggingUtils.getEvoLogger().info("* previousSuite.size(): " + previousSuite.size());
        RegressionSuiteSerializer.removeTestsThatDoNotcompile(previousSuite);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.NumRegressionTestCases, previousSuite.size());
        testSuite.addTests(previousSuite);
        TestSuiteSerialization.saveTests(testSuite, new File(REGRESSION_FILE));
    }

    private static void removeTestsThatDoNotcompile(List<TestChromosome> previousSuite) {
        boolean junitSeparateClassLoader = Properties.USE_SEPARATE_CLASSLOADER;
        Properties.USE_SEPARATE_CLASSLOADER = false;
        Iterator<TestChromosome> iterator = previousSuite.iterator();
        while (iterator.hasNext()) {
            TestCase tc = iterator.next().getTestCase();
            ArrayList<TestCase> testCases = new ArrayList<TestCase>();
            testCases.add(tc);
            JUnitAnalyzer.removeTestsThatDoNotCompile(testCases);
            if (!testCases.isEmpty()) continue;
            iterator.remove();
        }
        Properties.USE_SEPARATE_CLASSLOADER = junitSeparateClassLoader;
    }

    public static void storeRegressionArchive() {
        TestSuiteChromosome testArchive = RegressionSuiteSerializer.getAppendedRegressionSuiteArchive();
        TestSuiteWriter suiteWriter = new TestSuiteWriter();
        suiteWriter.insertTests(testArchive.getTests());
        String name = Properties.TARGET_CLASS.substring(Properties.TARGET_CLASS.lastIndexOf(".") + 1);
        String testDir = Properties.TEST_DIR;
        LoggingUtils.getEvoLogger().info("* Writing Archive JUnit test case '" + name + JUNIT_ARCHIVE_SUFFIX + "' to " + testDir);
        suiteWriter.writeTestSuite(name + JUNIT_ARCHIVE_SUFFIX, testDir, testArchive.getLastExecutionResults());
        TestSuiteSerialization.saveTests(testArchive, new File(REGRESSION_ARCHIVE_FILE));
    }

    private static TestSuiteChromosome getAppendedRegressionSuiteArchive() {
        List<TestChromosome> previousArchive = TestSuiteSerialization.loadTests(REGRESSION_ARCHIVE_FILE);
        LoggingUtils.getEvoLogger().info("* previousArchive.size(): " + previousArchive.size());
        previousArchive.forEach(t -> t.getTestCase().removeAssertions());
        RegressionSuiteSerializer.removeTestsThatDoNotcompile(previousArchive);
        Properties.TEST_ARCHIVE = false;
        TestSuiteChromosome archiveSuite = new TestSuiteChromosome();
        archiveSuite.addTests(previousArchive);
        BranchCoverageSuiteFitness branchCoverageSuiteFitness = new BranchCoverageSuiteFitness(TestGenerationContext.getInstance().getClassLoaderForSUT());
        branchCoverageSuiteFitness.getFitness(archiveSuite);
        LoggingUtils.getEvoLogger().info("* archive covered goals: " + archiveSuite.getCoveredGoals().size());
        Properties.TEST_ARCHIVE = true;
        TestSuiteChromosome testArchive = Archive.getArchiveInstance().mergeArchiveAndSolution(archiveSuite);
        LoggingUtils.getEvoLogger().info("* newArchive.size(): " + testArchive.size());
        LoggingUtils.getEvoLogger().info("* new covered goals: " + testArchive.getCoveredGoals().size());
        Properties.AssertionStrategy tmpStrategy = Properties.ASSERTION_STRATEGY;
        Properties.ASSERTION_STRATEGY = Properties.AssertionStrategy.ALL;
        TestSuiteGeneratorHelper.addAssertions(testArchive);
        Properties.ASSERTION_STRATEGY = tmpStrategy;
        return testArchive;
    }
}

