/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.ga.operators.mutation.MutationDistribution;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestSuiteChromosome<T extends ExecutableChromosome>
extends Chromosome {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractTestSuiteChromosome.class);
    protected List<T> tests = new ArrayList<T>();
    protected ChromosomeFactory<T> testChromosomeFactory;

    protected AbstractTestSuiteChromosome() {
    }

    protected AbstractTestSuiteChromosome(ChromosomeFactory<T> testChromosomeFactory) {
        this.testChromosomeFactory = testChromosomeFactory;
    }

    public ChromosomeFactory<T> getTestChromosomeFactory() {
        return this.testChromosomeFactory;
    }

    protected AbstractTestSuiteChromosome(AbstractTestSuiteChromosome<T> source) {
        this(source.testChromosomeFactory);
        for (ExecutableChromosome test : source.tests) {
            this.addTest((ExecutableChromosome)test.clone());
        }
        this.setFitnessValues(source.getFitnessValues());
        this.setPreviousFitnessValues(source.getPreviousFitnessValues());
        this.setChanged(source.isChanged());
        this.setCoverageValues(source.getCoverageValues());
        this.setNumsOfCoveredGoals(source.getNumsOfCoveredGoals());
        this.setNumsOfNotCoveredGoals(source.getNumsNotCoveredGoals());
        this.setNumberOfMutations(source.getNumberOfMutations());
        this.setNumberOfEvaluations(source.getNumberOfEvaluations());
        this.setKineticEnergy(source.getKineticEnergy());
        this.setNumCollisions(source.getNumCollisions());
    }

    public void addTest(T test) {
        this.tests.add(test);
        this.setChanged(true);
    }

    public void deleteTest(T test) {
        boolean changed = this.tests.remove(test);
        if (changed) {
            this.setChanged(true);
        }
    }

    public void addTests(Collection<T> tests) {
        for (ExecutableChromosome test : tests) {
            this.tests.add(test);
        }
        if (!tests.isEmpty()) {
            this.setChanged(true);
        }
    }

    public void addUnmodifiableTest(T test) {
        this.tests.add(test);
        this.setChanged(true);
    }

    @Override
    public void crossOver(Chromosome other, int position) throws ConstructionFailedException {
        if (!(other instanceof AbstractTestSuiteChromosome)) {
            throw new IllegalArgumentException("AbstractTestSuiteChromosome.crossOver() called with parameter of unsupported type " + other.getClass());
        }
        AbstractTestSuiteChromosome chromosome = (AbstractTestSuiteChromosome)other;
        ExecutableChromosome otherTest = (ExecutableChromosome)chromosome.tests.get(position);
        ExecutableChromosome clonedTest = (ExecutableChromosome)otherTest.clone();
        this.tests.add(clonedTest);
        this.setChanged(true);
    }

    @Override
    public void crossOver(Chromosome other, int position1, int position2) throws ConstructionFailedException {
        if (!(other instanceof AbstractTestSuiteChromosome)) {
            throw new IllegalArgumentException("AbstractTestSuiteChromosome.crossOver() called with parameter of unsupported type " + other.getClass());
        }
        AbstractTestSuiteChromosome chromosome = (AbstractTestSuiteChromosome)other;
        while (this.tests.size() > position1) {
            this.tests.remove(position1);
        }
        for (int num = position2; num < other.size(); ++num) {
            ExecutableChromosome otherTest = (ExecutableChromosome)chromosome.tests.get(num);
            ExecutableChromosome clonedTest = (ExecutableChromosome)otherTest.clone();
            this.tests.add(clonedTest);
        }
        this.setChanged(true);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TestSuiteChromosome)) {
            return false;
        }
        TestSuiteChromosome other = (TestSuiteChromosome)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((ExecutableChromosome)this.tests.get(i)).equals(other.tests.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.tests.hashCode();
    }

    @Override
    public void mutate() {
        ExecutableChromosome test;
        boolean changed = false;
        MutationDistribution probabilityDistribution = MutationDistribution.getMutationDistribution(this.tests.size());
        for (int i = 0; i < this.tests.size(); ++i) {
            ExecutableChromosome test2 = (ExecutableChromosome)this.tests.get(i);
            if (!probabilityDistribution.toMutate(i)) continue;
            test2.mutate();
            if (!test2.isChanged()) continue;
            changed = true;
        }
        double ALPHA = Properties.P_TEST_INSERTION;
        int count = 1;
        while (Randomness.nextDouble() <= Math.pow(ALPHA, count) && this.size() < Properties.MAX_SIZE) {
            test = (ExecutableChromosome)this.testChromosomeFactory.getChromosome();
            this.addTest(test);
            logger.debug("Adding new test case");
            changed = true;
            ++count;
        }
        Iterator<T> testIterator = this.tests.iterator();
        while (testIterator.hasNext()) {
            test = (ExecutableChromosome)testIterator.next();
            if (test.size() != 0) continue;
            testIterator.remove();
        }
        if (changed) {
            this.increaseNumberOfMutations();
            this.setChanged(true);
        }
    }

    public int totalLengthOfTestCases() {
        int length = 0;
        for (ExecutableChromosome test : this.tests) {
            length += test.size();
        }
        return length;
    }

    @Override
    public int size() {
        return this.tests.size();
    }

    @Override
    public abstract boolean localSearch(LocalSearchObjective<? extends Chromosome> var1);

    @Override
    public abstract Chromosome clone();

    public T getTestChromosome(int index) {
        return (T)((ExecutableChromosome)this.tests.get(index));
    }

    public List<T> getTestChromosomes() {
        return this.tests;
    }

    public List<ExecutionResult> getLastExecutionResults() {
        return this.tests.stream().map(t -> t.getLastExecutionResult()).collect(Collectors.toList());
    }

    public void setTestChromosome(int index, T test) {
        this.tests.set(index, test);
        this.setChanged(true);
    }
}

