/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.variable;

import java.util.Arrays;
import java.util.List;
import org.evosuite.shaded.org.apache.commons.lang3.ArrayUtils;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testcase.variable.VariableReferenceImpl;
import org.evosuite.utils.generic.GenericClass;

public class ArrayReference
extends VariableReferenceImpl {
    private static final long serialVersionUID = 3309591356542131910L;
    private int[] lengths;

    public ArrayReference(TestCase tc, Class<?> clazz) {
        this(tc, new GenericClass(clazz), new int[ArrayStatement.determineDimensions(clazz)]);
    }

    public ArrayReference(TestCase tc, GenericClass clazz, int[] lengths) {
        super(tc, clazz);
        assert (lengths.length > 0);
        this.setLengths(lengths);
    }

    public ArrayReference(TestCase tc, GenericClass clazz, int array_length) {
        this(tc, clazz, new int[]{array_length});
    }

    public int getArrayLength() {
        return this.lengths[0];
    }

    public void setArrayLength(int l) {
        assert (l >= 0);
        this.lengths[0] = l;
    }

    public List<Integer> getLengths() {
        return Arrays.asList(ArrayUtils.toObject(this.lengths));
    }

    public void setLengths(int[] lengths) {
        this.lengths = new int[lengths.length];
        for (int i = 0; i < lengths.length; ++i) {
            this.lengths[i] = lengths[i];
        }
    }

    @Override
    public VariableReference copy(TestCase newTestCase, int offset) {
        VariableReference newRef = newTestCase.getStatement(this.getStPosition() + offset).getReturnValue();
        if (newRef instanceof ArrayReference) {
            ArrayReference otherArray = (ArrayReference)newRef;
            otherArray.setLengths(this.lengths);
            return otherArray;
        }
        if (newRef.getComponentType() != null) {
            ArrayReference otherArray = new ArrayReference(newTestCase, this.type, this.lengths);
            newTestCase.getStatement(this.getStPosition() + offset).setRetval(otherArray);
            return otherArray;
        }
        ArrayReference otherArray = new ArrayReference(newTestCase, this.type, this.lengths);
        newTestCase.getStatement(this.getStPosition() + offset).setRetval(otherArray);
        return otherArray;
    }

    public int getArrayDimensions() {
        return this.lengths.length;
    }

    public void setLengths(List<Integer> lengths) {
        this.lengths = new int[lengths.size()];
        int idx = 0;
        for (Integer length : lengths) {
            this.lengths[idx] = length;
            ++idx;
        }
    }

    public int getMaximumIndex() {
        int max = 0;
        for (Statement s : this.testCase) {
            for (VariableReference var : s.getVariableReferences()) {
                ArrayIndex index;
                if (!(var instanceof ArrayIndex) || !(index = (ArrayIndex)var).getArray().equals(this)) continue;
                max = Math.max(max, index.getArrayIndex());
            }
        }
        return max;
    }

    public boolean isInitialized(int index) {
        return this.isInitialized(index, this.testCase.size());
    }

    public boolean isInitialized(int index, int position) {
        int pos = 0;
        for (Statement s : this.testCase) {
            ArrayIndex ai;
            VariableReference ret;
            if (pos++ >= position) {
                return false;
            }
            if (!(s instanceof AssignmentStatement) || !((ret = s.getReturnValue()) instanceof ArrayIndex) || !(ai = (ArrayIndex)ret).getArray().equals(this) || ai.getArrayIndex() != index) continue;
            return true;
        }
        return false;
    }
}

