/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.assertion.Assertion;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCodeVisitor;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.EvosuiteError;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testcase.variable.VariableReferenceImpl;
import org.evosuite.utils.generic.GenericClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatement
implements Statement,
Serializable {
    private static final long serialVersionUID = 8993506743384548704L;
    protected static final Logger logger = LoggerFactory.getLogger(AbstractStatement.class);
    protected VariableReference retval;
    protected final TestCase tc;
    protected Set<Assertion> assertions = new LinkedHashSet<Assertion>();
    protected String comment = "";

    protected AbstractStatement(TestCase tc, VariableReference retval) throws IllegalArgumentException {
        if (tc == null) {
            throw new IllegalArgumentException("tc cannot be null");
        }
        if (retval == null) {
            throw new IllegalArgumentException("retval cannot be null");
        }
        this.retval = retval;
        this.tc = tc;
    }

    protected AbstractStatement(TestCase tc, Type type) throws IllegalArgumentException {
        if (tc == null) {
            throw new IllegalArgumentException("tc cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        GenericClass c = new GenericClass(type);
        this.retval = c.isArray() ? new ArrayReference(tc, c, 0) : new VariableReferenceImpl(tc, type);
        this.tc = tc;
    }

    protected Throwable exceptionHandler(Executer code) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        try {
            code.execute();
        }
        catch (CodeUnderTestException e) {
            return e;
        }
        catch (EvosuiteError e) {
            throw e;
        }
        catch (Error e) {
            if (this.isAssignableFrom(e, code.throwableExceptions())) {
                throw e;
            }
            return e;
        }
        catch (RuntimeException e) {
            if (this.isAssignableFrom(e, code.throwableExceptions())) {
                throw e;
            }
            return e;
        }
        catch (InvocationTargetException e) {
            if (this.isAssignableFrom(e, code.throwableExceptions())) {
                throw e;
            }
            return e;
        }
        catch (IllegalAccessException e) {
            if (this.isAssignableFrom(e, code.throwableExceptions())) {
                throw e;
            }
            return e;
        }
        catch (InstantiationException e) {
            if (this.isAssignableFrom(e, code.throwableExceptions())) {
                throw e;
            }
            return e;
        }
        return null;
    }

    private boolean isAssignableFrom(Throwable concreteThrowable, Set<Class<? extends Throwable>> throwableClasses) {
        for (Class<? extends Throwable> t : throwableClasses) {
            if (!t.isAssignableFrom(concreteThrowable.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean references(VariableReference var) {
        return this.getVariableReferences().contains(var);
    }

    protected Set<VariableReference> getAssertionReferences() {
        LinkedHashSet<VariableReference> variables = new LinkedHashSet<VariableReference>();
        for (Assertion assertion : this.assertions) {
            variables.addAll(assertion.getReferencedVariables());
        }
        return variables;
    }

    @Override
    public void setRetval(VariableReference newRetVal) throws IllegalArgumentException {
        if (newRetVal == null) {
            throw new IllegalArgumentException("newRetVal cannot be null");
        }
        this.retval = newRetVal;
    }

    @Override
    public String getCode() {
        return this.getCode(null);
    }

    @Override
    public String getCode(Throwable exception) {
        TestCodeVisitor visitor = new TestCodeVisitor();
        visitor.setException(this, exception);
        visitor.visitStatement(this);
        String code = visitor.getCode();
        return code.substring(0, code.length() - 2);
    }

    @Override
    public void addComment(String comment) {
        this.comment = this.comment + comment;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public final Statement clone() {
        throw new UnsupportedOperationException("Use statementInterface.clone(TestCase)");
    }

    @Override
    public Type getReturnType() {
        return this.retval.getType();
    }

    @Override
    public Class<?> getReturnClass() {
        return this.retval.getVariableClass();
    }

    @Override
    public VariableReference getReturnValue() {
        return this.retval;
    }

    @Override
    public int getNumParameters() {
        return 0;
    }

    @Override
    public TestCase getTestCase() {
        return this.tc;
    }

    @Override
    public Set<Assertion> copyAssertions(TestCase newTestCase, int offset) {
        LinkedHashSet<Assertion> copy = new LinkedHashSet<Assertion>();
        for (Assertion a : this.assertions) {
            if (a == null) {
                logger.info("Assertion is null!");
                logger.info("Statement has assertions: " + this.assertions.size());
                continue;
            }
            copy.add(a.copy(newTestCase, offset));
        }
        return copy;
    }

    @Override
    public boolean hasAssertions() {
        return !this.assertions.isEmpty();
    }

    @Override
    public void addAssertion(Assertion assertion) {
        if (assertion == null) {
            logger.warn("Trying to add null assertion!");
        } else {
            logger.debug("Adding assertion " + assertion.getCode());
            assert (assertion.isValid()) : "Invalid assertion detected: " + assertion.getCode() + ", " + assertion.getSource() + ", " + assertion.getValue();
            assertion.setStatement(this);
            this.assertions.add(assertion);
        }
    }

    @Override
    public void setAssertions(Set<Assertion> assertions) {
        for (Assertion assertion : assertions) {
            assertion.setStatement(this);
        }
        this.assertions = assertions;
    }

    @Override
    public String getAssertionCode() {
        String ret_val = "";
        for (Assertion a : this.assertions) {
            if (a == null) continue;
            ret_val = ret_val + a.getCode() + "\n";
        }
        return ret_val;
    }

    @Override
    public void removeAssertions() {
        this.assertions.clear();
    }

    @Override
    public void removeAssertion(Assertion assertion) {
        this.assertions.remove(assertion);
    }

    @Override
    public Set<Assertion> getAssertions() {
        return this.assertions;
    }

    @Override
    public Set<Class<?>> getDeclaredExceptions() {
        HashSet ex = new HashSet();
        return ex;
    }

    public static Class<?> getExceptionClass(Throwable t) {
        Class<?> clazz = t.getClass();
        while (!Modifier.isPublic(clazz.getModifiers())) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    @Override
    public int getPosition() {
        return this.retval.getStPosition();
    }

    @Override
    public boolean isAccessible() {
        for (VariableReference var : this.getVariableReferences()) {
            if (var.isAccessible()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid() {
        this.retval.getStPosition();
        return true;
    }

    @Override
    public boolean isDeclaredException(Throwable t) {
        return false;
    }

    @Override
    public boolean mutate(TestCase test, TestFactory factory) {
        return false;
    }

    @Override
    public Statement clone(TestCase newTestCase) {
        Statement result = this.copy(newTestCase, 0);
        result.getReturnValue().setOriginalCode(this.retval.getOriginalCode());
        result.addComment(this.getComment());
        return result;
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        for (VariableReference var : this.getVariableReferences()) {
            var.changeClassLoader(loader);
        }
        for (Assertion assertion : this.assertions) {
            assertion.changeClassLoader(loader);
        }
    }

    public void negate() {
    }

    @Override
    public boolean isReflectionStatement() {
        return false;
    }

    protected abstract class Executer {
        protected Executer() {
        }

        public abstract void execute() throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException, CodeUnderTestException;

        public Set<Class<? extends Throwable>> throwableExceptions() {
            return new HashSet<Class<? extends Throwable>>();
        }
    }
}

