/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.localsearch.StatementLocalSearch;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceLocalSearch
extends StatementLocalSearch {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceLocalSearch.class);
    private int positionDelta = 0;

    @Override
    public int getPositionDelta() {
        return this.positionDelta;
    }

    @Override
    public boolean doSearch(TestChromosome test, int statement, LocalSearchObjective<TestChromosome> objective) {
        boolean hasImproved = false;
        int currentProbe = 0;
        this.backup(test);
        int oldLength = test.size();
        while (currentProbe < Properties.LOCAL_SEARCH_PROBES && !LocalSearchBudget.getInstance().isFinished()) {
            logger.info("Current probe on statement " + statement + ": " + currentProbe);
            ArrayList<Mutations> mutations = new ArrayList<Mutations>();
            mutations.add(Mutations.REPLACE);
            Statement st = test.getTestCase().getStatement(statement);
            if (!st.getReturnValue().isPrimitive() && !(st instanceof NullStatement)) {
                mutations.add(Mutations.CALL);
            }
            if (st.getNumParameters() > 0) {
                mutations.add(Mutations.PARAMETER);
            } else {
                mutations.remove((Object)Mutations.PARAMETER);
            }
            int delta = 0;
            Mutations m = (Mutations)((Object)Randomness.choice(mutations));
            switch (m) {
                case REPLACE: {
                    this.replace(test, statement);
                    if (test.size() <= oldLength) break;
                    delta = test.size() - oldLength;
                    break;
                }
                case PARAMETER: {
                    this.changeParameters(test, statement);
                    break;
                }
                case CALL: {
                    this.addCall(test, statement);
                }
            }
            if (test.isChanged()) {
                logger.info("Is changed");
                if (objective.hasImproved(test)) {
                    logger.info("Fitness has improved, keeping");
                    currentProbe = 0;
                    hasImproved = true;
                    this.backup(test);
                    statement += delta;
                    this.positionDelta += delta;
                    oldLength = test.size();
                    continue;
                }
                logger.info("Fitness has not improved, reverting");
                ++currentProbe;
                this.restore(test);
                continue;
            }
            logger.info("Is not changed");
            ++currentProbe;
        }
        return hasImproved;
    }

    private boolean addCall(TestChromosome test, int statement) {
        logger.debug("Adding call");
        TestFactory factory = TestFactory.getInstance();
        Statement theStatement = test.getTestCase().getStatement(statement);
        VariableReference var = theStatement.getReturnValue();
        int oldLength = test.size();
        factory.insertRandomCallOnObjectAt(test.getTestCase(), var, statement + 1);
        test.setChanged(test.size() != oldLength);
        return false;
    }

    private boolean replace(TestChromosome test, int statement) {
        logger.debug("Replacing call");
        TestFactory factory = TestFactory.getInstance();
        Statement theStatement = test.getTestCase().getStatement(statement);
        VariableReference var = theStatement.getReturnValue();
        int oldLength = test.size();
        try {
            VariableReference replacement = null;
            if (Randomness.nextDouble() < Properties.NULL_PROBABILITY) {
                NullStatement nullStatement = new NullStatement(test.getTestCase(), var.getType());
                replacement = test.getTestCase().addStatement(nullStatement, statement);
            } else if (!var.isPrimitive()) {
                replacement = factory.createObject(test.getTestCase(), var.getType(), statement, 0, null);
            }
            if (replacement != null) {
                int oldStatement = statement + (test.size() - oldLength);
                for (int i = oldStatement + 1; i < test.size(); ++i) {
                    test.getTestCase().getStatement(i).replace(var, replacement);
                }
                factory.deleteStatement(test.getTestCase(), oldStatement);
                test.setChanged(true);
            }
        }
        catch (ConstructionFailedException e) {
            if (test.size() < oldLength) {
                this.restore(test);
            }
            test.setChanged(test.size() != oldLength);
        }
        return false;
    }

    private boolean changeParameters(TestChromosome test, int statement) {
        logger.debug("Changing parameters");
        Statement stmt = test.getTestCase().getStatement(statement);
        if (stmt instanceof MethodStatement) {
            return this.replaceMethodParameter(test, (MethodStatement)stmt);
        }
        if (stmt instanceof ConstructorStatement) {
            return this.replaceConstructorParameter(test, (ConstructorStatement)stmt);
        }
        if (stmt instanceof FieldStatement) {
            return this.replaceFieldSource(test, (FieldStatement)stmt);
        }
        return false;
    }

    private boolean replaceMethodParameter(TestChromosome test, MethodStatement statement) {
        int numParameter;
        List<VariableReference> parameters = statement.getParameterReferences();
        if (parameters.isEmpty()) {
            return false;
        }
        int max = parameters.size();
        if (!statement.isStatic()) {
            ++max;
        }
        if ((numParameter = Randomness.nextInt(max)) == parameters.size()) {
            VariableReference callee = statement.getCallee();
            List<VariableReference> objects = test.getTestCase().getObjects(callee.getType(), statement.getPosition());
            objects.remove(callee);
            if (objects.isEmpty()) {
                return false;
            }
            VariableReference replacement = Randomness.choice(objects);
            statement.setCallee(replacement);
            test.setChanged(true);
        } else {
            VariableReference parameter = parameters.get(numParameter);
            List<VariableReference> objects = test.getTestCase().getObjects(parameter.getType(), statement.getPosition());
            objects.remove(parameter);
            objects.remove(statement.getReturnValue());
            NullStatement nullStatement = new NullStatement(test.getTestCase(), parameter.getType());
            if (!parameter.isPrimitive()) {
                objects.add(nullStatement.getReturnValue());
            }
            if (objects.isEmpty()) {
                return false;
            }
            VariableReference replacement = Randomness.choice(objects);
            if (replacement == nullStatement.getReturnValue()) {
                test.getTestCase().addStatement(nullStatement, statement.getPosition());
            }
            statement.replaceParameterReference(replacement, numParameter);
            test.setChanged(true);
        }
        return false;
    }

    private boolean replaceConstructorParameter(TestChromosome test, ConstructorStatement statement) {
        List<VariableReference> parameters = statement.getParameterReferences();
        if (parameters.isEmpty()) {
            return false;
        }
        int numParameter = Randomness.nextInt(parameters.size());
        VariableReference parameter = parameters.get(numParameter);
        List<VariableReference> objects = test.getTestCase().getObjects(parameter.getType(), statement.getPosition());
        objects.remove(parameter);
        objects.remove(statement.getReturnValue());
        NullStatement nullStatement = new NullStatement(test.getTestCase(), parameter.getType());
        if (!parameter.isPrimitive()) {
            objects.add(nullStatement.getReturnValue());
        }
        if (objects.isEmpty()) {
            return false;
        }
        VariableReference replacement = Randomness.choice(objects);
        if (replacement == nullStatement.getReturnValue()) {
            test.getTestCase().addStatement(nullStatement, statement.getPosition());
        }
        statement.replaceParameterReference(replacement, numParameter);
        test.setChanged(true);
        return false;
    }

    private boolean replaceFieldSource(TestChromosome test, FieldStatement statement) {
        if (!statement.isStatic()) {
            VariableReference source = statement.getSource();
            List<VariableReference> objects = test.getTestCase().getObjects(source.getType(), statement.getPosition());
            objects.remove(source);
            if (!objects.isEmpty()) {
                statement.setSource(Randomness.choice(objects));
                test.setChanged(true);
            }
        }
        return false;
    }

    private static enum Mutations {
        REPLACE,
        PARAMETER,
        CALL;

    }
}

