/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.ConcolicExecution;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.PathCondition;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverCache;
import org.evosuite.symbolic.solver.SolverFactory;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSETestGenerator {
    private final TestSuiteChromosome suite;
    private static final Logger logger = LoggerFactory.getLogger(DSETestGenerator.class);

    public DSETestGenerator() {
        this(null);
    }

    public DSETestGenerator(TestSuiteChromosome suite) {
        this.suite = suite;
    }

    public TestChromosome generateNewTest(TestChromosome test, Set<Integer> statementIndexes, LocalSearchObjective<TestChromosome> objective) {
        logger.info("APPLYING DSE EEEEEEEEEEEEEEEEEEEEEEE");
        logger.info(test.getTestCase().toCode());
        logger.info("Starting concolic execution");
        test.clone();
        DefaultTestCase clone_test_case = (DefaultTestCase)test.getTestCase().clone();
        List<BranchCondition> branchConditions = ConcolicExecution.executeConcolic(clone_test_case);
        PathCondition collectedPathCondition = new PathCondition(branchConditions);
        logger.info("Done concolic execution");
        if (collectedPathCondition.isEmpty()) {
            return null;
        }
        for (BranchCondition branchCondition : collectedPathCondition.getBranchConditions()) {
            logger.info(" -> " + branchCondition.getConstraint());
        }
        HashSet<VariableReference> symbolicVariables = new HashSet<VariableReference>();
        for (Integer position : statementIndexes) {
            VariableReference variableReference = test.getTestCase().getStatement(position).getReturnValue();
            symbolicVariables.add(variableReference);
        }
        logger.info("Checking {} conditions", (Object)collectedPathCondition.size());
        List<Integer> list = this.computeConditionIndexesNotCoveredTwoWays(test, collectedPathCondition);
        for (int conditionIndex = 0; conditionIndex < collectedPathCondition.size(); ++conditionIndex) {
            BranchCondition condition = collectedPathCondition.get(conditionIndex);
            if (LocalSearchBudget.getInstance().isFinished()) {
                logger.debug("Local search budget used up: " + (Object)((Object)Properties.LOCAL_SEARCH_BUDGET_TYPE));
                break;
            }
            logger.debug("Local search budget not yet used up");
            if (!list.contains(conditionIndex)) continue;
            logger.info("Current condition: " + conditionIndex + "/" + collectedPathCondition.size() + ": " + condition.getConstraint());
            Constraint<?> currentConstraint = condition.getConstraint();
            if (!this.isRelevant(currentConstraint, symbolicVariables)) {
                logger.info("Is not relevant for " + symbolicVariables);
                continue;
            }
            logger.info("Is relevant for " + symbolicVariables);
            List<Constraint<?>> query = this.buildQuery(collectedPathCondition, conditionIndex);
            logger.info("Trying to solve: ");
            for (Constraint<?> c : query) {
                logger.info("  " + c);
            }
            DSEStats.getInstance().reportNewConstraints(query);
            Solver solver = SolverFactory.getInstance().buildNewSolver();
            long startSolvingTime = System.currentTimeMillis();
            SolverCache solverCache = SolverCache.getInstance();
            SolverResult solverResult = solverCache.solve(solver, query);
            long estimatedSolvingTime = System.currentTimeMillis() - startSolvingTime;
            DSEStats.getInstance().reportNewSolvingTime(estimatedSolvingTime);
            if (solverResult == null) {
                logger.info("Found no result");
                continue;
            }
            if (solverResult.isUNSAT()) {
                logger.info("Found UNSAT result");
                DSEStats.getInstance().reportNewUNSAT();
                continue;
            }
            logger.info("Found SAT result");
            DSEStats.getInstance().reportNewSAT();
            Map<String, Object> model = solverResult.getModel();
            TestCase oldTest = test.getTestCase();
            ExecutionResult oldResult = test.getLastExecutionResult().clone();
            TestCase newTest = this.updateTest(oldTest, model);
            logger.info("New test: " + newTest.toCode());
            test.setTestCase(newTest);
            test.clearCachedResults();
            if (objective.hasImproved(test)) {
                DSEStats.getInstance().reportNewTestUseful();
                logger.info("Solution improves fitness, finishing DSE");
                return test;
            }
            DSEStats.getInstance().reportNewTestUnuseful();
            test.setTestCase(oldTest);
            if (oldResult == null) continue;
            test.setLastExecutionResult(oldResult);
        }
        return null;
    }

    private List<Integer> computeConditionIndexesNotCoveredTwoWays(TestChromosome test, PathCondition collectedPathCondition) {
        LinkedList<Integer> conditionIndexesNotCoveredTwoWays = new LinkedList<Integer>();
        for (int conditionIndex = 0; conditionIndex < collectedPathCondition.size(); ++conditionIndex) {
            BranchCondition b = collectedPathCondition.get(conditionIndex);
            if (this.isCoveredTwoWays(test, b.getBranchIndex())) continue;
            conditionIndexesNotCoveredTwoWays.add(conditionIndex);
        }
        return conditionIndexesNotCoveredTwoWays;
    }

    private boolean isCoveredTwoWays(TestChromosome test, int branchIndex) {
        HashSet<Integer> trueIndexes = new HashSet<Integer>();
        HashSet<Integer> falseIndexes = new HashSet<Integer>();
        if (this.suite != null) {
            for (ExecutionResult execResult : this.suite.getLastExecutionResults()) {
                Set<Integer> trueIndexesInTrace = execResult.getTrace().getCoveredTrueBranches();
                Set<Integer> falseIndexesInTrace = execResult.getTrace().getCoveredFalseBranches();
                trueIndexes.addAll(trueIndexesInTrace);
                falseIndexes.addAll(falseIndexesInTrace);
            }
        } else {
            ExecutionResult execResult = test.getLastExecutionResult();
            Set<Integer> trueIndexesInTest = execResult.getTrace().getCoveredTrueBranches();
            Set<Integer> falseIndexesInTest = execResult.getTrace().getCoveredFalseBranches();
            trueIndexes.addAll(trueIndexesInTest);
            falseIndexes.addAll(falseIndexesInTest);
        }
        boolean trueIsCovered = trueIndexes.contains(branchIndex);
        boolean falseIsCovered = falseIndexes.contains(branchIndex);
        return trueIsCovered && falseIsCovered;
    }

    private List<Constraint<?>> buildQuery(PathCondition pc, int conditionIndex) {
        PathCondition negatedPathCondition = pc.negate(conditionIndex);
        List<Constraint<?>> query = negatedPathCondition.getConstraints();
        List<Constraint<?>> simplified_query = this.reduce(query);
        return simplified_query;
    }

    private boolean isRelevant(Constraint<?> constraint, Set<VariableReference> targets) {
        Set<Variable<?>> variables = constraint.getVariables();
        HashSet<String> targetNames = new HashSet<String>();
        for (VariableReference variableReference : targets) {
            targetNames.add(variableReference.getName());
        }
        for (Variable variable : variables) {
            if (!targetNames.contains(variable.getName())) continue;
            return true;
        }
        return false;
    }

    private TestCase updateTest(TestCase test, Map<String, Object> values) {
        TestCase newTest = test.clone();
        for (String key : values.keySet()) {
            Object val = values.get(key);
            if (val != null) {
                PrimitiveStatement<?> p;
                String name;
                Number value;
                logger.info("New value: " + key + ": " + val);
                if (val instanceof Long) {
                    value = (Long)val;
                    name = key.replace("__SYM", "");
                    p = this.getStatement(newTest, name);
                    if (p.getValue().getClass().equals(Character.class)) {
                        p.setValue(Character.valueOf((char)((Long)value).intValue()));
                        continue;
                    }
                    if (p.getValue().getClass().equals(Long.class)) {
                        p.setValue(value);
                        continue;
                    }
                    if (p.getValue().getClass().equals(Integer.class)) {
                        p.setValue(((Long)value).intValue());
                        continue;
                    }
                    if (p.getValue().getClass().equals(Short.class)) {
                        p.setValue(((Long)value).shortValue());
                        continue;
                    }
                    if (p.getValue().getClass().equals(Boolean.class)) {
                        p.setValue(((Long)value).intValue() > 0);
                        continue;
                    }
                    if (p.getValue().getClass().equals(Byte.class)) {
                        p.setValue(((Long)value).byteValue() > 0);
                        continue;
                    }
                    logger.warn("New value is of an unsupported type: " + p.getValue().getClass() + val);
                    continue;
                }
                if (val instanceof String) {
                    String name2 = key.replace("__SYM", "");
                    PrimitiveStatement<?> p2 = this.getStatement(newTest, name2);
                    assert (p2 != null) : "Could not find variable " + name2 + " in test: " + newTest.toCode() + " / Orig test: " + test.toCode() + ", seed: " + Randomness.getSeed();
                    if (p2.getValue().getClass().equals(Character.class)) {
                        p2.setValue(Character.valueOf((char)Integer.parseInt(val.toString())));
                        continue;
                    }
                    p2.setValue(val.toString());
                    continue;
                }
                if (val instanceof Double) {
                    value = (Double)val;
                    name = key.replace("__SYM", "");
                    p = this.getStatement(newTest, name);
                    assert (p != null) : "Could not find variable " + name + " in test: " + newTest.toCode() + " / Orig test: " + test.toCode() + ", seed: " + Randomness.getSeed();
                    if (p.getValue().getClass().equals(Double.class)) {
                        p.setValue(value);
                        continue;
                    }
                    if (p.getValue().getClass().equals(Float.class)) {
                        p.setValue(Float.valueOf(((Double)value).floatValue()));
                        continue;
                    }
                    logger.warn("New value is of an unsupported type: " + val);
                    continue;
                }
                logger.debug("New value is of an unsupported type: " + val);
                continue;
            }
            logger.debug("New value is null");
        }
        return newTest;
    }

    private List<Constraint<?>> reduce(List<Constraint<?>> constraints) {
        Constraint<?> target = constraints.get(constraints.size() - 1);
        Set<Variable<?>> dependencies = this.getVariables(target);
        LinkedList coi = new LinkedList();
        if (dependencies.size() <= 0) {
            return coi;
        }
        coi.add(target);
        block0: for (int i = constraints.size() - 2; i >= 0; --i) {
            Constraint<?> constraint = constraints.get(i);
            Set<Variable<?>> variables = this.getVariables(constraint);
            for (Variable<?> var : dependencies) {
                if (!variables.contains(var)) continue;
                dependencies.addAll(variables);
                coi.addFirst(constraint);
                continue block0;
            }
        }
        return coi;
    }

    private PrimitiveStatement<?> getStatement(TestCase test, String name) {
        for (Statement statement : test) {
            if (!(statement instanceof PrimitiveStatement) || !statement.getReturnValue().getName().equals(name)) continue;
            return (PrimitiveStatement)statement;
        }
        return null;
    }

    private Set<Variable<?>> getVariables(Constraint<?> constraint) {
        HashSet variables = new HashSet();
        DSETestGenerator.getVariables(constraint.getLeftOperand(), variables);
        DSETestGenerator.getVariables(constraint.getRightOperand(), variables);
        return variables;
    }

    public static void getVariables(Expression<?> expr, Set<Variable<?>> variables) {
        variables.addAll(expr.getVariables());
    }
}

