/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.fm;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.shaded.org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.testcase.execution.EvosuiteError;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.GenericMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodDescriptor
implements Comparable<MethodDescriptor>,
Serializable {
    private static final long serialVersionUID = -6747363265640233704L;
    protected static final Logger logger = LoggerFactory.getLogger(MethodDescriptor.class);
    private final String methodName;
    private final String inputParameterMatchers;
    private final String className;
    private int counter;
    private GenericMethod method;
    private String id;

    public MethodDescriptor(Method method, GenericClass retvalType) {
        Inputs.checkNull(method, retvalType);
        this.method = new GenericMethod(method, retvalType);
        this.methodName = method.getName();
        this.className = method.getDeclaringClass().getName();
        this.inputParameterMatchers = this.initMatchers(this.method, retvalType);
    }

    private MethodDescriptor(GenericMethod m, String methodName, String className, String inputParameterMatchers) {
        this.method = m;
        this.methodName = methodName;
        this.className = className;
        this.inputParameterMatchers = inputParameterMatchers;
    }

    private String initMatchers(GenericMethod method, GenericClass retvalType) {
        String matchers = "";
        Type[] types = method.getParameterTypes();
        List<GenericClass> parameterClasses = method.getParameterClasses();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                matchers = matchers + " , ";
            }
            Type type = types[i];
            GenericClass genericParameter = parameterClasses.get(i);
            matchers = type.equals(Integer.TYPE) || type.equals(Integer.class) ? matchers + "anyInt()" : (type.equals(Long.TYPE) || type.equals(Long.class) ? matchers + "anyLong()" : (type.equals(Boolean.TYPE) || type.equals(Boolean.class) ? matchers + "anyBoolean()" : (type.equals(Double.TYPE) || type.equals(Double.class) ? matchers + "anyDouble()" : (type.equals(Float.TYPE) || type.equals(Float.class) ? matchers + "anyFloat()" : (type.equals(Short.TYPE) || type.equals(Short.class) ? matchers + "anyShort()" : (type.equals(Character.TYPE) || type.equals(Character.class) ? matchers + "anyChar()" : (type.equals(String.class) ? matchers + "anyString()" : (TypeUtils.isAssignable(type, List.class) ? matchers + "anyList()" : (TypeUtils.isAssignable(type, Set.class) ? matchers + "anySet()" : (TypeUtils.isAssignable(type, Map.class) ? matchers + "anyMap()" : (TypeUtils.isAssignable(type, Collection.class) ? matchers + "anyCollection()" : (TypeUtils.isAssignable(type, Iterable.class) ? matchers + "anyIterable()" : (type.getTypeName().equals(Object.class.getName()) ? matchers + "any()" : (type instanceof Class ? matchers + "any(" + ((Class)type).getCanonicalName() + ".class)" : matchers + "nullable(" + genericParameter.getRawClass().getCanonicalName() + ".class)"))))))))))))));
        }
        return matchers;
    }

    public void changeClassLoader(ClassLoader loader) {
        this.method.changeClassLoader(loader);
    }

    public boolean shouldBeMocked() {
        int modifiers = this.method.getMethod().getModifiers();
        if (this.method.getReturnType().equals(Void.TYPE) || this.method.getName().equals("equals") || this.method.getName().equals("hashCode") || Modifier.isPrivate(modifiers)) {
            return false;
        }
        if (Properties.hasTargetClassBeenLoaded()) {
            if (!Modifier.isPublic(modifiers)) {
                int lastIndexSUT;
                assert (!Modifier.isPrivate(modifiers));
                String sutName = Properties.TARGET_CLASS;
                int lastIndexMethod = this.className.lastIndexOf(46);
                boolean samePackage = lastIndexMethod != (lastIndexSUT = sutName.lastIndexOf(46)) ? false : (lastIndexMethod < 0 ? true : this.className.substring(0, lastIndexMethod).equals(sutName.substring(0, lastIndexSUT)));
                if (!samePackage) {
                    return false;
                }
            }
        } else {
            logger.warn("The target class should be loaded before invoking this method");
        }
        return true;
    }

    public MethodDescriptor getCopy() {
        MethodDescriptor copy = new MethodDescriptor(this.method, this.methodName, this.className, this.inputParameterMatchers);
        copy.counter = this.counter;
        return copy;
    }

    public int getNumberOfInputParameters() {
        return this.method.getNumParameters();
    }

    public Object executeMatcher(int i) throws IllegalArgumentException {
        if (i < 0 || i >= this.getNumberOfInputParameters()) {
            throw new IllegalArgumentException("Invalid index: " + i);
        }
        Type[] types = this.method.getParameterTypes();
        Type type = types[i];
        try {
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return Mockito.anyInt();
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return Mockito.anyLong();
            }
            if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                return Mockito.anyBoolean();
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return Mockito.anyDouble();
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return Float.valueOf(Mockito.anyFloat());
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return Mockito.anyShort();
            }
            if (type.equals(Character.TYPE) || type.equals(Character.class)) {
                return Character.valueOf(Mockito.anyChar());
            }
            if (type.equals(String.class)) {
                return Mockito.anyString();
            }
            if (TypeUtils.isAssignable(type, List.class)) {
                return Mockito.anyList();
            }
            if (TypeUtils.isAssignable(type, Set.class)) {
                return Mockito.anySet();
            }
            if (TypeUtils.isAssignable(type, Map.class)) {
                return Mockito.anyMap();
            }
            if (TypeUtils.isAssignable(type, Collection.class)) {
                return Mockito.anyCollection();
            }
            if (TypeUtils.isAssignable(type, Iterable.class)) {
                return Mockito.anyIterable();
            }
            GenericClass gc = new GenericClass(type);
            return Mockito.nullable(gc.getRawClass());
        }
        catch (Exception e) {
            logger.error("Failed to executed Mockito matcher n{} of type {} in {}.{}: {}", i, type, this.className, this.methodName, e.getMessage());
            throw new EvosuiteError(e);
        }
    }

    @Deprecated
    public MethodDescriptor(String className, String methodName, String inputParameterMatchers) throws IllegalArgumentException {
        Inputs.checkNull(methodName, inputParameterMatchers);
        this.className = className;
        this.methodName = methodName;
        this.inputParameterMatchers = inputParameterMatchers;
        this.counter = 0;
    }

    public GenericMethod getGenericMethodFor(GenericClass clazz) throws ConstructionFailedException {
        return (GenericMethod)this.method.getGenericInstantiation(clazz);
    }

    public GenericClass getReturnClass() {
        return this.method.getGeneratedClass();
    }

    public Method getMethod() {
        assert (this.method != null);
        return this.method.getMethod();
    }

    public GenericMethod getGenericMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getInputParameterMatchers() {
        return this.inputParameterMatchers;
    }

    public String getID() {
        if (this.id == null) {
            this.id = this.className + "." + this.getMethodName() + "#" + this.getInputParameterMatchers();
        }
        return this.id;
    }

    public int getCounter() {
        return this.counter;
    }

    public void increaseCounter() {
        ++this.counter;
    }

    @Override
    public int compareTo(MethodDescriptor o) {
        int com = this.className.compareTo(o.className);
        if (com != 0) {
            return com;
        }
        com = this.methodName.compareTo(o.methodName);
        if (com != 0) {
            return com;
        }
        com = this.inputParameterMatchers.compareTo(o.inputParameterMatchers);
        if (com != 0) {
            return com;
        }
        return this.counter - o.counter;
    }
}

