/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import com.googlecode.gentyref.CaptureType;
import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TimeController;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.runtime.annotation.Constraints;
import org.evosuite.runtime.javaee.injection.Injector;
import org.evosuite.runtime.javaee.javax.servlet.EvoServletState;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.runtime.util.AtMostOnceLogger;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.seeding.CastClassManager;
import org.evosuite.seeding.ObjectPoolManager;
import org.evosuite.setup.TestCluster;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.shaded.javax.servlet.http.HttpServlet;
import org.evosuite.shaded.org.apache.commons.lang3.ClassUtils;
import org.evosuite.testcase.ConstraintHelper;
import org.evosuite.testcase.ConstraintVerifier;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.jee.InjectionSupport;
import org.evosuite.testcase.jee.InstanceOnlyOnce;
import org.evosuite.testcase.jee.ServletSupport;
import org.evosuite.testcase.mutation.RandomInsertion;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.EntityWithParametersStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.FunctionalMockForAbstractClassStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.environment.EnvironmentStatements;
import org.evosuite.testcase.statements.reflection.PrivateFieldStatement;
import org.evosuite.testcase.statements.reflection.PrivateMethodStatement;
import org.evosuite.testcase.statements.reflection.ReflectionFactory;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.NullReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.generic.GenericAccessibleObject;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericField;
import org.evosuite.utils.generic.GenericMethod;
import org.evosuite.utils.generic.GenericUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFactory {
    private static final Logger logger = LoggerFactory.getLogger(TestFactory.class);
    private transient Set<GenericAccessibleObject<?>> currentRecursion = new LinkedHashSet();
    private static TestFactory instance = null;
    private ReflectionFactory reflectionFactory;

    private TestFactory() {
        this.reset();
    }

    public void reset() {
        this.currentRecursion.clear();
        this.reflectionFactory = null;
    }

    public static TestFactory getInstance() {
        if (instance == null) {
            instance = new TestFactory();
        }
        return instance;
    }

    private boolean addCallFor(TestCase test, VariableReference callee, GenericAccessibleObject<?> call, int position) {
        logger.trace("addCallFor {}", (Object)callee.getName());
        int previousLength = test.size();
        this.currentRecursion.clear();
        try {
            if (call.isMethod()) {
                GenericMethod method = (GenericMethod)call;
                if (call.isStatic() || !method.getDeclaringClass().isAssignableFrom(callee.getVariableClass())) {
                    this.addMethod(test, method, position, 0);
                } else {
                    this.addMethodFor(test, callee, (GenericMethod)call.copyWithNewOwner(callee.getGenericClass()), position);
                }
            } else if (call.isField()) {
                if (call.isStatic()) {
                    this.addFieldAssignment(test, (GenericField)call, position, 0);
                } else {
                    this.addFieldFor(test, callee, (GenericField)call.copyWithNewOwner(callee.getGenericClass()), position);
                }
            }
            return true;
        }
        catch (ConstructionFailedException e) {
            logger.debug("Inserting call {} has failed: {} Removing statements", (Object)call, (Object)e);
            int lengthDifference = test.size() - previousLength;
            for (int i = lengthDifference - 1; i >= 0; --i) {
                if (logger.isDebugEnabled()) {
                    logger.debug("  Removing statement: " + test.getStatement(position + i).getCode());
                }
                test.remove(position + i);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Test after removal: " + test.toCode());
            }
            return false;
        }
    }

    public VariableReference addFunctionalMock(TestCase test, Type type, int position, int recursionDepth) throws ConstructionFailedException, IllegalArgumentException {
        Inputs.checkNull(test, type);
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        FunctionalMockStatement fms = new FunctionalMockStatement(test, type, new GenericClass(type).getRawClass());
        VariableReference ref = test.addStatement(fms, position);
        return ref;
    }

    public VariableReference addFunctionalMockForAbstractClass(TestCase test, Type type, int position, int recursionDepth) throws ConstructionFailedException, IllegalArgumentException {
        Inputs.checkNull(test, type);
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        FunctionalMockForAbstractClassStatement fms = new FunctionalMockForAbstractClassStatement(test, type, new GenericClass(type).getRawClass());
        VariableReference ref = test.addStatement(fms, position);
        return ref;
    }

    public VariableReference addConstructor(TestCase test, GenericConstructor constructor, int position, int recursionDepth) throws ConstructionFailedException {
        return this.addConstructor(test, constructor, null, position, recursionDepth);
    }

    public VariableReference addConstructor(TestCase test, GenericConstructor constructor, Type exactType, int position, int recursionDepth) throws ConstructionFailedException {
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        Class<?> klass = constructor.getRawGeneratedType();
        if (Properties.JEE && InstanceOnlyOnce.canInstantiateOnlyOnce(klass) && ConstraintHelper.countNumberOfNewInstances(test, klass) != 0) {
            throw new ConstructionFailedException("Class " + klass.getName() + " can only be instantiated once");
        }
        int length = test.size();
        try {
            List<VariableReference> parameters = this.satisfyParameters(test, null, Arrays.asList(constructor.getParameterTypes()), Arrays.asList(constructor.getConstructor().getParameters()), position, recursionDepth + 1, true, false, true);
            int newLength = test.size();
            ConstructorStatement st = new ConstructorStatement(test, constructor, parameters);
            VariableReference ref = test.addStatement(st, position += newLength - length);
            if (Properties.JEE) {
                int injectPosition = this.doInjection(test, position, klass, ref, recursionDepth);
                if (Properties.HANDLE_SERVLETS && HttpServlet.class.isAssignableFrom(klass) && ConstraintHelper.countNumberOfMethodCalls(test, EvoServletState.class, "initServlet") == 0) {
                    MethodStatement ms = new MethodStatement(test, ServletSupport.getServletInit(), null, Arrays.asList(ref));
                    test.addStatement(ms, injectPosition++);
                }
            }
            return ref;
        }
        catch (Exception e) {
            throw new ConstructionFailedException("Failed to add constructor for " + klass.getName() + " due to " + e.getClass().getCanonicalName() + ": " + e.getMessage());
        }
    }

    private int doInjection(TestCase test, int position, Class<?> klass, VariableReference ref, int recursionDepth) throws ConstructionFailedException {
        Object ms;
        ConstantValue classConstant;
        Class<?> target;
        int injectPosition;
        int startPos = injectPosition = position + 1;
        for (target = klass; target != null; target = target.getSuperclass()) {
            classConstant = new ConstantValue(test, new GenericClass(Class.class), target);
            if (Injector.hasEntityManager(target)) {
                ms = new MethodStatement(test, InjectionSupport.getInjectorForEntityManager(), null, Arrays.asList(ref, classConstant));
                test.addStatement((Statement)ms, injectPosition++);
            }
            if (Injector.hasEntityManagerFactory(target)) {
                ms = new MethodStatement(test, InjectionSupport.getInjectorForEntityManagerFactory(), null, Arrays.asList(ref, classConstant));
                test.addStatement((Statement)ms, injectPosition++);
            }
            if (Injector.hasUserTransaction(target)) {
                ms = new MethodStatement(test, InjectionSupport.getInjectorForUserTransaction(), null, Arrays.asList(ref, classConstant));
                test.addStatement((Statement)ms, injectPosition++);
            }
            if (Injector.hasEvent(target)) {
                ms = new MethodStatement(test, InjectionSupport.getInjectorForEvent(), null, Arrays.asList(ref, classConstant));
                test.addStatement((Statement)ms, injectPosition++);
            }
            for (Field f : Injector.getGeneralFieldsToInject(target)) {
                boolean reuseVariables = recursionDepth == 0;
                int beforeLength = test.size();
                VariableReference valueToInject = this.satisfyParameters(test, ref, Arrays.asList(f.getType()), null, injectPosition, recursionDepth + 1, false, true, reuseVariables).get(0);
                int afterLength = test.size();
                injectPosition += afterLength - beforeLength;
                ConstantValue fieldName = new ConstantValue(test, new GenericClass(String.class), f.getName());
                MethodStatement ms2 = new MethodStatement(test, InjectionSupport.getInjectorForGeneralField(), null, Arrays.asList(ref, classConstant, fieldName, valueToInject));
                test.addStatement(ms2, injectPosition++);
            }
        }
        if (injectPosition != startPos) {
            classConstant = new ConstantValue(test, new GenericClass(Class.class), klass);
            ms = new MethodStatement(test, InjectionSupport.getValidateBean(), null, Arrays.asList(ref, classConstant));
            test.addStatement((Statement)ms, injectPosition++);
        }
        int pos = injectPosition;
        for (target = klass; target != null; target = target.getSuperclass()) {
            if (!Injector.hasPostConstruct(target)) continue;
            ConstantValue classConstant2 = new ConstantValue(test, new GenericClass(Class.class), target);
            MethodStatement ms3 = new MethodStatement(test, InjectionSupport.getPostConstruct(), null, Arrays.asList(ref, classConstant2));
            test.addStatement(ms3, pos);
            ++injectPosition;
        }
        return injectPosition;
    }

    public VariableReference addField(TestCase test, GenericField field, int position, int recursionDepth) throws ConstructionFailedException {
        logger.debug("Adding field {}", (Object)field);
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        VariableReference callee = null;
        int length = test.size();
        if (!field.isStatic()) {
            callee = this.createOrReuseVariable(test, field.getOwnerType(), position, recursionDepth, null, false, false, false);
            position += test.size() - length;
            if (!TestUsageChecker.canUse(field.getField(), callee.getVariableClass())) {
                logger.debug("Cannot call field {} with callee of type {}", (Object)field, (Object)callee.getClassName());
                throw new ConstructionFailedException("Cannot apply field to this callee");
            }
            if (!field.getOwnerClass().equals(callee.getGenericClass())) {
                try {
                    if (!TestUsageChecker.canUse(callee.getVariableClass().getField(field.getName()))) {
                        throw new ConstructionFailedException("Cannot access field in subclass");
                    }
                }
                catch (NoSuchFieldException fe) {
                    throw new ConstructionFailedException("Cannot access field in subclass");
                }
            }
        }
        FieldStatement st = new FieldStatement(test, field, callee);
        return test.addStatement(st, position);
    }

    public VariableReference addFieldAssignment(TestCase test, GenericField field, int position, int recursionDepth) throws ConstructionFailedException {
        logger.debug("Recursion depth: " + recursionDepth);
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        logger.debug("Adding field " + field);
        int length = test.size();
        VariableReference callee = null;
        if (!field.isStatic()) {
            callee = this.createOrReuseVariable(test, field.getOwnerType(), position, recursionDepth, null, false, false, false);
            position += test.size() - length;
            length = test.size();
            if (!TestUsageChecker.canUse(field.getField(), callee.getVariableClass())) {
                logger.debug("Cannot call field " + field + " with callee of type " + callee.getClassName());
                throw new ConstructionFailedException("Cannot apply field to this callee");
            }
        }
        VariableReference var = this.createOrReuseVariable(test, field.getFieldType(), position, recursionDepth, callee, true, false, false);
        int newLength = test.size();
        position += newLength - length;
        FieldReference f = new FieldReference(test, field, callee);
        if (f.equals(var)) {
            throw new ConstructionFailedException("Self assignment");
        }
        AssignmentStatement st = new AssignmentStatement(test, f, var);
        VariableReference ret = test.addStatement(st, position);
        assert (test.isValid());
        return ret;
    }

    public VariableReference addFieldFor(TestCase test, VariableReference callee, GenericField field, int position) throws ConstructionFailedException {
        logger.debug("Adding field " + field + " for variable " + callee);
        if (position <= callee.getStPosition()) {
            throw new ConstructionFailedException("Cannot insert call on object before the object is defined");
        }
        this.currentRecursion.clear();
        FieldReference fieldVar = new FieldReference(test, field, callee);
        int length = test.size();
        VariableReference value = this.createOrReuseVariable(test, fieldVar.getType(), position, 0, callee, true, false, true);
        int newLength = test.size();
        AssignmentStatement st = new AssignmentStatement(test, fieldVar, value);
        VariableReference ret = test.addStatement(st, position += newLength - length);
        ret.setDistance(callee.getDistance() + 1);
        assert (test.isValid());
        return ret;
    }

    public VariableReference addMethod(TestCase test, GenericMethod method, int position, int recursionDepth) throws ConstructionFailedException {
        logger.debug("Recursion depth: " + recursionDepth);
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        logger.debug("Adding method " + method);
        int length = test.size();
        VariableReference callee = null;
        List<VariableReference> parameters = null;
        if (!method.isStatic()) {
            callee = this.createOrReuseVariable(test, method.getOwnerType(), position, recursionDepth, null, false, false, false);
            assert (!(test.getStatement(callee.getStPosition()) instanceof FunctionalMockStatement));
            position += test.size() - length;
            length = test.size();
            logger.debug("Found callee of type " + method.getOwnerType() + ": " + callee.getName());
            if (!TestUsageChecker.canUse(method.getMethod(), callee.getVariableClass())) {
                logger.debug("Cannot call method " + method + " with callee of type " + callee.getClassName());
                throw new ConstructionFailedException("Cannot apply method to this callee");
            }
        }
        parameters = this.satisfyParameters(test, callee, Arrays.asList(method.getParameterTypes()), Arrays.asList(method.getMethod().getParameters()), position, recursionDepth + 1, true, false, true);
        int newLength = test.size();
        MethodStatement st = new MethodStatement(test, method, callee, parameters);
        VariableReference ret = test.addStatement(st, position += newLength - length);
        if (callee != null) {
            ret.setDistance(callee.getDistance() + 1);
        }
        return ret;
    }

    public VariableReference addMethodFor(TestCase test, VariableReference callee, GenericMethod method, int position) throws ConstructionFailedException {
        logger.debug("Adding method {} for {} (Generating {})", method, callee, method.getGeneratedClass());
        if (position <= callee.getStPosition()) {
            throw new ConstructionFailedException("Cannot insert call on object before the object is defined");
        }
        this.currentRecursion.clear();
        int length = test.size();
        boolean allowNull = true;
        Constraints constraints = method.getMethod().getAnnotation(Constraints.class);
        if (constraints != null && constraints.noNullInputs()) {
            allowNull = false;
        }
        List<VariableReference> parameters = this.satisfyParameters(test, callee, Arrays.asList(method.getParameterTypes()), Arrays.asList(method.getMethod().getParameters()), position, 1, allowNull, false, true);
        int newLength = test.size();
        MethodStatement st = new MethodStatement(test, method, callee, parameters);
        VariableReference ret = test.addStatement(st, position += newLength - length);
        ret.setDistance(callee.getDistance() + 1);
        logger.debug("Success: Adding method {}", (Object)method);
        return ret;
    }

    private VariableReference addPrimitive(TestCase test, PrimitiveStatement<?> old, int position) throws ConstructionFailedException {
        logger.debug("Adding primitive");
        Statement st = old.clone(test);
        return test.addStatement(st, position);
    }

    public void appendStatement(TestCase test, Statement statement) throws ConstructionFailedException {
        this.currentRecursion.clear();
        if (statement instanceof ConstructorStatement) {
            this.addConstructor(test, ((ConstructorStatement)statement).getConstructor(), test.size(), 0);
        } else if (statement instanceof MethodStatement) {
            GenericMethod method = ((MethodStatement)statement).getMethod();
            this.addMethod(test, method, test.size(), 0);
        } else if (statement instanceof PrimitiveStatement) {
            this.addPrimitive(test, (PrimitiveStatement)statement, test.size());
        } else if (statement instanceof FieldStatement) {
            this.addField(test, ((FieldStatement)statement).getField(), test.size(), 0);
        }
    }

    public void assignArray(TestCase test, VariableReference array, int arrayIndex, int position) throws ConstructionFailedException {
        List<VariableReference> objects = test.getObjects(array.getComponentType(), position);
        Iterator<VariableReference> iterator = objects.iterator();
        GenericClass componentClass = new GenericClass(array.getComponentType());
        while (iterator.hasNext()) {
            VariableReference var = iterator.next();
            if (var instanceof ArrayIndex) {
                if (((ArrayIndex)var).getArray().equals(array)) {
                    iterator.remove();
                } else if (((ArrayIndex)var).getArray().getType().equals(array.getType())) {
                    iterator.remove();
                }
            }
            if (!componentClass.isWrapperType()) continue;
            Class<?> rawClass = ClassUtils.wrapperToPrimitive(componentClass.getRawClass());
            if (var.getVariableClass().equals(rawClass) || var.getVariableClass().equals(componentClass.getRawClass())) continue;
            iterator.remove();
        }
        logger.debug("Reusable objects: " + objects);
        this.assignArray(test, array, arrayIndex, position, objects);
    }

    protected void assignArray(TestCase test, VariableReference array, int arrayIndex, int position, List<VariableReference> objects) throws ConstructionFailedException {
        assert (array instanceof ArrayReference);
        ArrayReference arrRef = (ArrayReference)array;
        if (!objects.isEmpty() && Randomness.nextDouble() <= Properties.OBJECT_REUSE_PROBABILITY) {
            VariableReference choice = Randomness.choice(objects);
            logger.debug("Reusing value: " + choice);
            ArrayIndex index = new ArrayIndex(test, arrRef, arrayIndex);
            AssignmentStatement st = new AssignmentStatement(test, index, choice);
            test.addStatement(st, position);
        } else {
            int oldLength = test.size();
            logger.debug("Attempting generation of object of type " + array.getComponentType());
            VariableReference var = this.attemptGeneration(test, array.getComponentType(), position);
            if (!var.isAssignableTo(arrRef.getComponentType())) {
                throw new ConstructionFailedException("Error");
            }
            ArrayIndex index = new ArrayIndex(test, arrRef, arrayIndex);
            AssignmentStatement st = new AssignmentStatement(test, index, var);
            test.addStatement(st, position += test.size() - oldLength);
        }
    }

    public VariableReference attemptGeneration(TestCase test, Type type, int position) throws ConstructionFailedException {
        return this.attemptGeneration(test, type, position, 0, false, null, true, true);
    }

    protected VariableReference attemptGeneration(TestCase test, Type type, int position, int recursionDepth, boolean allowNull, VariableReference generatorRefToExclude, boolean canUseMocks, boolean canReuseExistingVariables) throws ConstructionFailedException {
        GenericClass clazz = new GenericClass(type);
        if (clazz.isEnum()) {
            if (!TestUsageChecker.canUse(clazz.getRawClass())) {
                throw new ConstructionFailedException("Cannot generate unaccessible enum " + clazz);
            }
            return this.createPrimitive(test, clazz, position, recursionDepth);
        }
        if (clazz.isPrimitive() || clazz.isClass() || EnvironmentStatements.isEnvironmentData(clazz.getRawClass())) {
            return this.createPrimitive(test, clazz, position, recursionDepth);
        }
        if (clazz.isString()) {
            if (allowNull && Randomness.nextDouble() <= Properties.NULL_PROBABILITY) {
                logger.debug("Using a null reference to satisfy the type: {}", (Object)type);
                return this.createNull(test, type, position, recursionDepth);
            }
            return this.createPrimitive(test, clazz, position, recursionDepth);
        }
        if (clazz.isArray()) {
            if (allowNull && Randomness.nextDouble() <= Properties.NULL_PROBABILITY) {
                logger.debug("Using a null reference to satisfy the type: {}", (Object)type);
                return this.createNull(test, type, position, recursionDepth);
            }
            return this.createArray(test, clazz, position, recursionDepth);
        }
        if (allowNull && Randomness.nextDouble() <= Properties.NULL_PROBABILITY) {
            logger.debug("Using a null reference to satisfy the type: {}", (Object)type);
            return this.createNull(test, type, position, recursionDepth);
        }
        ObjectPoolManager objectPool = ObjectPoolManager.getInstance();
        if (Randomness.nextDouble() <= Properties.P_OBJECT_POOL && objectPool.hasSequence(clazz)) {
            TestCase sequence = objectPool.getRandomSequence(clazz);
            logger.debug("Using a sequence from the object pool to satisfy the type: {}", (Object)type);
            VariableReference targetObject = sequence.getLastObject(type);
            int returnPos = position + targetObject.getStPosition();
            for (int i = 0; i < sequence.size(); ++i) {
                Statement s = sequence.getStatement(i);
                test.addStatement(s.copy(test, position), position + i);
            }
            logger.debug("Return type of object sequence: {}", (Object)test.getStatement(returnPos).getReturnValue().getClassName());
            return test.getStatement(returnPos).getReturnValue();
        }
        logger.debug("Creating new object for type {}", (Object)type);
        return this.createObject(test, type, position, recursionDepth, generatorRefToExclude, allowNull, canUseMocks, canReuseExistingVariables);
    }

    protected VariableReference attemptObjectGeneration(TestCase test, int position, int recursionDepth, boolean allowNull) throws ConstructionFailedException {
        if (allowNull && Randomness.nextDouble() <= Properties.NULL_PROBABILITY) {
            logger.debug("Using a null reference to satisfy the type: {}", (Object)Object.class);
            return this.createNull(test, (Type)((Object)Object.class), position, recursionDepth);
        }
        LinkedHashSet<GenericClass> castClasses = new LinkedHashSet<GenericClass>(CastClassManager.getInstance().getCastClasses());
        List classes = castClasses.stream().filter(c -> TestCluster.getInstance().hasGenerator((GenericClass)c) || c.isString()).collect(Collectors.toList());
        classes.add(new GenericClass(Object.class));
        GenericClass choice = (GenericClass)Randomness.choice(classes);
        logger.debug("Chosen class for Object: {}", (Object)choice);
        if (choice.isString()) {
            return this.createOrReuseVariable(test, (Type)((Object)String.class), position, recursionDepth, null, allowNull, false, false);
        }
        GenericAccessibleObject<?> o = TestCluster.getInstance().getRandomGenerator(choice);
        this.currentRecursion.add(o);
        if (o == null) {
            if (!TestCluster.getInstance().hasGenerator((Type)((Object)Object.class))) {
                logger.debug("We have no generator for Object.class ");
            }
            throw new ConstructionFailedException("Generator is null");
        }
        if (o.isField()) {
            logger.debug("Attempting generating of Object.class via field of type Object.class");
            VariableReference ret = this.addField(test, (GenericField)o, position, recursionDepth + 1);
            ret.setDistance(recursionDepth + 1);
            logger.debug("Success in generating type Object.class");
            return ret;
        }
        if (o.isMethod()) {
            logger.debug("Attempting generating of Object.class via method {} of type Object.class", (Object)o);
            VariableReference ret = this.addMethod(test, (GenericMethod)o, position, recursionDepth + 1);
            logger.debug("Success in generating type Object.class");
            ret.setDistance(recursionDepth + 1);
            return ret;
        }
        if (o.isConstructor()) {
            logger.debug("Attempting generating of Object.class via constructor {} of type Object.class", (Object)o);
            VariableReference ret = this.addConstructor(test, (GenericConstructor)o, position, recursionDepth + 1);
            logger.debug("Success in generating Object.class");
            ret.setDistance(recursionDepth + 1);
            return ret;
        }
        logger.debug("No generators found for Object.class");
        throw new ConstructionFailedException("No generator found for Object.class");
    }

    public void changeCall(TestCase test, Statement statement, GenericAccessibleObject<?> call) throws ConstructionFailedException {
        int position = statement.getReturnValue().getStPosition();
        logger.debug("Changing call {} with {}", (Object)test.getStatement(position), (Object)call);
        if (call.isMethod()) {
            GenericMethod method = (GenericMethod)call;
            if (method.hasTypeParameters()) {
                throw new ConstructionFailedException("Cannot handle generic methods properly");
            }
            VariableReference retval = statement.getReturnValue();
            VariableReference callee = null;
            if (!method.isStatic()) {
                callee = this.getRandomNonNullNonPrimitiveObject(test, method.getOwnerType(), position);
            }
            ArrayList<VariableReference> parameters = new ArrayList<VariableReference>();
            for (Type type : method.getParameterTypes()) {
                parameters.add(test.getRandomObject(type, position));
            }
            MethodStatement m = new MethodStatement(test, method, callee, parameters, retval);
            test.setStatement(m, position);
            logger.debug("Using method {}", (Object)m.getCode());
        } else if (call.isConstructor()) {
            GenericConstructor constructor = (GenericConstructor)call;
            VariableReference retval = statement.getReturnValue();
            ArrayList<VariableReference> parameters = new ArrayList<VariableReference>();
            for (Type type : constructor.getParameterTypes()) {
                parameters.add(test.getRandomObject(type, position));
            }
            ConstructorStatement c = new ConstructorStatement(test, constructor, retval, parameters);
            test.setStatement(c, position);
            logger.debug("Using constructor {}", (Object)c.getCode());
        } else if (call.isField()) {
            GenericField field = (GenericField)call;
            VariableReference retval = statement.getReturnValue();
            VariableReference source = null;
            if (!field.isStatic()) {
                source = this.getRandomNonNullNonPrimitiveObject(test, field.getOwnerType(), position);
            }
            try {
                FieldStatement f = new FieldStatement(test, field, source, retval);
                test.setStatement(f, position);
                logger.debug("Using field {}", (Object)f.getCode());
            }
            catch (Throwable e) {
                logger.error("Error: " + e + " , Field: " + field + " , Test: " + test);
                throw new Error(e);
            }
        }
    }

    private VariableReference getRandomNonNullNonPrimitiveObject(TestCase tc, Type type, int position) throws ConstructionFailedException {
        Inputs.checkNull(type);
        List<VariableReference> variables = tc.getObjects(type, position);
        Iterator<VariableReference> iterator = variables.iterator();
        while (iterator.hasNext()) {
            VariableReference var = iterator.next();
            if (!(var instanceof NullReference) && !(tc.getStatement(var.getStPosition()) instanceof PrimitiveStatement) && !var.isPrimitive() && !var.isWrapperType() && !(tc.getStatement(var.getStPosition()) instanceof FunctionalMockStatement) && ConstraintHelper.getLastPositionOfBounded(var, tc) < position) continue;
            iterator.remove();
        }
        if (variables.isEmpty()) {
            throw new ConstructionFailedException("Found no variables of type " + type + " at position " + position);
        }
        return Randomness.choice(variables);
    }

    public boolean changeRandomCall(TestCase test, Statement statement) {
        logger.debug("Changing statement {}", (Object)statement.getCode());
        List<VariableReference> objects = test.getObjects(statement.getReturnValue().getStPosition());
        objects.remove(statement.getReturnValue());
        Iterator<VariableReference> iter = objects.iterator();
        while (iter.hasNext()) {
            VariableReference ref = iter.next();
            if (test.getStatement(ref.getStPosition()) instanceof FunctionalMockStatement) {
                iter.remove();
                continue;
            }
            int boundPosition = ConstraintHelper.getLastPositionOfBounded(ref, test);
            if (boundPosition < 0 || boundPosition < statement.getPosition()) continue;
            iter.remove();
        }
        List<GenericAccessibleObject<?>> calls = this.getPossibleCalls(statement.getReturnType(), objects);
        GenericAccessibleObject<?> ao = statement.getAccessibleObject();
        if (ao != null && ao.getNumParameters() > 0) {
            calls.remove(ao);
        }
        if (ConstraintHelper.getLastPositionOfBounded(statement.getReturnValue(), test) >= 0) {
            Iterator<GenericAccessibleObject<?>> z = calls.iterator();
            while (z.hasNext()) {
                GenericAccessibleObject<?> k = z.next();
                if (k instanceof GenericConstructor) continue;
                z.remove();
            }
        }
        logger.debug("Got {} possible calls for {} objects", (Object)calls.size(), (Object)objects.size());
        if (calls.isEmpty()) {
            logger.debug("No replacement calls");
            return false;
        }
        GenericAccessibleObject<?> call = Randomness.choice(calls);
        try {
            this.changeCall(test, statement, call);
            return true;
        }
        catch (ConstructionFailedException e) {
            logger.info("Change failed for statement " + statement.getCode() + " -> " + call + ": " + e.getMessage() + " " + test.toCode());
            return false;
        }
    }

    private VariableReference createArray(TestCase test, GenericClass arrayClass, int position, int recursionDepth) throws ConstructionFailedException {
        logger.debug("Creating array of type " + arrayClass.getTypeName());
        if (arrayClass.hasWildcardOrTypeVariables()) {
            arrayClass = arrayClass.getGenericInstantiation();
            logger.debug("Setting generic array to type " + arrayClass.getTypeName());
        }
        ArrayStatement statement = new ArrayStatement(test, arrayClass.getType());
        VariableReference reference = test.addStatement(statement, position);
        logger.debug("Array length: " + statement.size());
        logger.debug("Array component type: " + reference.getComponentType());
        List<VariableReference> objects = test.getObjects(reference.getComponentType(), ++position);
        Iterator<VariableReference> iterator = objects.iterator();
        while (iterator.hasNext()) {
            VariableReference current = iterator.next();
            if (!(current instanceof ArrayIndex)) continue;
            ArrayIndex index = (ArrayIndex)current;
            if (index.getArray().equals(statement.getReturnValue())) {
                iterator.remove();
                continue;
            }
            if (!index.getArray().getType().equals(arrayClass.getType())) continue;
            iterator.remove();
        }
        objects.remove(statement.getReturnValue());
        logger.debug("Found assignable objects: " + objects.size());
        LinkedHashSet currentArrayRecursion = new LinkedHashSet(this.currentRecursion);
        for (int i = 0; i < statement.size(); ++i) {
            this.currentRecursion.clear();
            this.currentRecursion.addAll(currentArrayRecursion);
            logger.debug("Assigning array index " + i);
            int oldLength = test.size();
            this.assignArray(test, reference, i, position, objects);
            position += test.size() - oldLength;
        }
        reference.setDistance(recursionDepth);
        return reference;
    }

    private VariableReference createPrimitive(TestCase test, GenericClass clazz, int position, int recursionDepth) throws ConstructionFailedException {
        if (clazz.isClass()) {
            Type parameterType;
            if (clazz.hasWildcardOrTypeVariables()) {
                logger.debug("Getting generic instantiation of class");
                clazz = clazz.getGenericInstantiation();
                logger.debug("Chosen: " + clazz);
            }
            if (!((parameterType = clazz.getParameterTypes().get(0)) instanceof WildcardType) && GenericTypeReflector.erase(parameterType).equals(Class.class)) {
                throw new ConstructionFailedException("Cannot instantiate a class with a class");
            }
        }
        PrimitiveStatement<?> st = PrimitiveStatement.getRandomStatement(test, clazz, position);
        VariableReference ret = test.addStatement(st, position);
        ret.setDistance(recursionDepth);
        return ret;
    }

    private VariableReference createNull(TestCase test, Type type, int position, int recursionDepth) throws ConstructionFailedException {
        GenericClass genericType = new GenericClass(type);
        if (!TestUsageChecker.canUse(genericType.getRawClass())) {
            throw new ConstructionFailedException("Cannot use class " + type);
        }
        if (genericType.hasWildcardOrTypeVariables()) {
            type = genericType.getGenericInstantiation().getType();
        }
        NullStatement st = new NullStatement(test, type);
        test.addStatement(st, position);
        VariableReference ret = test.getStatement(position).getReturnValue();
        ret.setDistance(recursionDepth);
        return ret;
    }

    public VariableReference createObject(TestCase test, Type type, int position, int recursionDepth, VariableReference generatorRefToExclude) throws ConstructionFailedException {
        return this.createObject(test, type, position, recursionDepth, generatorRefToExclude, true, true, true);
    }

    public VariableReference createObject(TestCase test, Type type, int position, int recursionDepth, VariableReference generatorRefToExclude, boolean allowNull, boolean canUseFunctionalMocks, boolean canReuseVariables) throws ConstructionFailedException {
        GenericClass clazz = new GenericClass(type);
        logger.debug("Going to create object for type {}", (Object)type);
        VariableReference ret = null;
        if (canUseFunctionalMocks && TimeController.getInstance().getPhasePercentage() >= Properties.FUNCTIONAL_MOCKING_PERCENT && Randomness.nextDouble() < Properties.P_FUNCTIONAL_MOCKING && FunctionalMockStatement.canBeFunctionalMocked(type)) {
            logger.debug("Creating functional mock for {}", (Object)type);
            ret = this.addFunctionalMock(test, type, position, recursionDepth + 1);
        } else {
            GenericAccessibleObject<?> o = TestCluster.getInstance().getRandomGenerator(clazz, this.currentRecursion, test, position, generatorRefToExclude, recursionDepth);
            this.currentRecursion.add(o);
            if (o == null) {
                if (canReuseVariables) {
                    for (int i = position - 1; i >= 0; --i) {
                        Statement statement = test.getStatement(i);
                        VariableReference var = statement.getReturnValue();
                        if (!allowNull && ConstraintHelper.isNull(var, test) || !var.isAssignableTo(type) || statement instanceof FunctionalMockStatement) continue;
                        logger.debug("Reusing variable at position {}", (Object)var.getStPosition());
                        return var;
                    }
                }
                if (canUseFunctionalMocks && (Properties.MOCK_IF_NO_GENERATOR || Properties.P_FUNCTIONAL_MOCKING > 0.0)) {
                    if (FunctionalMockStatement.canBeFunctionalMocked(type)) {
                        logger.debug("Using mock for type {}", (Object)type);
                        ret = this.addFunctionalMock(test, type, position, recursionDepth + 1);
                    } else if (clazz.isAbstract() && FunctionalMockStatement.canBeFunctionalMockedIncludingSUT(type)) {
                        logger.debug("Using mock for abstract type {}", (Object)type);
                        ret = this.addFunctionalMockForAbstractClass(test, type, position, recursionDepth + 1);
                    }
                }
                if (ret == null) {
                    logger.debug("No mock solution found: {}, {}, {}, {}", canUseFunctionalMocks, Properties.MOCK_IF_NO_GENERATOR, FunctionalMockStatement.canBeFunctionalMocked(type), FunctionalMockStatement.canBeFunctionalMockedIncludingSUT(type));
                    if (!TestCluster.getInstance().hasGenerator(type)) {
                        logger.debug("No generators found for {}, attempting to resolve dependencies", (Object)type);
                        TestClusterGenerator clusterGenerator = TestGenerationContext.getInstance().getTestClusterGenerator();
                        Class<?> mock = MockList.getMockClass(clazz.getRawClass().getCanonicalName());
                        if (mock != null) {
                            clusterGenerator.addNewDependencies(Arrays.asList(mock));
                        } else {
                            clusterGenerator.addNewDependencies(Arrays.asList(clazz.getRawClass()));
                        }
                        if (TestCluster.getInstance().hasGenerator(type)) {
                            logger.debug("Found new generators for {}", (Object)type);
                            return this.createObject(test, type, position, recursionDepth + 1, generatorRefToExclude, allowNull, canUseFunctionalMocks, canReuseVariables);
                        }
                        logger.debug("Found no new generators for {}", (Object)type);
                    }
                    throw new ConstructionFailedException("Have no generator for " + type + " canUseFunctionalMocks=" + canUseFunctionalMocks + ", canBeMocked: " + FunctionalMockStatement.canBeFunctionalMocked(type));
                }
            } else if (o.isField()) {
                logger.debug("Attempting generating of {} via field of type {}", (Object)type, (Object)type);
                ret = this.addField(test, (GenericField)o, position, recursionDepth + 1);
            } else if (o.isMethod()) {
                logger.debug("Attempting generating of " + type + " via method " + o + " of type " + type);
                ret = this.addMethod(test, (GenericMethod)o, position, recursionDepth + 1);
                logger.debug("Success in generating type {} using method \"{}\"", (Object)type, (Object)o);
            } else if (o.isConstructor()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Attempting generating of " + type + " via constructor " + o + " of type " + type + ", with constructor type " + o.getOwnerType() + ", at position " + position);
                }
                ret = this.addConstructor(test, (GenericConstructor)o, type, position, recursionDepth + 1);
            } else {
                logger.debug("No generators found for type {}", (Object)type);
                throw new ConstructionFailedException("No generator found for type " + type);
            }
        }
        ret.setDistance(recursionDepth + 1);
        logger.debug("Success in generation of type {} at position {}", (Object)type, (Object)position);
        return ret;
    }

    private VariableReference createOrReuseVariable(TestCase test, Type parameterType, int position, int recursionDepth, VariableReference exclude, boolean allowNull, boolean excludeCalleeGenerators, boolean canUseMocks) throws ConstructionFailedException {
        boolean isPrimitiveOrSimilar;
        if (Properties.SEED_TYPES && parameterType.equals(Object.class)) {
            return this.createOrReuseObjectVariable(test, position, recursionDepth, exclude, allowNull, canUseMocks);
        }
        double reuse = Randomness.nextDouble();
        List<VariableReference> objects = this.getCandidatesForReuse(test, parameterType, position, exclude, allowNull, canUseMocks);
        GenericClass clazz = new GenericClass(parameterType);
        boolean bl = isPrimitiveOrSimilar = clazz.isPrimitive() || clazz.isWrapperType() || clazz.isEnum() || clazz.isClass() || clazz.isString();
        if (isPrimitiveOrSimilar && !objects.isEmpty() && reuse <= Properties.PRIMITIVE_REUSE_PROBABILITY) {
            logger.debug(" Looking for existing object of type {}", (Object)parameterType);
            VariableReference reference = Randomness.choice(objects);
            return reference;
        }
        if (!isPrimitiveOrSimilar && !objects.isEmpty() && reuse <= Properties.OBJECT_REUSE_PROBABILITY) {
            if (logger.isDebugEnabled()) {
                logger.debug(" Choosing from {} existing objects: {}", (Object)objects.size(), (Object)Arrays.toString(objects.toArray()));
            }
            VariableReference reference = Randomness.choice(objects);
            return reference;
        }
        VariableReference created = this.createVariable(test, parameterType, position, recursionDepth, exclude, allowNull, excludeCalleeGenerators, canUseMocks, true);
        if (created != null) {
            return created;
        }
        if (objects.isEmpty()) {
            if (allowNull) {
                return this.createNull(test, parameterType, position, recursionDepth);
            }
            throw new ConstructionFailedException("No objects and generators for type " + parameterType);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" Choosing from {} existing objects: {}", (Object)objects.size(), (Object)Arrays.toString(objects.toArray()));
        }
        VariableReference reference = Randomness.choice(objects);
        assert (canUseMocks || !(test.getStatement(reference.getStPosition()) instanceof FunctionalMockStatement));
        logger.debug(" Using existing object of type {}: {}", (Object)parameterType, (Object)reference);
        return reference;
    }

    private VariableReference createVariable(TestCase test, Type parameterType, int position, int recursionDepth, VariableReference exclude, boolean allowNull, boolean excludeCalleeGenerators, boolean canUseMocks, boolean canReuseExistingVariables) throws ConstructionFailedException {
        GenericClass clazz = new GenericClass(parameterType);
        if (clazz.hasWildcardOrTypeVariables()) {
            logger.debug("Getting generic instantiation of {}", (Object)clazz);
            clazz = exclude != null ? clazz.getGenericInstantiation(exclude.getGenericClass().getTypeVariableMap()) : clazz.getGenericInstantiation();
            parameterType = clazz.getType();
        }
        if (clazz.isEnum() || clazz.isPrimitive() || clazz.isWrapperType() || clazz.isObject() || clazz.isClass() || EnvironmentStatements.isEnvironmentData(clazz.getRawClass()) || clazz.isString() || clazz.isArray() || TestCluster.getInstance().hasGenerator(parameterType) || Properties.P_FUNCTIONAL_MOCKING > 0.0 || Properties.MOCK_IF_NO_GENERATOR) {
            logger.debug(" Generating new object of type {}", (Object)parameterType);
            VariableReference generatorRefToExclude = null;
            if (excludeCalleeGenerators) {
                generatorRefToExclude = exclude;
            }
            VariableReference reference = this.attemptGeneration(test, parameterType, position, recursionDepth, allowNull, generatorRefToExclude, canUseMocks, canReuseExistingVariables);
            assert (allowNull || !ConstraintHelper.isNull(reference, test));
            assert (canUseMocks || !(test.getStatement(reference.getStPosition()) instanceof FunctionalMockStatement));
            if (reference.getStPosition() < position && ConstraintHelper.getLastPositionOfBounded(reference, test) >= position) {
                AtMostOnceLogger.warn(logger, "Bounded variable issue when calling createVariable()");
                return null;
            }
            return reference;
        }
        return null;
    }

    private List<VariableReference> getCandidatesForReuse(TestCase test, Type parameterType, int position, VariableReference exclude, boolean allowNull, boolean canUseMocks) {
        VariableReference ref;
        List<VariableReference> objects = test.getObjects(parameterType, position);
        if (exclude != null) {
            objects.remove(exclude);
            if (exclude.getAdditionalVariableReference() != null) {
                objects.remove(exclude.getAdditionalVariableReference());
            }
            Iterator<VariableReference> it = objects.iterator();
            while (it.hasNext()) {
                VariableReference v = it.next();
                if (!exclude.equals(v.getAdditionalVariableReference())) continue;
                it.remove();
            }
        }
        ArrayList<VariableReference> additionalToRemove = new ArrayList<VariableReference>();
        Iterator<VariableReference> iter = objects.iterator();
        block1: while (iter.hasNext()) {
            ref = iter.next();
            if (!(test.getStatement(ref.getStPosition()) instanceof FunctionalMockStatement)) continue;
            for (int i = ref.getStPosition() + 1; i < test.size(); ++i) {
                Statement st = test.getStatement(i);
                if (!st.getVariableReferences().contains(ref)) continue;
                iter.remove();
                additionalToRemove.add(ref);
                continue block1;
            }
        }
        if (!allowNull) {
            iter = objects.iterator();
            while (iter.hasNext()) {
                ref = iter.next();
                if (!ConstraintHelper.isNull(ref, test)) continue;
                iter.remove();
                additionalToRemove.add(ref);
            }
        }
        if (!canUseMocks) {
            iter = objects.iterator();
            while (iter.hasNext()) {
                ref = iter.next();
                if (!(test.getStatement(ref.getStPosition()) instanceof FunctionalMockStatement)) continue;
                iter.remove();
                additionalToRemove.add(ref);
            }
        }
        if (Properties.JEE) {
            iter = objects.iterator();
            while (iter.hasNext()) {
                ref = iter.next();
                if (ConstraintHelper.getLastPositionOfBounded(ref, test) < position) continue;
                iter.remove();
                additionalToRemove.add(ref);
            }
        }
        iter = objects.iterator();
        while (iter.hasNext()) {
            ref = iter.next();
            VariableReference additional = ref.getAdditionalVariableReference();
            if (additional == null || !additionalToRemove.contains(additional)) continue;
            iter.remove();
        }
        iter = objects.iterator();
        String parCls = parameterType.getTypeName();
        if (Integer.TYPE.getTypeName().equals(parCls) || Long.TYPE.getTypeName().equals(parCls) || Float.TYPE.getTypeName().equals(parCls) || Double.TYPE.getTypeName().equals(parCls)) {
            while (iter.hasNext()) {
                VariableReference ref2 = iter.next();
                String cls = ref2.getType().getTypeName();
                if (!Character.TYPE.getTypeName().equals(cls)) continue;
                iter.remove();
            }
        }
        return objects;
    }

    private VariableReference createOrReuseObjectVariable(TestCase test, int position, int recursionDepth, VariableReference exclude, boolean allowNull, boolean canUseMocks) throws ConstructionFailedException {
        double reuse = Randomness.nextDouble();
        if (reuse <= Properties.PRIMITIVE_REUSE_PROBABILITY) {
            List<VariableReference> candidates = this.getCandidatesForReuse(test, (Type)((Object)Object.class), position, exclude, allowNull, canUseMocks);
            TestFactory.filterVariablesByCastClasses(candidates);
            logger.debug("Choosing object from: {}", (Object)candidates);
            if (!candidates.isEmpty()) {
                return Randomness.choice(candidates);
            }
        }
        logger.debug("Attempting object generation");
        return this.attemptObjectGeneration(test, position, recursionDepth, allowNull);
    }

    public boolean deleteStatement(TestCase test, int position) throws ConstructionFailedException {
        if (!ConstraintVerifier.canDelete(test, position)) {
            return false;
        }
        logger.debug("Deleting target statement - {}", (Object)position);
        LinkedHashSet<Integer> toDelete = new LinkedHashSet<Integer>();
        this.recursiveDeleteInclusion(test, toDelete, position);
        ArrayList<Integer> pos = new ArrayList<Integer>(toDelete);
        Collections.sort(pos, Collections.reverseOrder());
        for (Integer i : pos) {
            logger.debug("Deleting statement: {}", (Object)i);
            test.remove(i);
        }
        return true;
    }

    private void recursiveDeleteInclusion(TestCase test, Set<Integer> toDelete, int position) {
        if (toDelete.contains(position)) {
            return;
        }
        toDelete.add(position);
        Set<Integer> references = this.getReferencePositions(test, position);
        for (Integer i : references) {
            Set<Integer> constraintDependencies = ConstraintVerifier.dependentPositions(test, i);
            if (constraintDependencies != null) {
                for (Integer j : constraintDependencies) {
                    this.recursiveDeleteInclusion(test, toDelete, j);
                }
            }
            this.recursiveDeleteInclusion(test, toDelete, i);
        }
    }

    private Set<Integer> getReferencePositions(TestCase test, int position) {
        LinkedHashSet<VariableReference> references = new LinkedHashSet<VariableReference>();
        LinkedHashSet<Integer> positions = new LinkedHashSet<Integer>();
        references.add(test.getReturnValue(position));
        for (int i = position; i < test.size(); ++i) {
            LinkedHashSet<VariableReference> temp = new LinkedHashSet<VariableReference>();
            for (VariableReference v : references) {
                if (!test.getStatement(i).references(v)) continue;
                temp.add(test.getStatement(i).getReturnValue());
                positions.add(i);
            }
            references.addAll(temp);
        }
        return positions;
    }

    private static void filterVariablesByCastClasses(Collection<VariableReference> variables) {
        Set<GenericClass> castClasses = CastClassManager.getInstance().getCastClasses();
        Iterator<VariableReference> replacement = variables.iterator();
        while (replacement.hasNext()) {
            VariableReference r = replacement.next();
            boolean isAssignable = false;
            for (GenericClass clazz : castClasses) {
                if (r.isPrimitive() || !clazz.isAssignableFrom(r.getVariableClass())) continue;
                isAssignable = true;
                break;
            }
            if (isAssignable || r.getVariableClass().equals(Object.class)) continue;
            replacement.remove();
        }
    }

    private static void filterVariablesByClass(Collection<VariableReference> variables, Class<?> clazz) {
        Iterator<VariableReference> replacement = variables.iterator();
        while (replacement.hasNext()) {
            VariableReference r = replacement.next();
            if (r.getVariableClass().equals(clazz)) continue;
            replacement.remove();
        }
    }

    public boolean deleteStatementGracefully(TestCase test, int position) throws ConstructionFailedException {
        boolean deleted;
        Statement s;
        ConstructorStatement cs;
        VariableReference var = test.getReturnValue(position);
        if (var instanceof ArrayIndex) {
            return this.deleteStatement(test, position);
        }
        boolean changed = false;
        boolean replacingPrimitive = test.getStatement(position) instanceof PrimitiveStatement;
        List<VariableReference> alternatives = test.getObjects(var.getType(), position);
        int maxIndex = 0;
        if (var instanceof ArrayReference) {
            maxIndex = ((ArrayReference)var).getMaximumIndex();
        }
        if (test.getStatement(position) instanceof MethodStatement) {
            MethodStatement ms = (MethodStatement)test.getStatement(position);
            if (ms.getReturnType().equals(Object.class)) {
                TestFactory.filterVariablesByClass(alternatives, Object.class);
            }
        } else if (test.getStatement(position) instanceof ConstructorStatement && (cs = (ConstructorStatement)test.getStatement(position)).getReturnType().equals(Object.class)) {
            TestFactory.filterVariablesByClass(alternatives, Object.class);
        }
        alternatives.remove(var);
        Iterator<VariableReference> replacement = alternatives.iterator();
        while (replacement.hasNext()) {
            VariableReference r = replacement.next();
            if (test.getStatement(r.getStPosition()) instanceof FunctionalMockStatement) {
                replacement.remove();
                continue;
            }
            if (var.equals(r.getAdditionalVariableReference())) {
                replacement.remove();
                continue;
            }
            if (var.isFieldReference()) {
                FieldReference fref = (FieldReference)var;
                if (!fref.getField().isFinal()) continue;
                replacement.remove();
                continue;
            }
            if (r instanceof ArrayReference) {
                if (maxIndex < ((ArrayReference)r).getArrayLength()) continue;
                replacement.remove();
                continue;
            }
            if (replacingPrimitive || !(test.getStatement(r.getStPosition()) instanceof PrimitiveStatement)) continue;
            replacement.remove();
        }
        if (!alternatives.isEmpty()) {
            for (int i = position + 1; i < test.size(); ++i) {
                s = test.getStatement(i);
                if (!s.references(var)) continue;
                if (s.isAssignmentStatement()) {
                    VariableReference replacementVar;
                    AssignmentStatement assignment = (AssignmentStatement)s;
                    if (assignment.getValue() == var) {
                        replacementVar = Randomness.choice(alternatives);
                        if (!assignment.getReturnValue().isAssignableFrom(replacementVar)) continue;
                        s.replace(var, replacementVar);
                        changed = true;
                        continue;
                    }
                    if (assignment.getReturnValue() != var || !(replacementVar = Randomness.choice(alternatives)).isAssignableFrom(assignment.getValue())) continue;
                    s.replace(var, replacementVar);
                    changed = true;
                    continue;
                }
                boolean bounded = false;
                if (s instanceof EntityWithParametersStatement) {
                    EntityWithParametersStatement es = (EntityWithParametersStatement)s;
                    bounded = es.isBounded(var);
                }
                if (bounded) continue;
                s.replace(var, Randomness.choice(alternatives));
                changed = true;
            }
        }
        if (var instanceof ArrayReference) {
            alternatives = test.getObjects(var.getComponentType(), position);
            alternatives.remove(var);
            replacement = alternatives.iterator();
            while (replacement.hasNext()) {
                VariableReference r = replacement.next();
                if (var.equals(r.getAdditionalVariableReference())) {
                    replacement.remove();
                    continue;
                }
                if (!(r instanceof ArrayReference) || maxIndex < ((ArrayReference)r).getArrayLength()) continue;
                replacement.remove();
            }
            if (!alternatives.isEmpty()) {
                for (int i = position; i < test.size(); ++i) {
                    s = test.getStatement(i);
                    for (VariableReference var2 : s.getVariableReferences()) {
                        ArrayIndex ai;
                        if (!(var2 instanceof ArrayIndex) || !(ai = (ArrayIndex)var2).getArray().equals(var)) continue;
                        s.replace(var2, Randomness.choice(alternatives));
                        changed = true;
                    }
                }
            }
        }
        return (deleted = this.deleteStatement(test, position)) || changed;
    }

    private static boolean dependenciesSatisfied(Set<Type> dependencies, List<VariableReference> objects) {
        for (Type type : dependencies) {
            boolean found = false;
            for (VariableReference var : objects) {
                if (!var.getType().equals(type)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static Set<Type> getDependencies(GenericConstructor constructor) {
        LinkedHashSet<Type> dependencies = new LinkedHashSet<Type>();
        for (Type type : constructor.getParameterTypes()) {
            dependencies.add(type);
        }
        return dependencies;
    }

    private static Set<Type> getDependencies(GenericField field) {
        LinkedHashSet<Type> dependencies = new LinkedHashSet<Type>();
        if (!field.isStatic()) {
            dependencies.add(field.getOwnerType());
        }
        return dependencies;
    }

    private static Set<Type> getDependencies(GenericMethod method) {
        LinkedHashSet<Type> dependencies = new LinkedHashSet<Type>();
        if (!method.isStatic()) {
            dependencies.add(method.getOwnerType());
        }
        for (Type type : method.getParameterTypes()) {
            dependencies.add(type);
        }
        return dependencies;
    }

    private List<GenericAccessibleObject<?>> getPossibleCalls(Type returnType, List<VariableReference> objects) {
        Set<GenericAccessibleObject<?>> allCalls;
        ArrayList calls = new ArrayList();
        try {
            allCalls = TestCluster.getInstance().getGenerators(new GenericClass(returnType), true);
        }
        catch (ConstructionFailedException e) {
            return calls;
        }
        for (GenericAccessibleObject<Object> call : allCalls) {
            Set<Type> dependencies = null;
            if (call.isMethod()) {
                GenericMethod method = (GenericMethod)call;
                if (method.hasTypeParameters()) {
                    try {
                        call = method.getGenericInstantiation(new GenericClass(returnType));
                    }
                    catch (ConstructionFailedException e) {
                        continue;
                    }
                }
                if (!((GenericMethod)call).getReturnType().equals(returnType)) continue;
                dependencies = TestFactory.getDependencies((GenericMethod)call);
            } else if (call.isConstructor()) {
                dependencies = TestFactory.getDependencies((GenericConstructor)call);
            } else if (call.isField()) {
                if (!((GenericField)call).getFieldType().equals(returnType)) continue;
                dependencies = TestFactory.getDependencies((GenericField)call);
            } else assert (false);
            if (!TestFactory.dependenciesSatisfied(dependencies, objects)) continue;
            calls.add(call);
        }
        return calls;
    }

    private boolean insertRandomReflectionCall(TestCase test, int position, int recursionDepth) throws ConstructionFailedException {
        logger.debug("Recursion depth: " + recursionDepth);
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        int length = test.size();
        List<VariableReference> parameters = null;
        MethodStatement st = null;
        if (this.reflectionFactory.nextUseField()) {
            Field field = this.reflectionFactory.nextField();
            parameters = this.satisfyParameters(test, null, Arrays.asList(this.reflectionFactory.getReflectedClass(), field.getType()), null, position, recursionDepth + 1, true, false, true);
            try {
                st = new PrivateFieldStatement(test, this.reflectionFactory.getReflectedClass(), field.getName(), parameters.get(0), parameters.get(1));
            }
            catch (NoSuchFieldException e) {
                logger.error("Reflection problem: " + e, e);
                throw new ConstructionFailedException("Reflection problem");
            }
        } else {
            Method method = this.reflectionFactory.nextMethod();
            ArrayList<Type> list = new ArrayList<Type>();
            list.add(this.reflectionFactory.getReflectedClass());
            list.addAll(Arrays.asList(method.getGenericParameterTypes()));
            parameters = this.satisfyParameters(test, null, list, null, position, recursionDepth + 1, true, false, true);
            VariableReference callee = parameters.remove(0);
            st = new PrivateMethodStatement(test, this.reflectionFactory.getReflectedClass(), method, callee, parameters, Modifier.isStatic(method.getModifiers()));
        }
        int newLength = test.size();
        test.addStatement(st, position += newLength - length);
        return true;
    }

    private boolean insertRandomReflectionCallOnObject(TestCase test, VariableReference callee, int position, int recursionDepth) throws ConstructionFailedException {
        logger.debug("Recursion depth: " + recursionDepth);
        if (recursionDepth > Properties.MAX_RECURSION) {
            logger.debug("Max recursion depth reached");
            throw new ConstructionFailedException("Max recursion depth reached");
        }
        if (!this.reflectionFactory.getReflectedClass().isAssignableFrom(callee.getVariableClass())) {
            logger.debug("Reflection not performed on class {}", (Object)callee.getVariableClass());
            return false;
        }
        int length = test.size();
        List<VariableReference> parameters = null;
        MethodStatement st = null;
        if (this.reflectionFactory.nextUseField()) {
            Field field = this.reflectionFactory.nextField();
            boolean allowNull = false;
            parameters = this.satisfyParameters(test, callee, Arrays.asList(field.getType()), null, position, recursionDepth + 1, allowNull, false, true);
            try {
                st = new PrivateFieldStatement(test, this.reflectionFactory.getReflectedClass(), field.getName(), callee, parameters.get(0));
            }
            catch (NoSuchFieldException e) {
                logger.error("Reflection problem: " + e, e);
                throw new ConstructionFailedException("Reflection problem");
            }
        } else {
            Method method = this.reflectionFactory.nextMethod();
            ArrayList<Type> list = new ArrayList<Type>();
            list.addAll(Arrays.asList(method.getParameterTypes()));
            parameters = this.satisfyParameters(test, callee, list, null, position, recursionDepth + 1, true, false, true);
            st = new PrivateMethodStatement(test, this.reflectionFactory.getReflectedClass(), method, callee, parameters, Modifier.isStatic(method.getModifiers()));
        }
        int newLength = test.size();
        test.addStatement(st, position += newLength - length);
        return true;
    }

    public int insertRandomCallOnEnvironment(TestCase test, int lastValidPosition) {
        int previousLength = test.size();
        this.currentRecursion.clear();
        List<GenericAccessibleObject<?>> shuffledOptions = TestCluster.getInstance().getRandomizedCallsToEnvironment();
        if (shuffledOptions == null || shuffledOptions.isEmpty()) {
            return -1;
        }
        for (GenericAccessibleObject<?> o : shuffledOptions) {
            try {
                int position = ConstraintVerifier.getAValidPositionForInsertion(o, test, lastValidPosition);
                if (position < 0) continue;
                if (o.isConstructor()) {
                    GenericConstructor c = (GenericConstructor)o;
                    this.addConstructor(test, c, position, 0);
                    return position;
                }
                if (o.isMethod()) {
                    GenericMethod m = (GenericMethod)o;
                    if (!m.isStatic()) {
                        VariableReference callee = null;
                        Type target = m.getOwnerType();
                        if (!test.hasObject(target, position)) {
                            callee = this.createObject(test, target, position, 0, null);
                            position += test.size() - previousLength;
                            previousLength = test.size();
                        } else {
                            callee = test.getRandomNonNullObject(target, position);
                        }
                        if (!TestUsageChecker.canUse(m.getMethod(), callee.getVariableClass())) {
                            logger.error("Cannot call method " + m + " with callee of type " + callee.getClassName());
                        }
                        this.addMethodFor(test, callee, m.copyWithNewOwner(callee.getGenericClass()), position);
                        return position;
                    }
                    this.addMethod(test, m, position, 0);
                    return position;
                }
                throw new RuntimeException("Unrecognized type for environment: " + o);
            }
            catch (ConstructionFailedException e) {
                AtMostOnceLogger.warn(logger, "Failed environment insertion: " + e);
            }
        }
        return -1;
    }

    public boolean insertRandomCall(TestCase test, int position) {
        int previousLength = test.size();
        String name = "";
        this.currentRecursion.clear();
        logger.debug("Inserting random call at position {}", (Object)position);
        try {
            if (this.reflectionFactory == null) {
                Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
                this.reflectionFactory = new ReflectionFactory(targetClass);
            }
            if (this.reflectionFactory.hasPrivateFieldsOrMethods() && TimeController.getInstance().getPhasePercentage() >= Properties.REFLECTION_START_PERCENT && (Randomness.nextDouble() < Properties.P_REFLECTION_ON_PRIVATE || TestCluster.getInstance().getNumTestCalls() == 0)) {
                logger.debug("Going to insert random reflection call");
                return this.insertRandomReflectionCall(test, position, 0);
            }
            GenericAccessibleObject<?> o = TestCluster.getInstance().getRandomTestCall(test);
            if (o == null) {
                logger.warn("Have no target methods to test");
                return false;
            }
            if (o.isConstructor()) {
                if (InstanceOnlyOnce.canInstantiateOnlyOnce(o.getDeclaringClass()) && ConstraintHelper.countNumberOfNewInstances(test, o.getDeclaringClass()) != 0) {
                    return false;
                }
                GenericConstructor c = (GenericConstructor)o;
                logger.debug("Adding constructor call {}", (Object)c.getName());
                name = c.getName();
                this.addConstructor(test, c, position, 0);
            } else if (o.isMethod()) {
                GenericMethod m = (GenericMethod)o;
                logger.debug("Adding method call {}", (Object)m.getName());
                name = m.getName();
                if (!m.isStatic()) {
                    logger.debug("Getting callee of type {}", (Object)m.getOwnerClass().getTypeName());
                    VariableReference callee = null;
                    Type target = m.getOwnerType();
                    if (!test.hasObject(target, position)) {
                        callee = this.createObject(test, target, position, 0, null, false, false, true);
                        position += test.size() - previousLength;
                        previousLength = test.size();
                    } else {
                        callee = test.getRandomNonNullObject(target, position);
                    }
                    logger.debug("Got callee of type {}", (Object)callee.getGenericClass().getTypeName());
                    if (!TestUsageChecker.canUse(m.getMethod(), callee.getVariableClass())) {
                        logger.debug("Cannot call method {} with callee of type {}", (Object)m, (Object)callee.getClassName());
                        throw new ConstructionFailedException("Cannot apply method to this callee");
                    }
                    this.addMethodFor(test, callee, m.copyWithNewOwner(callee.getGenericClass()), position);
                } else {
                    this.addMethod(test, m, position, 0);
                }
            } else if (o.isField()) {
                GenericField f = (GenericField)o;
                name = f.getName();
                logger.debug("Adding field {}", (Object)f.getName());
                if (Randomness.nextBoolean()) {
                    this.addFieldAssignment(test, f, position, 0);
                } else {
                    this.addField(test, f, position, 0);
                }
            } else {
                logger.error("Got type other than method or constructor!");
                return false;
            }
            return true;
        }
        catch (ConstructionFailedException e) {
            logger.debug("Inserting statement {} has failed. Removing statements: {}", (Object)name, (Object)e);
            int lengthDifference = test.size() - previousLength;
            for (int i = lengthDifference - 1; i >= 0; --i) {
                if (logger.isDebugEnabled()) {
                    logger.debug("  Removing statement: " + test.getStatement(position + i).getCode());
                }
                test.remove(position + i);
            }
            return false;
        }
    }

    public boolean insertRandomCallOnObjectAt(TestCase test, VariableReference var, int position) {
        logger.debug("Chosen object: {}", (Object)var.getName());
        if (var instanceof ArrayReference) {
            logger.debug("Chosen object is array ");
            ArrayReference array = (ArrayReference)var;
            if (array.getArrayLength() > 0) {
                for (int i = 0; i < array.getArrayLength(); ++i) {
                    logger.debug("Assigning array index " + i);
                    int old_len = test.size();
                    try {
                        this.assignArray(test, array, i, position);
                        position += test.size() - old_len;
                        continue;
                    }
                    catch (ConstructionFailedException constructionFailedException) {
                        // empty catch block
                    }
                }
                return true;
            }
        } else if (var.getGenericClass().hasWildcardOrTypeVariables()) {
            logger.debug("Cannot add calls on unknown type");
        } else {
            logger.debug("Getting calls for object {}", (Object)var.toString());
            try {
                if (this.reflectionFactory == null) {
                    Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
                    this.reflectionFactory = new ReflectionFactory(targetClass);
                }
                if (this.reflectionFactory.hasPrivateFieldsOrMethods() && TimeController.getInstance().getPhasePercentage() >= Properties.REFLECTION_START_PERCENT && Randomness.nextDouble() < Properties.P_REFLECTION_ON_PRIVATE) {
                    return this.insertRandomReflectionCallOnObject(test, var, position, 0);
                }
                GenericAccessibleObject<?> call = TestCluster.getInstance().getRandomCallFor(var.getGenericClass(), test, position);
                logger.debug("Chosen call {}", (Object)call);
                return this.addCallFor(test, var, call, position);
            }
            catch (ConstructionFailedException e) {
                logger.debug("Found no modifier: {}", e);
            }
        }
        return false;
    }

    public int insertRandomStatement(TestCase test, int lastPosition) {
        RandomInsertion rs = new RandomInsertion();
        return rs.insertStatement(test, lastPosition);
    }

    public List<VariableReference> satisfyParameters(TestCase test, VariableReference callee, List<Type> parameterTypes, List<Parameter> parameterList, int position, int recursionDepth, boolean allowNull, boolean excludeCalleeGenerators, boolean canReuseExistingVariables) throws ConstructionFailedException {
        if (callee == null && excludeCalleeGenerators) {
            throw new IllegalArgumentException("Exclude generators on null callee");
        }
        ArrayList<VariableReference> parameters = new ArrayList<VariableReference>();
        logger.debug("Trying to satisfy {} parameters at position {}", (Object)parameterTypes.size(), (Object)position);
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Type parameterType = parameterTypes.get(i);
            Parameter parameter = null;
            boolean allowNullForParameter = allowNull;
            if (parameterList != null) {
                parameter = parameterList.get(i);
            }
            logger.debug("Current parameter type: {}", (Object)parameterType);
            if (parameterType instanceof CaptureType) {
                throw new ConstructionFailedException("Cannot satisfy capture type");
            }
            GenericClass parameterClass = new GenericClass(parameterType);
            if (parameterClass.hasTypeVariables()) {
                logger.debug("Parameter has type variables, replacing with wildcard");
                parameterType = parameterClass.getWithWildcardTypes().getType();
            }
            int previousLength = test.size();
            VariableReference var = null;
            if (Properties.HONOUR_DATA_ANNOTATIONS && parameterList != null && GenericUtils.isAnnotationTypePresent(parameter.getAnnotations(), "Nonnull")) {
                allowNullForParameter = false;
            }
            if (canReuseExistingVariables) {
                logger.debug("Can re-use variables");
                var = this.createOrReuseVariable(test, parameterType, position, recursionDepth, callee, allowNullForParameter, excludeCalleeGenerators, true);
            } else {
                logger.debug("Cannot re-use variables: attempt at creating new one");
                var = this.createVariable(test, parameterType, position, recursionDepth, callee, allowNullForParameter, excludeCalleeGenerators, true, false);
                if (var == null) {
                    throw new ConstructionFailedException("Failed to create variable for type " + parameterType + " at position " + position);
                }
            }
            assert (allowNullForParameter || !ConstraintHelper.isNull(var, test));
            if (var.getStPosition() < position && ConstraintHelper.getLastPositionOfBounded(var, test) >= position) {
                String msg = "Bounded variable issue when calling satisfyParameters()";
                AtMostOnceLogger.warn(logger, msg);
                throw new ConstructionFailedException(msg);
            }
            if (!var.isAssignableTo(parameterType)) {
                throw new ConstructionFailedException("Error: " + var + " is not assignable to " + parameterType);
            }
            parameters.add(var);
            int currentLength = test.size();
            position += currentLength - previousLength;
        }
        logger.debug("Satisfied {} parameters", (Object)parameterTypes.size());
        return parameters;
    }
}

