/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import org.evosuite.assertion.Assertion;
import org.evosuite.testcase.StructuredTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCodeVisitor;
import org.evosuite.testcase.statements.Statement;

public class StructuredTestCodeVisitor
extends TestCodeVisitor {
    private StructuredTestCase structuredTest = null;
    private int exercisePosition = 0;
    private int checkingPosition = 0;
    private boolean checkAdded = false;

    @Override
    public void visitTestCase(TestCase test) {
        if (!(test instanceof StructuredTestCase)) {
            throw new IllegalArgumentException("Need StructuredTestCase");
        }
        this.structuredTest = (StructuredTestCase)test;
        this.exercisePosition = this.structuredTest.getFirstExerciseStatement();
        this.checkingPosition = this.structuredTest.getFirstCheckingStatement();
        super.visitTestCase(test);
        this.checkAdded = !this.exceptions.isEmpty();
    }

    @Override
    protected void visitAssertion(Assertion assertion) {
        if (!this.checkAdded && assertion.getStatement().getPosition() == this.checkingPosition) {
            this.testCode = this.testCode + "\n// Check\n";
            this.checkAdded = true;
        }
        super.visitAssertion(assertion);
    }

    @Override
    public void visitStatement(Statement statement) {
        int position = statement.getPosition();
        if (position == this.exercisePosition) {
            this.testCode = this.testCode + "\n// Exercise\n";
        } else if (position == 0) {
            this.testCode = this.testCode + "// Setup\n";
        }
        super.visitStatement(statement);
        if (position == this.checkingPosition && !this.checkAdded && !statement.hasAssertions()) {
            this.testCode = this.testCode + "\n// Check\n";
            this.checkAdded = true;
        }
    }
}

