/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.ArrayList;
import java.util.Collections;
import org.evosuite.Properties;
import org.evosuite.shaded.org.apache.commons.lang3.StringEscapeUtils;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantInliner
extends ExecutionObserver {
    private TestCase test = null;
    private static final Logger logger = LoggerFactory.getLogger(ConstantInliner.class);

    public void inline(TestCase test) {
        this.test = test;
        TestCaseExecutor executor = TestCaseExecutor.getInstance();
        executor.addObserver(this);
        executor.execute(test);
        executor.removeObserver(this);
        this.removeUnusedVariables(test);
        assert (test.isValid());
    }

    public void inline(TestChromosome test) {
        this.inline(test.test);
    }

    public void inline(TestSuiteChromosome suite) {
        for (TestChromosome test : suite.getTestChromosomes()) {
            ExecutionResult lastExecResult;
            int old_test_size = test.size();
            this.inline(test);
            int new_test_size = test.size();
            int removed_statements = old_test_size - new_test_size;
            if (removed_statements <= 0 || (lastExecResult = test.getLastExecutionResult()) == null) continue;
            int old_exec_statements = lastExecResult.getExecutedStatements();
            int new_exec_statements = old_exec_statements - removed_statements;
            lastExecResult.setExecutedStatements(new_exec_statements);
        }
    }

    public boolean removeUnusedVariables(TestCase t) {
        ArrayList<Integer> toDelete = new ArrayList<Integer>();
        boolean hasDeleted = false;
        int num = 0;
        for (Statement s : t) {
            VariableReference var;
            if (s instanceof PrimitiveStatement && !t.hasReferences(var = s.getReturnValue())) {
                toDelete.add(num);
                hasDeleted = true;
            }
            ++num;
        }
        Collections.sort(toDelete, Collections.reverseOrder());
        for (Integer position : toDelete) {
            t.remove(position);
        }
        return hasDeleted;
    }

    @Override
    public void output(int position, String output) {
    }

    @Override
    public void afterStatement(Statement statement, Scope scope, Throwable exception) {
        try {
            block4: for (VariableReference var : statement.getVariableReferences()) {
                FieldStatement fs;
                MethodStatement ms;
                Object value;
                if (var.equals(statement.getReturnValue()) || var.equals(statement.getReturnValue().getAdditionalVariableReference())) continue;
                Object object = var.getObject(scope);
                if (var.isPrimitive()) {
                    value = new ConstantValue(this.test, var.getGenericClass());
                    ((ConstantValue)value).setValue(object);
                    statement.replace(var, (VariableReference)value);
                    continue;
                }
                if (var.isString() && object != null) {
                    value = new ConstantValue(this.test, var.getGenericClass());
                    try {
                        String val = StringEscapeUtils.unescapeJava(new String(object.toString()));
                        if (val.length() >= Properties.MAX_STRING) continue;
                        ((ConstantValue)value).setValue(val);
                        statement.replace(var, (VariableReference)value);
                    }
                    catch (IllegalArgumentException e) {
                        logger.info("Cannot escape invalid string: " + object);
                    }
                    continue;
                }
                if (var.isArrayIndex()) {
                    for (VariableReference otherVar : scope.getElements(var.getType())) {
                        Object otherObject = otherVar.getObject(scope);
                        if (otherObject != object || otherVar.isArrayIndex() || otherVar.getStPosition() >= statement.getPosition()) continue;
                        statement.replace(var, otherVar);
                        continue block4;
                    }
                    continue;
                }
                if (object != null || (statement instanceof MethodStatement ? var.equals((ms = (MethodStatement)statement).getCallee()) : statement instanceof FieldStatement && var.equals((fs = (FieldStatement)statement).getSource()))) continue;
                value = new ConstantValue(this.test, var.getGenericClass());
                ((ConstantValue)value).setValue(null);
                statement.replace(var, (VariableReference)value);
            }
        }
        catch (CodeUnderTestException e) {
            logger.warn("Not inlining test: " + e.getCause());
        }
    }

    @Override
    public void beforeStatement(Statement statement, Scope scope) {
    }

    @Override
    public void clear() {
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
    }
}

