/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcarver.codegen;

import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.TimeController;
import org.evosuite.classpath.ResourceList;
import org.evosuite.testcarver.capture.CaptureLog;
import org.evosuite.testcarver.codegen.CaptureLogAnalyzerException;
import org.evosuite.testcarver.codegen.ICaptureLogAnalyzer;
import org.evosuite.testcarver.codegen.ICodeGenerator;
import org.evosuite.utils.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CaptureLogAnalyzer
implements ICaptureLogAnalyzer {
    private static Logger logger = LoggerFactory.getLogger(CaptureLogAnalyzer.class);

    @Override
    public void analyze(CaptureLog originalLog, ICodeGenerator generator, Class<?> ... observedClasses) {
        this.analyze(originalLog, generator, new HashSet(), observedClasses);
    }

    public void analyze(CaptureLog originalLog, ICodeGenerator generator, Set<Class<?>> blackList, Class<?> ... observedClasses) {
        if (originalLog == null) {
            throw new IllegalArgumentException("captured log must not be null");
        }
        if (generator == null) {
            throw new IllegalArgumentException("code generator must not be null");
        }
        if (blackList == null) {
            throw new IllegalArgumentException("set containing black listed classes must not be null");
        }
        if (observedClasses == null) {
            throw new IllegalArgumentException("array of observed classes must not be null");
        }
        if (observedClasses.length == 0) {
            throw new IllegalArgumentException("array of observed classes must not be empty");
        }
        CaptureLog log = originalLog.clone();
        HashSet<String> observedClassNames = this.extractObservedClassNames(observedClasses);
        CaptureLogAnalyzerException.check(!CollectionUtil.isNullOrEmpty(observedClassNames), "could not extract class names for ", Arrays.toString(observedClasses));
        List<Integer> targetOIDs = log.getTargetOIDs(observedClassNames);
        if (targetOIDs.isEmpty()) {
            logger.info("could not find any oids for {} -> {} ==> no code is generated\n", (Object)observedClassNames, (Object)Arrays.toString(observedClasses));
            return;
        }
        logger.debug("Target oids: {}", (Object)targetOIDs);
        int[] oidExchange = this.analyzeLog(generator, blackList, log, targetOIDs);
        logger.debug("Going to postprocess stage");
        this.postProcessLog(originalLog, generator, blackList, log, oidExchange, observedClasses);
    }

    private void postProcessLog(CaptureLog originalLog, ICodeGenerator<?> generator, Set<Class<?>> blackList, CaptureLog log, int[] oidExchange, Class<?> ... observedClasses) throws RuntimeException {
        if (oidExchange == null) {
            generator.after(log);
        } else {
            try {
                Class<?> origClass = this.getClassFromOID(log, oidExchange[0]);
                Class<?> destClass = this.getClassFromOID(log, oidExchange[1]);
                for (int i = 0; i < observedClasses.length; ++i) {
                    if (!origClass.equals(observedClasses[i])) continue;
                    observedClasses[i] = destClass;
                }
                generator.clear();
                this.analyze(originalLog, generator, blackList, observedClasses);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private int[] analyzeLog(ICodeGenerator<?> generator, Set<Class<?>> blackList, CaptureLog log, List<Integer> targetOIDs) {
        generator.before(log);
        int numLogRecords = log.objectIds.size();
        CaptureLogAnalyzerException.check(numLogRecords > 0, "list of captured object ids is empty for log %s", log);
        int currentOID = targetOIDs.get(0);
        int[] oidExchange = null;
        for (int currentRecord = Math.abs(log.getRecordIndexOfWhereObjectWasInitializedFirst(currentOID)); currentRecord < numLogRecords; ++currentRecord) {
            currentOID = log.objectIds.get(currentRecord);
            logger.debug("Current record {}, current oid {} type {}", currentRecord, currentOID, log.getTypeName(currentOID));
            if (generator.isMaximumLengthReached()) {
                logger.debug("Max length reached, stopping carving");
                break;
            }
            if (targetOIDs.contains(currentOID) && !blackList.contains(this.getClassFromOID(log, currentOID))) {
                logger.debug("Analyzing record in position {}", (Object)currentRecord);
                try {
                    oidExchange = this.restoreCodeFromLastPosTo(log, generator, currentOID, currentRecord + 1, blackList);
                }
                catch (Throwable t) {
                    logger.debug("Error: " + t);
                    for (StackTraceElement elem : t.getStackTrace()) {
                        logger.debug(elem.toString());
                    }
                    break;
                }
                if (oidExchange != null) {
                    logger.debug("oidExchange is not null");
                    break;
                }
                currentRecord = this.findEndOfMethod(log, currentRecord, currentOID);
                logger.debug("Current record: {}", (Object)currentRecord);
                log.updateWhereObjectWasInitializedFirst(currentOID, currentRecord);
                logger.debug("Log updated");
                continue;
            }
            logger.debug("Skipping record in position {}", (Object)currentRecord);
        }
        return oidExchange;
    }

    private HashSet<String> extractObservedClassNames(Class<?> ... observedClasses) {
        HashSet<String> observedClassNames = new HashSet<String>();
        for (int i = 0; i < observedClasses.length; ++i) {
            observedClassNames.add(observedClasses[i].getName());
        }
        return observedClassNames;
    }

    private Class<?> getClassFromOID(CaptureLog log, int oid) {
        try {
            String typeName = log.getTypeName(oid);
            return this.getClassForName(typeName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final Class<?> getClassForName(String type) {
        try {
            if (type.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (type.equals("byte")) {
                return Byte.TYPE;
            }
            if (type.equals("char")) {
                return Character.TYPE;
            }
            if (type.equals("double")) {
                return Double.TYPE;
            }
            if (type.equals("float")) {
                return Float.TYPE;
            }
            if (type.equals("int")) {
                return Integer.TYPE;
            }
            if (type.equals("long")) {
                return Long.TYPE;
            }
            if (type.equals("short")) {
                return Short.TYPE;
            }
            if (type.equals("String") || type.equals("Boolean") || type.equals("Short") || type.equals("Long") || type.equals("Integer") || type.equals("Float") || type.equals("Double") || type.equals("Byte") || type.equals("Character")) {
                return Class.forName("java.lang." + type);
            }
            if (type.startsWith("$Proxy")) {
                return Proxy.class;
            }
            if (type.endsWith("[]")) {
                type = type.replace("[]", "");
                return Class.forName("[L" + type + ";");
            }
            return Class.forName(ResourceList.getClassNameFromResourcePath(type));
        }
        catch (ClassNotFoundException e) {
            CaptureLogAnalyzerException.propagateError(e, "an error occurred while resolving class for type %s", type);
            return null;
        }
    }

    private int findCaller(CaptureLog log, int currentRecord) {
        logger.debug("Looking for caller of {}", (Object)currentRecord);
        int numRecords = log.objectIds.size();
        logger.debug("numRecords = {}", (Object)numRecords);
        int record = currentRecord;
        logger.debug("Starting with {}", (Object)record);
        do {
            record = this.findEndOfMethod(log, record, log.objectIds.get(record));
            logger.debug("Now is {}", (Object)(++record));
        } while (record < numRecords && !log.methodNames.get(record).equals(CaptureLog.END_CAPTURE_PSEUDO_METHOD));
        logger.debug("records = {}", (Object)record);
        if (record >= numRecords) {
            logger.info("[currentRecord={}] - could not find caller for currentRecord -> must be very first method call", (Object)currentRecord);
            return -1;
        }
        logger.debug("Found caller {}: {}", (Object)record, (Object)log.objectIds.size());
        return log.objectIds.get(record);
    }

    private void updateInitRec(CaptureLog log, int currentOID, int currentRecord) {
        if (Math.abs(currentRecord) > Math.abs(log.getRecordIndexOfWhereObjectWasInitializedFirst(currentOID))) {
            log.updateWhereObjectWasInitializedFirst(currentOID, currentRecord);
        }
    }

    private int findEndOfMethod(CaptureLog log, int currentRecord, int currentOID) {
        int record = currentRecord;
        int captureId = log.captureIds.get(record);
        logger.debug("captureId {}, record {}", (Object)captureId, (Object)record);
        int nestedCalls = 0;
        while (true) {
            if (log.captureIds.size() <= record || log.objectIds.size() <= record) {
                logger.debug("Screw this: {}, {}, {}", log.captureIds.size(), log.objectIds.size(), record);
                break;
            }
            logger.debug("Current record: {}: {} <-> {}, {} <-> {}", record, captureId, log.captureIds.get(record), currentOID, log.objectIds.get(record));
            if (log.captureIds.get(record) == captureId && log.objectIds.get(record) == currentOID) {
                logger.debug(log.methodNames.get(record));
                if (log.methodNames.get(record).equals(CaptureLog.END_CAPTURE_PSEUDO_METHOD)) {
                    if (--nestedCalls == 0) {
                        break;
                    }
                } else {
                    ++nestedCalls;
                }
            }
            ++record;
        }
        return record;
    }

    private void restoreArgs(Object[] args, int currentRecord, CaptureLog log, ICodeGenerator generator, Set<Class<?>> blackList) {
        for (int i = 0; i < args.length; ++i) {
            Integer oid = (Integer)args[i];
            if (oid == null) continue;
            this.restoreCodeFromLastPosTo(log, generator, oid, currentRecord, blackList);
        }
    }

    private int[] restoreCodeFromLastPosTo(CaptureLog log, ICodeGenerator generator, int oid, int end, Set<Class<?>> blackList) {
        logger.debug("Restoring code from last pos");
        int currentRecord = log.getRecordIndexOfWhereObjectWasInitializedFirst(oid);
        logger.debug("Current record: " + currentRecord);
        currentRecord = currentRecord > 0 ? ++currentRecord : -currentRecord;
        logger.debug("-> Current record {}, end {} ", (Object)currentRecord, (Object)end);
        while (currentRecord < end && !generator.isMaximumLengthReached() && TimeController.getInstance().isThereStillTimeInThisPhase()) {
            block17: {
                int i;
                Integer methodArgOID;
                Object[] methodArgs;
                int dependencyOID;
                String methodName;
                int[] exchange;
                Integer returnValue;
                int currentOID;
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        currentOID = log.objectIds.get(currentRecord);
                                        Object returnValueObj = log.returnValues.get(currentRecord);
                                        returnValue = returnValueObj.equals(CaptureLog.RETURN_TYPE_VOID) ? -1 : (Integer)returnValueObj;
                                        logger.debug("Checking: " + currentRecord + ": " + log.getTypeName(currentOID) + " to generate " + log.getTypeName(oid));
                                        if (oid != currentOID && returnValue != oid) break block17;
                                        logger.debug("Current record is currentOID {} or returnvalue", (Object)currentOID);
                                        if (oid != currentOID) {
                                            logger.debug("No, is not currentOID");
                                            exchange = this.restoreCodeFromLastPosTo(log, generator, currentOID, currentRecord, blackList);
                                            if (exchange != null) {
                                                return exchange;
                                            }
                                        }
                                        if (!CaptureLog.PLAIN_INIT.equals(methodName = log.methodNames.get(currentRecord))) break block18;
                                        logger.debug("Plain init");
                                        currentRecord = this.handlePlainInit(log, generator, currentRecord, currentOID);
                                        break block17;
                                    }
                                    if (!CaptureLog.COLLECTION_INIT.equals(methodName)) break block19;
                                    logger.debug("Collection init");
                                    currentRecord = this.handleCollectionInit(log, generator, blackList, currentRecord, currentOID);
                                    break block17;
                                }
                                if (!CaptureLog.MAP_INIT.equals(methodName)) break block20;
                                logger.debug("Map init");
                                currentRecord = this.handleMapInit(log, generator, blackList, currentRecord, currentOID);
                                break block17;
                            }
                            if (!CaptureLog.ARRAY_INIT.equals(methodName)) break block21;
                            logger.debug("Array init");
                            currentRecord = this.handleArrayInit(log, generator, blackList, currentRecord, currentOID);
                            break block17;
                        }
                        if (!CaptureLog.NOT_OBSERVED_INIT.equals(methodName)) break block22;
                        logger.debug("Unobserved init");
                        dependencyOID = log.getDependencyOID(oid);
                        if (dependencyOID != -1 && (exchange = this.restoreCodeFromLastPosTo(log, generator, dependencyOID, currentRecord, blackList)) != null) {
                            return exchange;
                        }
                        generator.createUnobservedInitStmt(log, currentRecord);
                        currentRecord = this.findEndOfMethod(log, currentRecord, currentOID);
                        break block17;
                    }
                    if (!"PUTFIELD".equals(methodName) && !"PUTSTATIC".equals(methodName) && !"GETFIELD".equals(methodName) && !"GETSTATIC".equals(methodName)) break block23;
                    logger.debug("Field access");
                    dependencyOID = log.getDependencyOID(oid);
                    if (dependencyOID != -1 && (exchange = this.restoreCodeFromLastPosTo(log, generator, dependencyOID, currentRecord, blackList)) != null) {
                        return exchange;
                    }
                    if ("PUTFIELD".equals(methodName) || "PUTSTATIC".equals(methodName)) {
                        methodArgs = log.params.get(currentRecord);
                        methodArgOID = (Integer)methodArgs[0];
                        if (methodArgOID != null && methodArgOID != oid && (exchange = this.restoreCodeFromLastPosTo(log, generator, methodArgOID, currentRecord, blackList)) != null) {
                            return exchange;
                        }
                        generator.createFieldWriteAccessStmt(log, currentRecord);
                    } else {
                        generator.createFieldReadAccessStmt(log, currentRecord);
                    }
                    currentRecord = this.findEndOfMethod(log, currentRecord, currentOID);
                    if (!"GETFIELD".equals(methodName) && !"GETSTATIC".equals(methodName)) break block17;
                    this.updateInitRec(log, currentOID, currentRecord);
                    if (returnValue == -1) break block17;
                    this.updateInitRec(log, returnValue, currentRecord);
                    break block17;
                }
                logger.debug("The rest: " + methodName);
                dependencyOID = log.getDependencyOID(oid);
                logger.debug("Dependency oid for {} is {} ", (Object)oid, (Object)dependencyOID);
                if (dependencyOID != -1) {
                    logger.debug("Dependencies");
                    exchange = this.restoreCodeFromLastPosTo(log, generator, dependencyOID, currentRecord, blackList);
                    if (exchange != null) {
                        return exchange;
                    }
                }
                int callerOID = this.findCaller(log, currentRecord);
                logger.debug("Caller oid {} ", (Object)callerOID);
                methodArgs = log.params.get(currentRecord);
                logger.debug("Getting " + methodArgs.length + " method args: {}", methodArgs);
                for (i = 0; i < methodArgs.length; ++i) {
                    methodArgOID = (Integer)methodArgs[i];
                    logger.debug("Argument {}", (Object)methodArgOID);
                    if (methodArgOID != null && methodArgOID == callerOID) {
                        int r = currentRecord;
                        while (this.isBlackListed(callerOID, blackList, log)) {
                            callerOID = this.findCaller(log, ++r);
                        }
                        blackList.add(this.getClassFromOID(log, oid));
                        return new int[]{oid, callerOID};
                    }
                    if (methodArgOID != null && this.isBlackListed(methodArgOID, blackList, log)) {
                        logger.debug("arg in blacklist >>>> {}", (Object)blackList.contains(this.getClassFromOID(log, methodArgOID)));
                        return this.getExchange(log, currentRecord, oid, blackList);
                    }
                    if (methodArgOID == null || methodArgOID == oid) continue;
                    logger.debug("Setting up code for argument {}", (Object)methodArgOID);
                    exchange = this.restoreCodeFromLastPosTo(log, generator, methodArgOID, currentRecord, blackList);
                    if (exchange == null) continue;
                    blackList.add(this.getClassFromOID(log, oid));
                    return exchange;
                }
                if (this.isBlackListed(currentOID, blackList, log)) {
                    logger.debug("-> is blacklisted... " + blackList + " oid: " + currentOID + " class: " + this.getClassFromOID(log, currentOID));
                    blackList.add(this.getClassFromOID(log, oid));
                    return this.getExchange(log, currentRecord, currentOID, blackList);
                }
                logger.debug("Adding method call {}", (Object)methodName);
                generator.createMethodCallStmt(log, currentRecord);
                currentRecord = this.findEndOfMethod(log, currentRecord, currentOID);
                this.updateInitRec(log, currentOID, currentRecord);
                if (returnValue != -1) {
                    this.updateInitRec(log, returnValue, currentRecord);
                }
                for (i = 0; i < methodArgs.length; ++i) {
                    methodArgOID = (Integer)methodArgs[i];
                    if (methodArgOID == null || methodArgOID == oid) continue;
                    this.updateInitRec(log, methodArgOID, currentRecord);
                }
            }
            ++currentRecord;
        }
        return null;
    }

    private int handleArrayInit(CaptureLog log, ICodeGenerator<?> generator, Set<Class<?>> blackList, int currentRecord, int currentOID) {
        try {
            Object[] methodArgs = log.params.get(currentRecord);
            this.restoreArgs(methodArgs, currentRecord, log, generator, blackList);
            generator.createArrayInitStmt(log, currentRecord);
            currentRecord = this.findEndOfMethod(log, currentRecord, currentOID);
            this.updateInitRec(log, currentOID, currentRecord);
            return currentRecord;
        }
        catch (Exception e) {
            CaptureLogAnalyzerException.propagateError(e, "[currentRecord = %s, currentOID = %s, blackList = %s] - an error occurred while creating array init stmt\n", currentRecord, currentOID, blackList);
            return -1;
        }
    }

    private int handleMapInit(CaptureLog log, ICodeGenerator<?> generator, Set<Class<?>> blackList, int currentRecord, int currentOID) {
        try {
            Object[] methodArgs = log.params.get(currentRecord);
            this.restoreArgs(methodArgs, currentRecord, log, generator, blackList);
            generator.createMapInitStmt(log, currentRecord);
            currentRecord = this.findEndOfMethod(log, currentRecord, currentOID);
            this.updateInitRec(log, currentOID, currentRecord);
            return currentRecord;
        }
        catch (Exception e) {
            CaptureLogAnalyzerException.propagateError(e, "[currentRecord = %s, currentOID = %s, blackList = %s] - an error occurred while creating map init stmt\n", currentRecord, currentOID, blackList);
            return -1;
        }
    }

    private int handleCollectionInit(CaptureLog log, ICodeGenerator<?> generator, Set<Class<?>> blackList, int currentRecord, int currentOID) {
        try {
            Object[] methodArgs = log.params.get(currentRecord);
            this.restoreArgs(methodArgs, currentRecord, log, generator, blackList);
            generator.createCollectionInitStmt(log, currentRecord);
            currentRecord = this.findEndOfMethod(log, currentRecord, currentOID);
            this.updateInitRec(log, currentOID, currentRecord);
            return currentRecord;
        }
        catch (Exception e) {
            CaptureLogAnalyzerException.propagateError(e, "[currentRecord = %s, currentOID = %s, blackList = %s] - an error occurred while creating collection init stmt\n", currentRecord, currentOID, blackList);
            return -1;
        }
    }

    private int handlePlainInit(CaptureLog log, ICodeGenerator<?> generator, int currentRecord, int currentOID) {
        generator.createPlainInitStmt(log, currentRecord);
        currentRecord = this.findEndOfMethod(log, currentRecord, currentOID);
        this.updateInitRec(log, currentOID, currentRecord);
        return currentRecord;
    }

    private boolean isBlackListed(int oid, Set<Class<?>> blackList, CaptureLog log) {
        String typeName = log.getTypeName(oid);
        if (typeName.contains("$Proxy")) {
            return true;
        }
        return blackList.contains(this.getClassFromOID(log, oid));
    }

    private int[] getExchange(CaptureLog log, int currentRecord, int oid, Set<Class<?>> blackList) {
        int callerOID;
        int r = currentRecord;
        while (this.isBlackListed(callerOID = this.findCaller(log, ++r), blackList, log)) {
        }
        blackList.add(this.getClassFromOID(log, oid));
        return new int[]{oid, callerOID};
    }
}

