/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm.math;

import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.fp.RealBinaryExpression;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.evosuite.symbolic.vm.SymbolicFunction;
import org.evosuite.symbolic.vm.math.Types;

public abstract class CopySign {
    private static final String COPY_SIGN = "copySign";

    public static final class CopySign_D
    extends SymbolicFunction {
        private static final String COPY_SIGN = "copySign";

        public CopySign_D(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, "copySign", Types.DD2D_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            RealValue copySignExpr;
            double res = this.getConcDoubleRetVal();
            RealValue left = this.getSymbRealArgument(0);
            RealValue right = this.getSymbRealArgument(1);
            if (left.containsSymbolicVariable() || right.containsSymbolicVariable()) {
                Operator op = Operator.COPYSIGN;
                copySignExpr = new RealBinaryExpression(left, op, right, res);
            } else {
                copySignExpr = this.getSymbRealRetVal();
            }
            return copySignExpr;
        }
    }

    public static final class CopySign_F
    extends SymbolicFunction {
        public CopySign_F(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, CopySign.COPY_SIGN, Types.FF2F_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            RealValue copySignExpr;
            float res = this.getConcFloatRetVal();
            RealValue left = this.getSymbRealArgument(0);
            RealValue right = this.getSymbRealArgument(1);
            if (left.containsSymbolicVariable() || right.containsSymbolicVariable()) {
                Operator op = Operator.COPYSIGN;
                copySignExpr = new RealBinaryExpression(left, op, right, Double.valueOf(res));
            } else {
                copySignExpr = this.getSymbRealRetVal();
            }
            return copySignExpr;
        }
    }
}

