/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.z3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerVariable;
import org.evosuite.symbolic.expr.fp.RealVariable;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.SmtExprBuilder;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverErrorException;
import org.evosuite.symbolic.solver.SolverParseException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.SubProcessSolver;
import org.evosuite.symbolic.solver.smt.SmtAssertion;
import org.evosuite.symbolic.solver.smt.SmtCheckSatQuery;
import org.evosuite.symbolic.solver.smt.SmtConstantDeclaration;
import org.evosuite.symbolic.solver.smt.SmtExpr;
import org.evosuite.symbolic.solver.z3.ConstraintToZ3Visitor;
import org.evosuite.symbolic.solver.z3.Z3QueryPrinter;
import org.evosuite.symbolic.solver.z3.Z3ResultParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z3Solver
extends SubProcessSolver {
    static Logger logger = LoggerFactory.getLogger(Z3Solver.class);

    public Z3Solver() {
    }

    public Z3Solver(boolean addMissingVariables) {
        super(addMissingVariables);
    }

    @Override
    public SolverResult solve(Collection<Constraint<?>> constraints) throws SolverTimeoutException, IOException, SolverParseException, SolverEmptyQueryException, SolverErrorException {
        long hard_timeout = Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS;
        HashSet variables = new HashSet();
        for (Constraint<?> c : constraints) {
            Set<Variable<?>> c_variables = c.getVariables();
            variables.addAll(c_variables);
        }
        SmtCheckSatQuery smtCheckSatQuery = Z3Solver.buildSmtQuery(constraints, variables);
        if (smtCheckSatQuery.getConstantDeclarations().isEmpty()) {
            logger.debug("Z3 SMT query has no variables");
            throw new SolverEmptyQueryException("Z3 SMT query has no variables");
        }
        if (smtCheckSatQuery.getAssertions().isEmpty()) {
            HashMap<String, Object> emptySolution = new HashMap<String, Object>();
            SolverResult emptySAT = SolverResult.newSAT(emptySolution);
            return emptySAT;
        }
        Z3QueryPrinter printer = new Z3QueryPrinter();
        String smtQueryStr = printer.print(smtCheckSatQuery, hard_timeout);
        logger.debug("Z3 Query:");
        logger.debug(smtQueryStr);
        if (Properties.Z3_PATH == null) {
            String errMsg = "Property Z3_PATH should be setted in order to use the Z3 Solver!";
            logger.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        String z3Cmd = Properties.Z3_PATH + " -smt2 -in";
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        Z3Solver.launchNewProcess(z3Cmd, smtQueryStr, (int)hard_timeout, stdout);
        String z3ResultStr = stdout.toString("UTF-8");
        Map<String, Object> initialValues = Z3Solver.getConcreteValues(variables);
        Z3ResultParser resultParser = this.addMissingVariables() ? new Z3ResultParser(initialValues) : new Z3ResultParser();
        SolverResult result = resultParser.parseResult(z3ResultStr);
        return result;
    }

    private static SmtCheckSatQuery buildSmtQuery(Collection<Constraint<?>> constraints, Set<Variable<?>> variables) {
        LinkedList<SmtConstantDeclaration> constantDeclarations = new LinkedList<SmtConstantDeclaration>();
        for (Variable<?> variable : variables) {
            String string = variable.getName();
            if (variable instanceof IntegerVariable) {
                SmtConstantDeclaration intVar = SmtExprBuilder.mkIntConstantDeclaration(string);
                constantDeclarations.add(intVar);
                continue;
            }
            if (variable instanceof RealVariable) {
                SmtConstantDeclaration realVar = SmtExprBuilder.mkRealConstantDeclaration(string);
                constantDeclarations.add(realVar);
                continue;
            }
            if (variable instanceof StringVariable) continue;
            throw new RuntimeException("Unknown variable type " + variable.getClass().getCanonicalName());
        }
        LinkedList<SmtAssertion> assertions = new LinkedList<SmtAssertion>();
        for (Constraint<?> constraint : constraints) {
            ConstraintToZ3Visitor v;
            SmtExpr bool_expr = constraint.accept(v = new ConstraintToZ3Visitor(), null);
            if (bool_expr == null || !bool_expr.isSymbolic()) continue;
            SmtAssertion newAssertion = new SmtAssertion(bool_expr);
            assertions.add(newAssertion);
        }
        SmtCheckSatQuery smtCheckSatQuery = new SmtCheckSatQuery(constantDeclarations, assertions);
        return smtCheckSatQuery;
    }
}

