/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.cvc4;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.evosuite.symbolic.solver.ResultParser;
import org.evosuite.symbolic.solver.SolverErrorException;
import org.evosuite.symbolic.solver.SolverParseException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CVC4ResultParser
extends ResultParser {
    private final Map<String, Object> initialValues;
    static Logger logger = LoggerFactory.getLogger(CVC4ResultParser.class);

    public CVC4ResultParser(Map<String, Object> initialValues) {
        this.initialValues = initialValues;
    }

    public CVC4ResultParser() {
        this.initialValues = null;
    }

    public SolverResult parse(String cvc4ResultStr) throws SolverParseException, SolverErrorException, SolverTimeoutException {
        if (cvc4ResultStr.startsWith("sat")) {
            logger.debug("CVC4 outcome was SAT");
            SolverResult satResult = this.parseModel(cvc4ResultStr);
            return satResult;
        }
        if (cvc4ResultStr.startsWith("unsat")) {
            logger.debug("CVC4 outcome was UNSAT");
            SolverResult unsatResult = SolverResult.newUNSAT();
            return unsatResult;
        }
        if (cvc4ResultStr.startsWith("unknown")) {
            logger.debug("CVC4 outcome was UNKNOWN (probably due to timeout)");
            throw new SolverTimeoutException();
        }
        if (cvc4ResultStr.startsWith("(error")) {
            logger.debug("CVC4 output was the following " + cvc4ResultStr);
            throw new SolverErrorException("An error (probably an invalid input) occurred while executing CVC4");
        }
        logger.debug("The following CVC4 output could not be parsed " + cvc4ResultStr);
        throw new SolverParseException("CVC4 output is unknown. We are unable to parse it to a proper solution!", cvc4ResultStr);
    }

    private SolverResult parseModel(String cvc4ResultStr) {
        HashMap<String, Object> solution = new HashMap<String, Object>();
        StringTokenizer tokenizer = new StringTokenizer(cvc4ResultStr, "() \n\t", true);
        String token = tokenizer.nextToken();
        token = tokenizer.nextToken();
        token = tokenizer.nextToken();
        token = tokenizer.nextToken();
        token = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens() && !(token = tokenizer.nextToken()).equals(")")) {
            token = tokenizer.nextToken();
            if (!token.equals("define-fun")) continue;
            token = tokenizer.nextToken();
            String fun_name = tokenizer.nextToken();
            token = tokenizer.nextToken();
            token = tokenizer.nextToken();
            token = tokenizer.nextToken();
            token = tokenizer.nextToken();
            String typeName = tokenizer.nextToken();
            if (typeName.equals("Int")) {
                Long value;
                String integerValueStr;
                token = tokenizer.nextToken();
                token = tokenizer.nextToken();
                boolean neg = false;
                if (token.equals("(")) {
                    neg = true;
                    token = tokenizer.nextToken();
                    token = tokenizer.nextToken();
                    integerValueStr = tokenizer.nextToken();
                } else {
                    integerValueStr = token;
                }
                if (neg) {
                    String absoluteIntegerValue = integerValueStr;
                    value = Long.parseLong("-" + absoluteIntegerValue);
                } else {
                    value = Long.parseLong(integerValueStr);
                }
                solution.put(fun_name, value);
                if (neg) {
                    token = tokenizer.nextToken();
                }
                token = tokenizer.nextToken();
                token = tokenizer.nextToken();
                continue;
            }
            if (typeName.equals("Real")) {
                Double value;
                token = tokenizer.nextToken();
                token = tokenizer.nextToken();
                if (!token.equals("(")) {
                    value = Double.parseDouble(token);
                } else {
                    String denominatorStr;
                    String numeratorStr;
                    token = tokenizer.nextToken();
                    if (token.equals("-")) {
                        token = tokenizer.nextToken();
                        token = tokenizer.nextToken();
                        if (token.equals("(")) {
                            token = tokenizer.nextToken();
                            token = tokenizer.nextToken();
                            numeratorStr = tokenizer.nextToken();
                            token = tokenizer.nextToken();
                            denominatorStr = tokenizer.nextToken();
                            value = CVC4ResultParser.parseRational(true, numeratorStr, denominatorStr);
                            token = tokenizer.nextToken();
                            token = tokenizer.nextToken();
                        } else {
                            String absoluteValueStr = token;
                            value = Double.parseDouble("-" + absoluteValueStr);
                            token = tokenizer.nextToken();
                        }
                    } else if (token.equals("/")) {
                        token = tokenizer.nextToken();
                        numeratorStr = tokenizer.nextToken();
                        token = tokenizer.nextToken();
                        denominatorStr = tokenizer.nextToken();
                        value = CVC4ResultParser.parseRational(false, numeratorStr, denominatorStr);
                        token = tokenizer.nextToken();
                    } else {
                        value = Double.parseDouble(token);
                    }
                }
                solution.put(fun_name, value);
                token = tokenizer.nextToken();
                token = tokenizer.nextToken();
                continue;
            }
            if (!typeName.equals("String")) continue;
            token = tokenizer.nextToken();
            StringBuffer value = new StringBuffer();
            while (!token.startsWith("\"")) {
                token = tokenizer.nextToken();
            }
            value.append(token);
            if (!token.substring(1).endsWith("\"")) {
                String stringToken;
                do {
                    if (!tokenizer.hasMoreTokens()) {
                        System.out.println("Error!");
                    }
                    stringToken = tokenizer.nextToken();
                    value.append(stringToken);
                } while (!stringToken.endsWith("\""));
            }
            String stringWithQuotes = value.toString();
            String stringWithoutQuotes = stringWithQuotes.substring(1, stringWithQuotes.length() - 1);
            solution.put(fun_name, stringWithoutQuotes);
            token = tokenizer.nextToken();
            token = tokenizer.nextToken();
        }
        if (solution.isEmpty()) {
            logger.warn("The CVC4 model has no variables");
            return null;
        }
        logger.debug("Parsed values from CVC4 output");
        for (String varName : solution.keySet()) {
            String valueOf = String.valueOf(solution.get(varName));
            logger.debug(varName + ":" + valueOf);
        }
        if (this.initialValues != null && !solution.keySet().equals(this.initialValues.keySet())) {
            logger.debug("Adding missing values to Solver solution");
            CVC4ResultParser.addMissingValues(this.initialValues, solution);
        }
        SolverResult satResult = SolverResult.newSAT(solution);
        return satResult;
    }

    private static void addMissingValues(Map<String, Object> initialValues, Map<String, Object> solution) {
        for (String otherVarName : initialValues.keySet()) {
            if (solution.containsKey(otherVarName)) continue;
            solution.put(otherVarName, initialValues.get(otherVarName));
        }
    }
}

