/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.avm;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.ExpressionExecutor;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.expr.str.StringValue;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.expr.token.HasMoreTokensExpr;
import org.evosuite.symbolic.solver.DistanceEstimator;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.avm.VariableAVM;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StringAVM
extends VariableAVM {
    static Logger log = LoggerFactory.getLogger(StringAVM.class);
    private double checkpointDistance = Double.MAX_VALUE;
    private String checkpointStringValue;
    private final StringVariable strVar;

    public StringAVM(StringVariable strVar, Collection<Constraint<?>> cnstr, long start_time, long timeout) {
        super(cnstr, start_time, timeout);
        this.strVar = strVar;
    }

    @Override
    public boolean applyAVM() throws SolverTimeoutException {
        ExpressionExecutor exprExecutor = new ExpressionExecutor();
        log.debug("Trying to remove characters");
        boolean improvement = false;
        this.checkpointVar(DistanceEstimator.getDistance(this.cnstr));
        String oldString = (String)this.strVar.getConcreteValue();
        boolean improved = true;
        while (improved && oldString.length() > 0) {
            if (this.isFinished()) {
                throw new SolverTimeoutException();
            }
            String newStr = oldString.substring(0, oldString.length() - 1);
            this.strVar.setConcreteValue(newStr);
            log.debug("Current attempt: " + newStr);
            improved = false;
            double newDist = DistanceEstimator.getDistance(this.cnstr);
            if (newDist <= this.checkpointDistance) {
                log.debug("Distance improved or did not increase, keeping change");
                this.checkpointVar(newDist);
                improvement = true;
                improved = true;
                oldString = newStr;
                if (newDist != 0.0) continue;
                return true;
            }
            log.debug("Distance did not improve, reverting change");
            this.restoreVar();
        }
        log.debug("Trying to replace characters");
        if (this.doStringAVM(oldString)) {
            improvement = true;
            oldString = (String)this.strVar.getConcreteValue();
        }
        if (this.checkpointDistance == 0.0) {
            return true;
        }
        log.debug("Trying to add characters");
        this.checkpointVar(DistanceEstimator.getDistance(this.cnstr));
        improved = true;
        while (improved) {
            if (this.isFinished()) {
                throw new SolverTimeoutException();
            }
            improved = false;
            char charToInsert = Randomness.nextChar();
            String newStr = oldString + charToInsert;
            this.strVar.setConcreteValue(newStr);
            double newDist = DistanceEstimator.getDistance(this.cnstr);
            log.debug("Adding: " + newStr + ": " + newDist);
            if (this.distImpr(newDist)) {
                improvement = true;
                improved = true;
                this.checkpointVar(newDist);
                if (this.checkpointDistance == 0.0) {
                    log.debug("Search seems successful, stopping at " + this.checkpointDistance + "/" + newDist);
                    return true;
                }
                this.doCharacterAVM(newStr.length() - 1);
                oldString = (String)this.strVar.getConcreteValue();
                continue;
            }
            this.restoreVar();
        }
        Set<StringValue> delimiters = StringAVM.getTokenDelimiters(this.cnstr);
        for (StringValue delimiter : delimiters) {
            if (this.isFinished()) {
                throw new SolverTimeoutException();
            }
            improved = true;
            String delimiterStr = (String)delimiter.accept(exprExecutor, null);
            while (improved) {
                if (this.isFinished()) {
                    throw new SolverTimeoutException();
                }
                improved = false;
                char charToInsert = Randomness.nextChar();
                String newStr = oldString + delimiterStr + charToInsert;
                this.strVar.setConcreteValue(newStr);
                double newDist = DistanceEstimator.getDistance(this.cnstr);
                log.debug("Adding: " + newStr + ": " + newDist);
                if (this.distImpr(newDist)) {
                    improvement = true;
                    improved = true;
                    this.checkpointVar(newDist);
                    if (this.checkpointDistance == 0.0) {
                        log.debug("Search seems successful, stopping at " + this.checkpointDistance + "/" + newDist);
                        return true;
                    }
                    this.doCharacterAVM(newStr.length() - 1);
                    oldString = (String)this.strVar.getConcreteValue();
                    continue;
                }
                this.restoreVar();
            }
        }
        return improvement;
    }

    private void checkpointVar(double newDist) {
        this.checkpointStringValue = (String)this.strVar.getConcreteValue();
        this.checkpointDistance = newDist;
    }

    private boolean distImpr(double newDistance) {
        return newDistance < this.checkpointDistance;
    }

    private void restoreVar() {
        this.strVar.setConcreteValue(this.checkpointStringValue);
    }

    private boolean doCharacterAVM(int position) throws SolverTimeoutException {
        this.checkpointVar(DistanceEstimator.getDistance(this.cnstr));
        boolean done = false;
        boolean hasImproved = false;
        while (!done) {
            if (this.isFinished()) {
                throw new SolverTimeoutException();
            }
            done = true;
            String origString = (String)this.strVar.getConcreteValue();
            char oldChar = origString.charAt(position);
            char[] characters = origString.toCharArray();
            char replacement = oldChar;
            characters[position] = replacement = this.nextChar(replacement, 1);
            String newString = new String(characters);
            this.strVar.setConcreteValue(newString);
            double newDist = DistanceEstimator.getDistance(this.cnstr);
            log.debug("Probing increment " + position + ": " + newString + ": " + newDist + " replacement = " + replacement);
            if (this.distImpr(newDist)) {
                this.checkpointVar(newDist);
                if (newDist == 0.0) {
                    return true;
                }
                done = false;
                hasImproved = true;
                this.iterateCharacterAVM(position, 2);
                continue;
            }
            characters[position] = replacement = this.nextChar(replacement, -2);
            newString = new String(characters);
            this.strVar.setConcreteValue(newString);
            newDist = DistanceEstimator.getDistance(this.cnstr);
            log.debug("Probing decrement " + position + ": " + newString + ": " + newDist + " replacement = " + replacement);
            if (this.distImpr(newDist)) {
                this.checkpointVar(newDist);
                if (newDist == 0.0) {
                    return true;
                }
                done = false;
                hasImproved = true;
                this.iterateCharacterAVM(position, -2);
                continue;
            }
            characters[position] = replacement = (char)(oldChar + 32);
            newString = new String(characters);
            this.strVar.setConcreteValue(newString);
            newDist = DistanceEstimator.getDistance(this.cnstr);
            log.debug("Probing increment [32] " + position + ": " + newString + ": " + newDist + " replacement = " + replacement);
            if (this.distImpr(newDist)) {
                this.checkpointVar(newDist);
                done = false;
                hasImproved = true;
                break;
            }
            characters[position] = replacement = (char)(oldChar + 32);
            newString = new String(characters);
            this.strVar.setConcreteValue(newString);
            newDist = DistanceEstimator.getDistance(this.cnstr);
            log.debug("Probing increment [32] " + position + ": " + newString + ": " + newDist + " replacement = " + replacement);
            if (this.distImpr(newDist)) {
                this.checkpointVar(newDist);
                done = false;
                hasImproved = true;
            } else {
                this.restoreVar();
            }
            if (done) {
                log.debug("Search finished " + position + ": " + newString + ": " + newDist);
                continue;
            }
            log.debug("Going for another iteration at position " + position);
        }
        return hasImproved;
    }

    private boolean doStringAVM(String oldString) throws SolverTimeoutException {
        boolean improvement = false;
        for (int i = 0; i < oldString.length(); ++i) {
            if (this.isFinished()) {
                throw new SolverTimeoutException();
            }
            log.info("Current character: " + i);
            if (!this.doCharacterAVM(i)) continue;
            improvement = true;
        }
        return improvement;
    }

    private boolean iterateCharacterAVM(int position, int delta) throws SolverTimeoutException {
        boolean improvement = false;
        String oldString = (String)this.strVar.getConcreteValue();
        log.debug("Trying increment " + delta + " of " + oldString);
        char oldChar = oldString.charAt(position);
        log.info(" -> Character " + position + ": " + oldChar);
        char[] characters = oldString.toCharArray();
        char replacement = oldChar;
        characters[position] = replacement = this.nextChar(replacement, delta);
        String newString = new String(characters);
        this.strVar.setConcreteValue(newString);
        double newDist = DistanceEstimator.getDistance(this.cnstr);
        while (this.distImpr(newDist)) {
            if (this.isFinished()) {
                throw new SolverTimeoutException();
            }
            this.checkpointVar(newDist);
            if (newDist == 0.0) {
                return true;
            }
            oldString = newString;
            improvement = true;
            delta = 2 * delta;
            replacement = this.nextChar(replacement, delta);
            log.info("Current delta: " + delta + " -> " + replacement);
            characters[position] = replacement;
            newString = new String(characters);
            log.info(" " + position + " " + oldString + "/" + oldString.length() + " -> " + newString + "/" + newString.length());
            this.strVar.setConcreteValue(newString);
            newDist = DistanceEstimator.getDistance(this.cnstr);
        }
        log.debug("No improvement on " + oldString);
        this.restoreVar();
        log.debug("Final value of this iteration: " + oldString);
        return improvement;
    }

    private char nextChar(char oldChar, int delta) {
        char nextChar = (char)(oldChar + delta);
        if (delta >= 0) {
            if (nextChar < oldChar) {
                nextChar = '\uffff';
            }
        } else if (nextChar > oldChar) {
            nextChar = '\u0000';
        }
        return (char)nextChar;
    }

    private static Set<StringValue> getTokenDelimiters(Collection<Constraint<?>> constraints) {
        HashSet<StringValue> delimiters = new HashSet<StringValue>();
        for (Constraint<?> constraint : constraints) {
            StringConstraint stringConstraint;
            if (!(constraint instanceof StringConstraint) || !((stringConstraint = (StringConstraint)constraint).getLeftOperand() instanceof HasMoreTokensExpr)) continue;
            HasMoreTokensExpr hasMoreTokensExpr = (HasMoreTokensExpr)stringConstraint.getLeftOperand();
            StringValue delimiter = hasMoreTokensExpr.getTokenizerExpr().getDelimiter();
            delimiters.add(delimiter);
        }
        return delimiters;
    }
}

