/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver;

import java.util.Collection;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.DistanceCalculator;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.RealConstraint;
import org.evosuite.symbolic.expr.StringConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DistanceEstimator {
    static Logger log = LoggerFactory.getLogger(DistanceEstimator.class);

    private static double normalize(double x) {
        return x / (x + 1.0);
    }

    public static double getDistance(Collection<Constraint<?>> constraints) {
        double result = 0.0;
        DistanceCalculator distanceCalculator = new DistanceCalculator();
        try {
            for (Constraint<?> c : constraints) {
                if (c instanceof StringConstraint) {
                    StringConstraint string_constraint = (StringConstraint)c;
                    try {
                        double strD = (Double)string_constraint.accept(distanceCalculator, null);
                        result += DistanceEstimator.normalize(strD);
                        log.debug("S: " + string_constraint + " strDist " + strD);
                    }
                    catch (Throwable t) {
                        log.debug("S: " + string_constraint + " strDist " + t);
                        result += 1.0;
                    }
                    continue;
                }
                if (c instanceof IntegerConstraint) {
                    IntegerConstraint integer_constraint = (IntegerConstraint)c;
                    long intD = (Long)integer_constraint.accept(distanceCalculator, null);
                    result += DistanceEstimator.normalize(intD);
                    log.debug("C: " + integer_constraint + " intDist " + intD);
                    continue;
                }
                if (c instanceof RealConstraint) {
                    RealConstraint real_constraint = (RealConstraint)c;
                    double realD = (Double)real_constraint.accept(distanceCalculator, null);
                    result += DistanceEstimator.normalize(realD);
                    log.debug("C: " + real_constraint + " realDist " + realD);
                    continue;
                }
                throw new IllegalArgumentException("DistanceCalculator: got an unknown constraint: " + c);
            }
            log.debug("Resulting distance: " + result);
            return Math.abs(result);
        }
        catch (Exception e) {
            return Double.MAX_VALUE;
        }
    }
}

