/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.instrument;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.evosuite.dse.util.Assertions;
import org.evosuite.shaded.org.objectweb.asm.Label;
import org.evosuite.shaded.org.objectweb.asm.MethodVisitor;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.shaded.org.objectweb.asm.commons.GeneratorAdapter;
import org.evosuite.symbolic.instrument.AccessFlags;
import org.evosuite.symbolic.instrument.ConcolicConfig;
import org.evosuite.symbolic.instrument.OperandStack;

public final class ConcolicMethodAdapter
extends GeneratorAdapter {
    private static final String THIS$0 = "this$0";
    private static final String INIT = "<init>";
    private static final String CLINIT = "<clinit>";
    private static final String METHOD_BEGIN = "METHOD_BEGIN";
    private static final String METHOD_BEGIN_PARAM = "METHOD_BEGIN_PARAM";
    private static final String METHOD_BEGIN_RECEIVER = "METHOD_BEGIN_RECEIVER";
    private static final String CALL_RESULT = "CALL_RESULT";
    private final int access;
    private final String className;
    private final String methName;
    private final String methDescription;
    private final OperandStack stack;
    private int branchCounter = 1;
    private final Set<Label> exceptionHandlers = new HashSet<Label>();

    ConcolicMethodAdapter(MethodVisitor mv, int access, String className, String methName, String desc) {
        super(262144, mv, access, methName, desc);
        this.access = access;
        this.className = Assertions.notNull(className);
        this.methName = Assertions.notNull(methName);
        this.methDescription = Assertions.notNull(desc);
        this.stack = new OperandStack(mv);
    }

    @Override
    public void visitCode() {
        boolean needThis;
        super.visitCode();
        this.stack.pushInt(this.access);
        this.stack.pushStrings(this.className, this.methName, this.methDescription);
        this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, METHOD_BEGIN, "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
        boolean bl = needThis = !AccessFlags.isStatic(this.access) && !CLINIT.equals(this.methName);
        if (needThis && !INIT.equals(this.methName)) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, METHOD_BEGIN_RECEIVER, "(Ljava/lang/Object;)V");
        }
        Type[] paramTypes = Type.getArgumentTypes(this.methDescription);
        int paramNr = 0;
        int calleeLocalsIndex = 0;
        if (needThis) {
            ++calleeLocalsIndex;
        }
        for (Type type : paramTypes) {
            String dscMethParamSign = null;
            switch (type.getSort()) {
                case 1: {
                    this.mv.visitVarInsn(21, calleeLocalsIndex);
                    dscMethParamSign = "(ZII)V";
                    break;
                }
                case 3: {
                    this.mv.visitVarInsn(21, calleeLocalsIndex);
                    dscMethParamSign = "(BII)V";
                    break;
                }
                case 2: {
                    this.mv.visitVarInsn(21, calleeLocalsIndex);
                    dscMethParamSign = "(CII)V";
                    break;
                }
                case 4: {
                    this.mv.visitVarInsn(21, calleeLocalsIndex);
                    dscMethParamSign = "(SII)V";
                    break;
                }
                case 5: {
                    this.mv.visitVarInsn(21, calleeLocalsIndex);
                    dscMethParamSign = "(III)V";
                    break;
                }
                case 7: {
                    this.mv.visitVarInsn(22, calleeLocalsIndex);
                    dscMethParamSign = "(JII)V";
                    break;
                }
                case 8: {
                    this.mv.visitVarInsn(24, calleeLocalsIndex);
                    dscMethParamSign = "(DII)V";
                    break;
                }
                case 6: {
                    this.mv.visitVarInsn(23, calleeLocalsIndex);
                    dscMethParamSign = "(FII)V";
                    break;
                }
                case 9: 
                case 10: {
                    this.mv.visitVarInsn(25, calleeLocalsIndex);
                    dscMethParamSign = "(Ljava/lang/Object;II)V";
                }
            }
            this.stack.pushInt(paramNr);
            this.stack.pushInt(calleeLocalsIndex);
            this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, METHOD_BEGIN_PARAM, dscMethParamSign);
            ++paramNr;
            calleeLocalsIndex += type.getSize();
        }
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 108: 
            case 112: {
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(I)V");
                break;
            }
            case 109: 
            case 113: {
                this.mv.visitInsn(92);
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(J)V");
                break;
            }
            case 110: 
            case 114: {
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(F)V");
                break;
            }
            case 111: 
            case 115: {
                this.mv.visitInsn(92);
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(D)V");
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.mv.visitInsn(92);
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(Ljava/lang/Object;I)V");
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.stack.c1b1a1__c1b1a1c1();
                this.stack.c1b1a1__c1b1a1c1();
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(Ljava/lang/Object;I)V");
                break;
            }
            case 80: 
            case 82: {
                this.stack.c1b1a2__c1b1a2c1();
                this.stack.c1b2a1__c1b2a1c1();
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(Ljava/lang/Object;I)V");
                break;
            }
            case 190: 
            case 191: {
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(Ljava/lang/Object;)V");
                break;
            }
            default: {
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "()V");
            }
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methName);
                this.mv.visitLdcInsn(this.branchCounter++);
                String IGGI_V = "(ILjava/lang/String;Ljava/lang/String;I)V";
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], IGGI_V);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                this.mv.visitInsn(92);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methName);
                this.mv.visitLdcInsn(this.branchCounter++);
                String IIGGI_V = "(IILjava/lang/String;Ljava/lang/String;I)V";
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], IIGGI_V);
                break;
            }
            case 165: 
            case 166: {
                this.mv.visitInsn(92);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methName);
                this.mv.visitLdcInsn(this.branchCounter++);
                String LLGGI_V = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;I)V";
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], LLGGI_V);
                break;
            }
            case 198: 
            case 199: {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methName);
                this.mv.visitLdcInsn(this.branchCounter++);
                String LGGI_V = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;I)V";
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], LGGI_V);
                break;
            }
            case 167: 
            case 168: {
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "()V");
                break;
            }
            case 200: 
            case 201: {
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "()V");
                break;
            }
            default: {
                Assertions.check(false, ConcolicConfig.BYTECODE_NAME[opcode] + " is not a jump instruction.");
            }
        }
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.stack.pushInt(line);
        this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, "SRC_LINE_NUMBER", "(I)V");
        super.visitLineNumber(line, start);
    }

    @Override
    public void visitLabel(Label label) {
        super.visitLabel(label);
        if (!this.exceptionHandlers.contains(label)) {
            this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, "BB_BEGIN", "()V");
            return;
        }
        this.stack.pushInt(this.access);
        this.stack.pushStrings(this.className, this.methName, this.methDescription);
        this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, "HANDLER_BEGIN", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        switch (opcode) {
            case 16: 
            case 17: {
                super.visitIntInsn(opcode, operand);
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(I)V");
                return;
            }
            case 188: {
                this.mv.visitInsn(89);
                this.mv.visitIntInsn(16, operand);
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(II)V");
                super.visitIntInsn(opcode, operand);
                return;
            }
        }
        Assertions.check(false);
    }

    @Override
    public void visitLdcInsn(Object constant) {
        super.visitLdcInsn(constant);
        Assertions.notNull(constant);
        if (constant instanceof Integer) {
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[18], "(I)V");
        } else if (constant instanceof Float) {
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[18], "(F)V");
        } else if (constant instanceof String) {
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[18], "(Ljava/lang/String;)V");
        } else if (constant instanceof Type) {
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[18], "(Ljava/lang/Class;)V");
        } else {
            this.mv.visitInsn(92);
            if (constant instanceof Long) {
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[20], "(J)V");
            } else if (constant instanceof Double) {
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[20], "(D)V");
            } else {
                Assertions.check(false);
            }
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        Assertions.check(var >= 0);
        if (21 <= opcode && opcode <= 25 || 54 <= opcode && opcode <= 58) {
            this.stack.pushInt(var);
            this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(I)V");
        } else {
            this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "()V");
        }
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (!name.equals(THIS$0)) {
            String signInvoke = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
            Type fieldType = Type.getType(desc);
            if (opcode == 180) {
                this.mv.visitInsn(89);
                signInvoke = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
            }
            if (opcode == 181) {
                signInvoke = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
                if (fieldType.getSize() == 1) {
                    this.stack.b1a1__b1a1b1();
                } else if (fieldType.getSize() == 2) {
                    this.stack.b1a2__b1a2b1();
                } else {
                    Assertions.check(false);
                }
            }
            this.stack.pushStrings(owner, name, desc);
            this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], signInvoke);
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        Type[] argTypes = Type.getArgumentTypes(desc);
        String signInvoke = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
        if (opcode == 182 || opcode == 185 || opcode == 183 && !INIT.equals(name)) {
            int i;
            Type[] args = Type.getArgumentTypes(desc);
            HashMap<Integer, Integer> to = new HashMap<Integer, Integer>();
            for (i = args.length - 1; i >= 0; --i) {
                int loc = this.newLocal(args[i]);
                this.storeLocal(loc);
                to.put(i, loc);
            }
            this.dup();
            for (i = 0; i < args.length; ++i) {
                this.loadLocal((Integer)to.get(i));
                Type ownerType = Type.getType(owner);
                this.swap(ownerType, args[i]);
            }
            signInvoke = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
            this.stack.pushStrings(owner, name, desc);
            this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], signInvoke);
        } else {
            signInvoke = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
            this.stack.pushStrings(owner, name, desc);
            this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], signInvoke);
        }
        boolean needThis = opcode == 182 || opcode == 185 || opcode == 183;
        this.passCallerStackParams(argTypes, needThis);
        super.visitMethodInsn(opcode, owner, name, desc);
        Type returnType = Type.getReturnType(desc);
        if (returnType.getSort() != 0) {
            if (returnType.getSize() == 2) {
                this.mv.visitInsn(92);
            } else {
                this.mv.visitInsn(89);
            }
        }
        String signResult = null;
        switch (returnType.getSort()) {
            case 0: {
                signResult = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
                break;
            }
            case 8: {
                signResult = "(DLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
                break;
            }
            case 6: {
                signResult = "(FLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
                break;
            }
            case 7: {
                signResult = "(JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
                break;
            }
            case 10: {
                signResult = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
                break;
            }
            case 9: {
                signResult = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
                break;
            }
            case 1: {
                signResult = "(ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                signResult = "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
                break;
            }
            default: {
                Assertions.check(false);
            }
        }
        this.stack.pushStrings(owner, name, desc);
        this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, CALL_RESULT, signResult);
    }

    private void passCallerStackParams(Type[] argTypes, boolean needThis) {
        int i;
        if (argTypes == null || argTypes.length == 0) {
            return;
        }
        HashMap<Integer, Integer> to = new HashMap<Integer, Integer>();
        for (i = argTypes.length - 1; i >= 0; --i) {
            int loc = this.newLocal(argTypes[i]);
            this.storeLocal(loc);
            to.put(i, loc);
        }
        for (i = 0; i < argTypes.length; ++i) {
            this.loadLocal((Integer)to.get(i));
        }
        int calleeLocalsIndex = this.calculateCalleeLocalsIndex(argTypes, needThis);
        for (int i2 = argTypes.length - 1; i2 >= 0; --i2) {
            int localVarIndex = (Integer)to.get(i2);
            this.loadLocal(localVarIndex);
            Type argType = argTypes[i2];
            this.stack.passCallerStackParam(argType, i2, calleeLocalsIndex);
            calleeLocalsIndex -= argType.getSize();
        }
    }

    private int calculateCalleeLocalsIndex(Type[] argTypes, boolean needThis) {
        int calleeLocalsIndex = 0;
        for (Type type : argTypes) {
            calleeLocalsIndex += type.getSize();
        }
        if (needThis) {
            ++calleeLocalsIndex;
        }
        return calleeLocalsIndex;
    }

    @Override
    public void visitIincInsn(int i, int value) {
        this.stack.pushInt(i);
        this.stack.pushInt(value);
        this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[132], "(II)V");
        super.visitIincInsn(i, value);
    }

    @Override
    public void visitMultiANewArrayInsn(String arrayTypeDesc, int nrDimensions) {
        this.mv.visitLdcInsn(arrayTypeDesc);
        this.mv.visitIntInsn(17, nrDimensions);
        this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[197], "(Ljava/lang/String;I)V");
        super.visitMultiANewArrayInsn(arrayTypeDesc, nrDimensions);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        int currentBranchIndex = this.branchCounter++;
        this.mv.visitInsn(89);
        this.stack.pushInt(min);
        this.stack.pushInt(max);
        this.mv.visitLdcInsn(this.className);
        this.mv.visitLdcInsn(this.methName);
        this.mv.visitLdcInsn(currentBranchIndex);
        String IIIGGI_V = "(IIILjava/lang/String;Ljava/lang/String;I)V";
        this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[170], IIIGGI_V);
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        int currentBranchIndex = this.branchCounter++;
        this.mv.visitInsn(89);
        this.stack.pushInt(keys.length);
        this.mv.visitIntInsn(188, 10);
        for (int i = 0; i < keys.length; ++i) {
            this.mv.visitInsn(89);
            this.stack.pushInt(i);
            this.stack.pushInt(keys[i]);
            this.mv.visitInsn(79);
        }
        this.mv.visitLdcInsn(this.className);
        this.mv.visitLdcInsn(this.methName);
        this.mv.visitLdcInsn(currentBranchIndex);
        String IRGGI_V = "(I[ILjava/lang/String;Ljava/lang/String;I)V";
        this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[171], IRGGI_V);
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        switch (opcode) {
            case 192: 
            case 193: {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(type);
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(Ljava/lang/Object;Ljava/lang/String;)V");
                break;
            }
            case 187: {
                this.mv.visitLdcInsn(type);
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(Ljava/lang/String;)V");
                break;
            }
            case 189: {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(type);
                this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, ConcolicConfig.BYTECODE_NAME[opcode], "(ILjava/lang/String;)V");
                break;
            }
            default: {
                Assertions.check(false);
            }
        }
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.exceptionHandlers.add(handler);
        super.visitTryCatchBlock(start, end, handler, type);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.stack.pushStrings(this.className, this.methName, this.methDescription);
        this.stack.pushInt(maxStack);
        this.stack.pushInt(maxLocals);
        this.mv.visitMethodInsn(184, ConcolicConfig.VM_FQ, "METHOD_MAXS", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;II)V");
        super.visitMaxs(maxStack, maxLocals);
    }
}

