/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.util.LinkedList;
import java.util.List;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.expr.Constraint;

public class PathCondition {
    private final List<BranchCondition> pathCondition;

    public PathCondition(List<BranchCondition> branchConditions) {
        this.pathCondition = new LinkedList<BranchCondition>(branchConditions);
    }

    public List<Constraint<?>> getConstraints() {
        LinkedList constraints = new LinkedList();
        for (BranchCondition b : this.pathCondition) {
            constraints.addAll(b.getSupportingConstraints());
            constraints.add(b.getConstraint());
        }
        return constraints;
    }

    public PathCondition negate(int branchConditionIndex) {
        if (branchConditionIndex < 0 || branchConditionIndex >= this.pathCondition.size()) {
            throw new IndexOutOfBoundsException("The position " + branchConditionIndex + " does not exists");
        }
        LinkedList<BranchCondition> newPathCondition = new LinkedList<BranchCondition>();
        for (int i = 0; i < branchConditionIndex; ++i) {
            BranchCondition b = this.pathCondition.get(i);
            newPathCondition.add(b);
        }
        BranchCondition targetBranch = this.pathCondition.get(branchConditionIndex);
        Constraint<?> negation = targetBranch.getConstraint().negate();
        BranchCondition negatedBranch = new BranchCondition(targetBranch.getClassName(), targetBranch.getMethodName(), targetBranch.getBranchIndex(), negation, targetBranch.getSupportingConstraints());
        newPathCondition.add(negatedBranch);
        return new PathCondition(newPathCondition);
    }

    public List<BranchCondition> getBranchConditions() {
        return this.pathCondition;
    }

    public boolean isEmpty() {
        return this.pathCondition.isEmpty();
    }

    public int size() {
        return this.pathCondition.size();
    }

    public BranchCondition get(int index) {
        return this.pathCondition.get(index);
    }
}

