/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.symbolic.ConstraintTypeCounter;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.RealConstraint;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.solver.SolverCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSEStats {
    static Logger logger = LoggerFactory.getLogger(DSEStats.class);
    private static DSEStats instance = null;
    private long nrOfUNSATs = 0L;
    private long nrOfSATs = 0L;
    private long nrOfTimeouts = 0L;
    private long nrOfSolutionWithNoImprovement = 0L;
    private long nrOfNewTestFound = 0L;
    private long totalSolvingTimeMillis = 0L;
    private long totalConcolicExecutionTimeMillis = 0L;
    private int constraintTooLongCounter = 0;
    private int max_path_condition_length;
    private int min_path_condition_length;
    private double avg_path_condition_length;
    private int max_constraint_size = 0;
    private int min_constraint_size = 0;
    private double avg_constraint_size = 0.0;
    private int constraint_count = 0;
    private int path_condition_count = 0;
    private final List<Boolean> changes = new LinkedList<Boolean>();
    private final ConstraintTypeCounter constraintTypeCounter = new ConstraintTypeCounter();

    public static DSEStats getInstance() {
        if (instance == null) {
            instance = new DSEStats();
        }
        return instance;
    }

    public static void clear() {
        instance = null;
    }

    private DSEStats() {
    }

    public void reportNewUNSAT() {
        ++this.nrOfUNSATs;
    }

    public void reportNewSAT() {
        ++this.nrOfSATs;
    }

    public void reportNewTestUnuseful() {
        ++this.nrOfSolutionWithNoImprovement;
    }

    private long getUNSAT() {
        return this.nrOfUNSATs;
    }

    private long getSAT() {
        return this.nrOfSATs;
    }

    private long getUnusefulTests() {
        return this.nrOfSolutionWithNoImprovement;
    }

    public void reportNewTestUseful() {
        ++this.nrOfNewTestFound;
    }

    private long getUsefulTests() {
        return this.nrOfNewTestFound;
    }

    public void logStatistics() {
        logger.info("* DSE Statistics");
        this.logSolverStatistics();
        logger.info("");
        this.logConstraintSizeStatistics();
        logger.info("");
        this.logPathConditionLengthStatistics();
        logger.info("");
        this.logTimeStatistics();
        logger.info("");
        this.logCacheStatistics();
        logger.info("");
        logger.info("");
        this.logAdaptationStatistics();
        logger.info("");
        logger.info("");
        this.logConstraintTypeStatistics();
        logger.info("");
    }

    private void logAdaptationStatistics() {
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        for (Boolean change : this.changes) {
            if (change.booleanValue()) {
                buff.append("+");
                continue;
            }
            buff.append("-");
        }
        buff.append("]");
        logger.info("* LS) Local Search Adaptation statistics");
        logger.info("* LS)   Adaptations: " + buff.toString());
    }

    private void logCacheStatistics() {
        logger.info("* DSE) Constraint Cache Statistics");
        int numberOfSATs = SolverCache.getInstance().getNumberOfSATs();
        int numberOfUNSATs = SolverCache.getInstance().getNumberOfUNSATs();
        if (numberOfSATs == 0 || numberOfUNSATs == 0) {
            logger.info("* DSE)   Constraint Cache was not used.");
        } else {
            logger.info(String.format("* DSE)   Stored SAT constraints: %s", numberOfSATs));
            logger.info(String.format("* DSE)   Stored UNSAT constraints: %s", numberOfUNSATs));
            NumberFormat percentFormat = NumberFormat.getPercentInstance();
            percentFormat.setMaximumFractionDigits(1);
            String hit_rate_str = percentFormat.format(SolverCache.getInstance().getHitRate());
            logger.info(String.format("* DSE)   Cache hit rate: %s", hit_rate_str));
        }
    }

    private void logTimeStatistics() {
        logger.info("* DSE) Time Statistics");
        logger.info(String.format("* DSE)   Time spent solving constraints: %sms", this.totalSolvingTimeMillis));
        logger.info(String.format("* DSE)   Time spent executing test concolically: %sms", this.totalConcolicExecutionTimeMillis));
    }

    private void logSolverStatistics() {
        long total_constraint_solvings = this.getSAT() + this.getUNSAT() + this.getTimeouts();
        String SAT_ratio_str = "Nan";
        String UNSAT_ratio_str = "Nan";
        String useful_tests_ratio_str = "Nan";
        String unuseful_tests_ratio_str = "Nan";
        String timeout_ratio_str = "Nan";
        if (total_constraint_solvings > 0L) {
            double SAT_ratio = (double)this.getSAT() / (double)total_constraint_solvings;
            double UNSAT_ratio = (double)this.getUNSAT() / (double)total_constraint_solvings;
            double useful_tests_ratio = (double)this.getUsefulTests() / (double)total_constraint_solvings;
            double unuseful_tests_ratio = (double)this.getUnusefulTests() / (double)total_constraint_solvings;
            double timeout_ratio = (double)this.getTimeouts() / (double)total_constraint_solvings;
            NumberFormat percentFormat = NumberFormat.getPercentInstance();
            percentFormat.setMaximumFractionDigits(1);
            SAT_ratio_str = percentFormat.format(SAT_ratio);
            UNSAT_ratio_str = percentFormat.format(UNSAT_ratio);
            useful_tests_ratio_str = percentFormat.format(useful_tests_ratio);
            unuseful_tests_ratio_str = percentFormat.format(unuseful_tests_ratio);
            timeout_ratio_str = percentFormat.format(timeout_ratio);
        }
        logger.info("* DSE) Solving statistics");
        logger.info(String.format("* DSE)   SAT: %s (%s)", this.getSAT(), SAT_ratio_str));
        logger.info(String.format("* DSE) \t  Useful Tests: %s (%s)", this.getUsefulTests(), useful_tests_ratio_str));
        logger.info(String.format("* DSE) \t  Unuseful Tests:  %s (%s)", this.getUnusefulTests(), unuseful_tests_ratio_str));
        logger.info(String.format("* DSE)   UNSAT: %s (%s)", this.getUNSAT(), UNSAT_ratio_str));
        logger.info(String.format("* DSE)   Timeouts: %s (%s)", timeout_ratio_str, this.getTimeouts()));
        logger.info(String.format("* DSE)   # Constraint solvings: %s (%s+%s)", total_constraint_solvings, this.getSAT(), this.getUNSAT()));
    }

    private void logConstraintTypeStatistics() {
        int total = this.constraintTypeCounter.getTotalNumberOfConstraints();
        int integerOnly = this.constraintTypeCounter.getIntegerOnlyConstraints();
        int realOnly = this.constraintTypeCounter.getRealOnlyConstraints();
        int stringOnly = this.constraintTypeCounter.getStringOnlyConstraints();
        int integerRealOnly = this.constraintTypeCounter.getIntegerAndRealConstraints();
        int integerStringOnly = this.constraintTypeCounter.getIntegerAndStringConstraints();
        int realStringOnly = this.constraintTypeCounter.getRealAndStringConstraints();
        int integerRealStringConstraints = this.constraintTypeCounter.getIntegerRealAndStringConstraints();
        if (total == 0) {
            logger.info(String.format("* DSE)   no constraints {}", this.avg_constraint_size));
        } else {
            String line1 = String.format("* DSE)   Number of integer only constraints : %s / %s ", integerOnly, total);
            String line2 = String.format("* DSE)   Number of real only constraints : %s", realOnly, total);
            String line3 = String.format("* DSE)   Number of string only constraints : %s", stringOnly, total);
            String line4 = String.format("* DSE)   Number of integer+real constraints : %s / %s ", integerRealOnly, total);
            String line5 = String.format("* DSE)   Number of integer+string constraints : %s / %s ", integerStringOnly, total);
            String line6 = String.format("* DSE)   Number of real+string constraints : %s / %s ", realStringOnly, total);
            String line7 = String.format("* DSE)   Number of integer+real+string constraints : %s / %s ", integerRealStringConstraints, total);
            logger.info(line1);
            logger.info(line2);
            logger.info(line3);
            logger.info(line4);
            logger.info(line5);
            logger.info(line6);
            logger.info(line7);
        }
    }

    private void logConstraintSizeStatistics() {
        logger.info("* DSE) Constraint size:");
        logger.info(String.format("* DSE)   max constraint size: %s", this.max_constraint_size));
        logger.info(String.format("* DSE)   min constraint size: %s", this.min_constraint_size));
        logger.info(String.format("* DSE)   avg constraint size: %s", this.avg_constraint_size));
        logger.info(String.format("* DSE)   Too big constraints: %s (max size %s)", this.getConstraintTooLongCounter(), Properties.DSE_CONSTRAINT_LENGTH));
    }

    private void logPathConditionLengthStatistics() {
        logger.info("* DSE) Path condition length:");
        logger.info(String.format("* DSE)   max path condition length: %s", this.max_path_condition_length));
        logger.info(String.format("* DSE)   min path condition length: %s", this.min_path_condition_length));
        logger.info(String.format("* DSE)   avg path condition length: %s", this.avg_path_condition_length));
    }

    private int getConstraintTooLongCounter() {
        return this.constraintTooLongCounter;
    }

    public void reportNewConstraints(Collection<Constraint<?>> constraints) {
        if (this.path_condition_count == 0) {
            this.min_path_condition_length = constraints.size();
            this.max_path_condition_length = constraints.size();
            this.avg_path_condition_length = constraints.size();
        } else {
            double new_avg_size;
            this.avg_path_condition_length = new_avg_size = this.avg_path_condition_length + ((double)constraints.size() - this.avg_path_condition_length) / ((double)this.path_condition_count + 1.0);
            if (constraints.size() > this.max_path_condition_length) {
                this.max_path_condition_length = constraints.size();
            }
            if (constraints.size() < this.min_path_condition_length) {
                this.min_path_condition_length = constraints.size();
            }
        }
        ++this.path_condition_count;
        for (Constraint<?> c : constraints) {
            if (this.constraint_count == 0) {
                this.min_constraint_size = c.getSize();
                this.max_constraint_size = c.getSize();
                this.avg_constraint_size = c.getSize();
            } else {
                double new_avg_size;
                this.avg_constraint_size = new_avg_size = this.avg_constraint_size + ((double)c.getSize() - this.avg_constraint_size) / ((double)this.constraint_count + 1.0);
                if (c.getSize() > this.max_constraint_size) {
                    this.max_constraint_size = c.getSize();
                }
                if (c.getSize() < this.min_constraint_size) {
                    this.min_constraint_size = c.getSize();
                }
            }
            ++this.constraint_count;
        }
        this.countTypesOfConstraints(constraints);
    }

    private void countTypesOfConstraints(Collection<Constraint<?>> constraints) {
        boolean hasIntegerConstraint = false;
        boolean hasRealConstraint = false;
        boolean hasStringConstraint = false;
        for (Constraint<?> constraint : constraints) {
            if (constraint instanceof StringConstraint) {
                hasStringConstraint = true;
                continue;
            }
            if (constraint instanceof IntegerConstraint) {
                hasIntegerConstraint = true;
                continue;
            }
            if (constraint instanceof RealConstraint) {
                hasRealConstraint = true;
                continue;
            }
            throw new IllegalArgumentException("The constraint type " + constraint.getClass().getCanonicalName() + " is not considered!");
        }
        this.constraintTypeCounter.addNewConstraint(hasIntegerConstraint, hasRealConstraint, hasStringConstraint);
    }

    public void reportNewSolvingTime(long solvingTimeMillis) {
        this.totalSolvingTimeMillis += solvingTimeMillis;
    }

    public void reportNewConcolicExecutionTime(long concolicExecutionTimeMillis) {
        this.totalConcolicExecutionTimeMillis += concolicExecutionTimeMillis;
    }

    public void reportConstraintTooLong(int size) {
        ++this.constraintTooLongCounter;
    }

    public void reportNewTimeout() {
        ++this.nrOfTimeouts;
    }

    private long getTimeouts() {
        return this.nrOfTimeouts;
    }

    public void reportNewIncrease() {
        this.changes.add(true);
    }

    public void reportNewDecrease() {
        this.changes.add(false);
    }

    public void trackConstraintTypes() {
        int total = this.constraintTypeCounter.getTotalNumberOfConstraints();
        int integerOnly = this.constraintTypeCounter.getIntegerOnlyConstraints();
        int realOnly = this.constraintTypeCounter.getRealOnlyConstraints();
        int stringOnly = this.constraintTypeCounter.getStringOnlyConstraints();
        int integerRealOnly = this.constraintTypeCounter.getIntegerAndRealConstraints();
        int integerStringOnly = this.constraintTypeCounter.getIntegerAndStringConstraints();
        int realStringOnly = this.constraintTypeCounter.getRealAndStringConstraints();
        int integerRealStringConstraints = this.constraintTypeCounter.getIntegerRealAndStringConstraints();
        this.trackOutputVariable(RuntimeVariable.IntegerOnlyConstraints, integerOnly);
        this.trackOutputVariable(RuntimeVariable.RealOnlyConstraints, realOnly);
        this.trackOutputVariable(RuntimeVariable.StringOnlyConstraints, stringOnly);
        this.trackOutputVariable(RuntimeVariable.IntegerAndRealConstraints, integerRealOnly);
        this.trackOutputVariable(RuntimeVariable.IntegerAndStringConstraints, integerStringOnly);
        this.trackOutputVariable(RuntimeVariable.RealAndStringConstraints, realStringOnly);
        this.trackOutputVariable(RuntimeVariable.IntegerRealAndStringConstraints, integerRealStringConstraints);
        this.trackOutputVariable(RuntimeVariable.TotalNumberOfConstraints, total);
    }

    public void trackSolverStatistics() {
        this.trackOutputVariable(RuntimeVariable.NumberOfSATQueries, this.getSAT());
        this.trackOutputVariable(RuntimeVariable.NumberOfUNSATQueries, this.getUNSAT());
        this.trackOutputVariable(RuntimeVariable.NumberOfTimeoutQueries, this.getTimeouts());
        this.trackOutputVariable(RuntimeVariable.NumberOfUsefulNewTests, this.getUsefulTests());
        this.trackOutputVariable(RuntimeVariable.NumberOfUnusefulNewTests, this.getUnusefulTests());
    }

    private void trackOutputVariable(RuntimeVariable var, Object value) {
        ClientServices.getInstance().getClientNode().trackOutputVariable(var, value);
    }
}

