/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.util.List;
import org.evosuite.classpath.ResourceList;
import org.evosuite.symbolic.expr.Constraint;

public class BranchCondition {
    private final String className;
    private final String methodName;
    private final int branchIndex;
    private final Constraint<?> constraint;
    private final List<Constraint<?>> supportingConstraints;

    public BranchCondition(String className, String methodName, int branchIndex, Constraint<?> constraint, List<Constraint<?>> supportingConstraints) {
        this.className = ResourceList.getClassNameFromResourcePath(className);
        this.methodName = methodName;
        this.branchIndex = branchIndex;
        this.constraint = constraint;
        this.supportingConstraints = supportingConstraints;
    }

    public String toString() {
        String ret = "";
        for (Constraint<?> c : this.supportingConstraints) {
            ret = ret + " " + c + "\n";
        }
        ret = ret + this.constraint;
        return ret;
    }

    public String getClassName() {
        return this.className;
    }

    public int getInstructionIndex() {
        return this.branchIndex;
    }

    public String getFullName() {
        return this.className + "." + this.methodName;
    }

    public Constraint<?> getConstraint() {
        return this.constraint;
    }

    public List<Constraint<?>> getSupportingConstraints() {
        return this.supportingConstraints;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getBranchIndex() {
        return this.branchIndex;
    }
}

