/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.strategy;

import java.util.ArrayList;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.FitnessFunctions;
import org.evosuite.coverage.line.LineCoverageTestFitness;
import org.evosuite.coverage.rho.RhoCoverageFactory;
import org.evosuite.coverage.rho.RhoCoverageTestFitness;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.strategy.IndividualTestStrategy;
import org.evosuite.strategy.PropertiesTestGAFactory;
import org.evosuite.strategy.TestGenerationStrategy;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntBugTestStrategy
extends TestGenerationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(IndividualTestStrategy.class);

    @Override
    public TestSuiteChromosome generateTests() {
        LoggingUtils.getEvoLogger().info("* Setting up search algorithm for individual test generation (ASE'13)");
        ExecutionTracer.enableTraceCalls();
        PropertiesTestGAFactory factory = new PropertiesTestGAFactory();
        GeneticAlgorithm<TestChromosome> ga = factory.getSearchAlgorithm();
        if (Properties.SERIALIZE_GA || Properties.CLIENT_ON_THREAD) {
            TestGenerationResultBuilder.getInstance().setGeneticAlgorithm(ga);
        }
        RhoCoverageFactory rhoFactory = (RhoCoverageFactory)FitnessFunctions.getFitnessFactory(Properties.Criterion.RHO);
        RhoCoverageTestFitness rhoTestFitnessFunction = new RhoCoverageTestFitness();
        ga.addFitnessFunction(rhoTestFitnessFunction);
        ArrayList<LineCoverageTestFitness> goals = new ArrayList<LineCoverageTestFitness>(rhoFactory.getCoverageGoals());
        LoggingUtils.getEvoLogger().info("* Total number of test goals: ");
        LoggingUtils.getEvoLogger().info("  - Rho " + goals.size());
        double previous_fitness = RhoCoverageFactory.getRho();
        double best_fitness = 0.0;
        TestSuiteChromosome bests = new TestSuiteChromosome();
        for (int number_of_generations = (int)(Properties.SEARCH_BUDGET / 10L); number_of_generations > 0; --number_of_generations) {
            LoggingUtils.getEvoLogger().info("  * iteration(" + number_of_generations + ")");
            ga.setStoppingConditionLimit(10);
            ga.resetStoppingConditions();
            ga.clearPopulation();
            ga.generateSolution();
            TestChromosome best = ga.getBestIndividual();
            if (best.getLastExecutionResult() == null) continue;
            best_fitness = best.getFitness(rhoTestFitnessFunction);
            if (best_fitness < previous_fitness || best_fitness <= Properties.EPSON) {
                LoggingUtils.getEvoLogger().info("  * new best (previous fitness: " + previous_fitness + " | best_fitness: " + best_fitness + ")");
                ExecutionResult exec = best.getLastExecutionResult();
                ExecutionTrace trace = exec.getTrace();
                Set<Integer> testCoverage = trace.getCoveredLines();
                LoggingUtils.getEvoLogger().info("  * new test case added " + testCoverage.toString());
                rhoTestFitnessFunction.incrementNumber_of_Ones(testCoverage.size());
                rhoTestFitnessFunction.incrementNumber_of_Test_Cases();
                rhoTestFitnessFunction.addTestCoverage(testCoverage);
                bests.addTest(best);
                previous_fitness = best_fitness;
                continue;
            }
            LoggingUtils.getEvoLogger().info("  * new test case ignored (previous fitness: " + previous_fitness + " | best_fitness: " + best_fitness + ")");
        }
        LoggingUtils.getEvoLogger().info("* Search finished after, best individual has fitness " + best_fitness);
        LoggingUtils.getEvoLogger().info("Resulting test suite: " + bests.size() + " tests, length " + bests.totalLengthOfTestCases());
        return bests;
    }
}

