/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.statistics.backend;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.statistics.OutputVariable;
import org.evosuite.statistics.backend.StatisticsBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVStatisticsBackend
implements StatisticsBackend {
    private static Logger logger = LoggerFactory.getLogger(CSVStatisticsBackend.class);

    private String getCSVHeader(Map<String, OutputVariable<?>> data) {
        StringBuilder r = new StringBuilder();
        Iterator<Map.Entry<String, OutputVariable<?>>> it = data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, OutputVariable<?>> e = it.next();
            r.append(e.getKey());
            if (!it.hasNext()) continue;
            r.append(",");
        }
        return r.toString();
    }

    private String getCSVData(Map<String, OutputVariable<?>> data) {
        StringBuilder r = new StringBuilder();
        Iterator<Map.Entry<String, OutputVariable<?>>> it = data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, OutputVariable<?>> e = it.next();
            r.append(e.getValue().getValue());
            if (!it.hasNext()) continue;
            r.append(",");
        }
        return r.toString();
    }

    public static File getReportDir() throws RuntimeException {
        boolean created;
        File dir = new File(Properties.REPORT_DIR);
        if (!dir.exists() && !(created = dir.mkdirs())) {
            String msg = "Cannot create report dir: " + Properties.REPORT_DIR;
            logger.error(msg);
            throw new RuntimeException(msg);
        }
        return dir;
    }

    @Override
    public void writeData(Chromosome result, Map<String, OutputVariable<?>> data) {
        try {
            File outputDir = CSVStatisticsBackend.getReportDir();
            File f = new File(outputDir.getAbsolutePath() + File.separator + "statistics.csv");
            BufferedWriter out = new BufferedWriter(new FileWriter(f, true));
            if (f.length() == 0L) {
                out.write(this.getCSVHeader(data) + "\n");
            }
            out.write(this.getCSVData(data) + "\n");
            out.close();
        }
        catch (IOException e) {
            logger.warn("Error while writing statistics: " + e.getMessage());
        }
    }
}

