/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.hibernate4;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.TreeSet;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.SessionFactory;
import org.evosuite.shaded.org.hibernate.cache.spi.RegionFactory;
import org.evosuite.shaded.org.hibernate.cfg.Configuration;
import org.evosuite.shaded.org.hibernate.cfg.Settings;
import org.evosuite.shaded.org.hibernate.engine.transaction.internal.jta.CMTTransactionFactory;
import org.evosuite.shaded.org.hibernate.service.ServiceRegistry;
import org.evosuite.shaded.org.springframework.core.io.Resource;
import org.evosuite.shaded.org.springframework.core.io.ResourceLoader;
import org.evosuite.shaded.org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.evosuite.shaded.org.springframework.core.io.support.ResourcePatternResolver;
import org.evosuite.shaded.org.springframework.core.io.support.ResourcePatternUtils;
import org.evosuite.shaded.org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.evosuite.shaded.org.springframework.core.type.classreading.MetadataReader;
import org.evosuite.shaded.org.springframework.core.type.classreading.MetadataReaderFactory;
import org.evosuite.shaded.org.springframework.core.type.filter.AnnotationTypeFilter;
import org.evosuite.shaded.org.springframework.core.type.filter.TypeFilter;
import org.evosuite.shaded.org.springframework.orm.hibernate4.ConfigurableJtaPlatform;
import org.evosuite.shaded.org.springframework.orm.hibernate4.SpringSessionContext;
import org.evosuite.shaded.org.springframework.transaction.jta.JtaTransactionManager;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.util.ClassUtils;

public class LocalSessionFactoryBuilder
extends Configuration {
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private static final String PACKAGE_INFO_SUFFIX = ".package-info";
    private static final TypeFilter[] DEFAULT_ENTITY_TYPE_FILTERS = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false)};
    private static TypeFilter converterTypeFilter;
    private final ResourcePatternResolver resourcePatternResolver;
    private RegionFactory cacheRegionFactory;
    private TypeFilter[] entityTypeFilters = DEFAULT_ENTITY_TYPE_FILTERS;

    public LocalSessionFactoryBuilder(DataSource dataSource) {
        this(dataSource, new PathMatchingResourcePatternResolver());
    }

    public LocalSessionFactoryBuilder(DataSource dataSource, ClassLoader classLoader) {
        this(dataSource, new PathMatchingResourcePatternResolver(classLoader));
    }

    public LocalSessionFactoryBuilder(DataSource dataSource, ResourceLoader resourceLoader) {
        this.getProperties().put("hibernate.current_session_context_class", SpringSessionContext.class.getName());
        if (dataSource != null) {
            this.getProperties().put("hibernate.connection.datasource", dataSource);
        }
        this.getProperties().put("hibernate.classLoader.application", resourceLoader.getClassLoader());
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver(resourceLoader);
    }

    public LocalSessionFactoryBuilder setJtaTransactionManager(Object jtaTransactionManager) {
        Assert.notNull(jtaTransactionManager, "Transaction manager reference must not be null");
        if (jtaTransactionManager instanceof JtaTransactionManager) {
            boolean webspherePresent = ClassUtils.isPresent("com.ibm.wsspi.uow.UOWManager", this.getClass().getClassLoader());
            if (webspherePresent) {
                this.getProperties().put("hibernate.transaction.jta.platform", ConfigurableJtaPlatform.getJtaPlatformBasePackage() + "internal.WebSphereExtendedJtaPlatform");
            } else {
                JtaTransactionManager jtaTm = (JtaTransactionManager)jtaTransactionManager;
                if (jtaTm.getTransactionManager() == null) {
                    throw new IllegalArgumentException("Can only apply JtaTransactionManager which has a TransactionManager reference set");
                }
                this.getProperties().put("hibernate.transaction.jta.platform", new ConfigurableJtaPlatform(jtaTm.getTransactionManager(), jtaTm.getUserTransaction(), jtaTm.getTransactionSynchronizationRegistry()).getJtaPlatformProxy());
            }
        } else if (jtaTransactionManager instanceof TransactionManager) {
            this.getProperties().put("hibernate.transaction.jta.platform", new ConfigurableJtaPlatform((TransactionManager)jtaTransactionManager, null, null).getJtaPlatformProxy());
        } else {
            throw new IllegalArgumentException("Unknown transaction manager type: " + jtaTransactionManager.getClass().getName());
        }
        this.getProperties().put("hibernate.transaction.factory_class", new CMTTransactionFactory());
        return this;
    }

    public LocalSessionFactoryBuilder setMultiTenantConnectionProvider(Object multiTenantConnectionProvider) {
        this.getProperties().put("hibernate.multi_tenant_connection_provider", multiTenantConnectionProvider);
        return this;
    }

    public LocalSessionFactoryBuilder setCurrentTenantIdentifierResolver(Object currentTenantIdentifierResolver) {
        this.getProperties().put("hibernate.tenant_identifier_resolver", currentTenantIdentifierResolver);
        return this;
    }

    public LocalSessionFactoryBuilder setCacheRegionFactory(RegionFactory cacheRegionFactory) {
        this.cacheRegionFactory = cacheRegionFactory;
        return this;
    }

    public LocalSessionFactoryBuilder setEntityTypeFilters(TypeFilter ... entityTypeFilters) {
        this.entityTypeFilters = entityTypeFilters;
        return this;
    }

    public LocalSessionFactoryBuilder addAnnotatedClasses(Class<?> ... annotatedClasses) {
        for (Class<?> annotatedClass : annotatedClasses) {
            this.addAnnotatedClass(annotatedClass);
        }
        return this;
    }

    public LocalSessionFactoryBuilder addPackages(String ... annotatedPackages) {
        for (String annotatedPackage : annotatedPackages) {
            this.addPackage(annotatedPackage);
        }
        return this;
    }

    public LocalSessionFactoryBuilder scanPackages(String ... packagesToScan) throws HibernateException {
        TreeSet<String> entityClassNames = new TreeSet<String>();
        TreeSet<String> converterClassNames = new TreeSet<String>();
        TreeSet<String> packageNames = new TreeSet<String>();
        try {
            for (String pkg : packagesToScan) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath(pkg) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory(this.resourcePatternResolver);
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    if (this.matchesEntityTypeFilter(reader, readerFactory)) {
                        entityClassNames.add(className);
                        continue;
                    }
                    if (converterTypeFilter != null && converterTypeFilter.match(reader, readerFactory)) {
                        converterClassNames.add(className);
                        continue;
                    }
                    if (!className.endsWith(PACKAGE_INFO_SUFFIX)) continue;
                    packageNames.add(className.substring(0, className.length() - PACKAGE_INFO_SUFFIX.length()));
                }
            }
        }
        catch (IOException ex) {
            throw new MappingException("Failed to scan classpath for unlisted classes", ex);
        }
        try {
            ClassLoader cl = this.resourcePatternResolver.getClassLoader();
            for (String className : entityClassNames) {
                this.addAnnotatedClass(cl.loadClass(className));
            }
            for (String className : converterClassNames) {
                ConverterRegistrationDelegate.registerConverter(this, cl.loadClass(className));
            }
            for (String packageName : packageNames) {
                this.addPackage(packageName);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("Failed to load annotated classes from classpath", ex);
        }
        return this;
    }

    private boolean matchesEntityTypeFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (this.entityTypeFilters != null) {
            for (TypeFilter filter : this.entityTypeFilters) {
                if (!filter.match(reader, readerFactory)) continue;
                return true;
            }
        }
        return false;
    }

    public Settings buildSettings(Properties props, ServiceRegistry serviceRegistry) throws HibernateException {
        Settings settings = super.buildSettings(props, serviceRegistry);
        if (this.cacheRegionFactory != null) {
            try {
                Method setRegionFactory = Settings.class.getDeclaredMethod("setRegionFactory", RegionFactory.class);
                setRegionFactory.setAccessible(true);
                setRegionFactory.invoke((Object)settings, this.cacheRegionFactory);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to invoke Hibernate's setRegionFactory method", ex);
            }
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionFactory buildSessionFactory() throws HibernateException {
        boolean overrideClassLoader;
        ClassLoader appClassLoader = (ClassLoader)this.getProperties().get("hibernate.classLoader.application");
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        boolean bl = overrideClassLoader = appClassLoader != null && !appClassLoader.equals(threadContextClassLoader);
        if (overrideClassLoader) {
            currentThread.setContextClassLoader(appClassLoader);
        }
        try {
            SessionFactory sessionFactory = super.buildSessionFactory();
            return sessionFactory;
        }
        finally {
            if (overrideClassLoader) {
                currentThread.setContextClassLoader(threadContextClassLoader);
            }
        }
    }

    static {
        try {
            Class<?> converterAnnotation = ClassUtils.forName("javax.persistence.Converter", LocalSessionFactoryBuilder.class.getClassLoader());
            converterTypeFilter = new AnnotationTypeFilter(converterAnnotation, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static class ConverterRegistrationDelegate {
        private ConverterRegistrationDelegate() {
        }

        public static void registerConverter(Configuration config, Class<?> converterClass) {
            config.addAttributeConverter(converterClass);
        }
    }
}

