/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.support.nativejdbc;

import com.mchange.v2.c3p0.C3P0ProxyConnection;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.evosuite.shaded.org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import org.evosuite.shaded.org.springframework.util.ReflectionUtils;

public class C3P0NativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private final Method getRawConnectionMethod;

    public static Connection getRawConnection(Connection con) {
        return con;
    }

    public C3P0NativeJdbcExtractor() {
        try {
            this.getRawConnectionMethod = this.getClass().getMethod("getRawConnection", Connection.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Internal error in C3P0NativeJdbcExtractor: " + ex.getMessage());
        }
    }

    @Override
    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    @Override
    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    @Override
    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    @Override
    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (con instanceof C3P0ProxyConnection) {
            C3P0ProxyConnection cpCon = (C3P0ProxyConnection)con;
            try {
                return (Connection)cpCon.rawConnectionOperation(this.getRawConnectionMethod, null, new Object[]{C3P0ProxyConnection.RAW_CONNECTION});
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ReflectionUtils.handleReflectionException(ex);
            }
        }
        return con;
    }
}

