/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import org.evosuite.shaded.org.springframework.core.annotation.AnnotationUtils;
import org.evosuite.shaded.org.springframework.core.annotation.Order;
import org.evosuite.shaded.org.springframework.util.ClassUtils;

public abstract class OrderUtils {
    private static Class<? extends Annotation> priorityAnnotationType = null;

    public static Integer getOrder(Class<?> type) {
        return OrderUtils.getOrder(type, null);
    }

    public static Integer getOrder(Class<?> type, Integer defaultOrder) {
        Order order = AnnotationUtils.findAnnotation(type, Order.class);
        if (order != null) {
            return order.value();
        }
        Integer priorityOrder = OrderUtils.getPriority(type);
        if (priorityOrder != null) {
            return priorityOrder;
        }
        return defaultOrder;
    }

    public static Integer getPriority(Class<?> type) {
        Annotation priority;
        if (priorityAnnotationType != null && (priority = AnnotationUtils.findAnnotation(type, priorityAnnotationType)) != null) {
            return (Integer)AnnotationUtils.getValue(priority);
        }
        return null;
    }

    static {
        try {
            priorityAnnotationType = ClassUtils.forName("javax.annotation.Priority", OrderUtils.class.getClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

