/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.core;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.shaded.org.springframework.lang.UsesJava7;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.util.ClassUtils;

@UsesJava7
public abstract class DecoratingClassLoader
extends ClassLoader {
    protected static final boolean parallelCapableClassLoaderAvailable = ClassUtils.hasMethod(ClassLoader.class, "registerAsParallelCapable", new Class[0]);
    private final Set<String> excludedPackages = Collections.newSetFromMap(new ConcurrentHashMap(8));
    private final Set<String> excludedClasses = Collections.newSetFromMap(new ConcurrentHashMap(8));

    public DecoratingClassLoader() {
    }

    public DecoratingClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void excludePackage(String packageName) {
        Assert.notNull(packageName, "Package name must not be null");
        this.excludedPackages.add(packageName);
    }

    public void excludeClass(String className) {
        Assert.notNull(className, "Class name must not be null");
        this.excludedClasses.add(className);
    }

    protected boolean isExcluded(String className) {
        if (this.excludedClasses.contains(className)) {
            return true;
        }
        for (String packageName : this.excludedPackages) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    static {
        if (parallelCapableClassLoaderAvailable) {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

