/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.context.expression;

import org.evosuite.shaded.org.springframework.beans.BeansException;
import org.evosuite.shaded.org.springframework.beans.factory.BeanFactory;
import org.evosuite.shaded.org.springframework.expression.AccessException;
import org.evosuite.shaded.org.springframework.expression.BeanResolver;
import org.evosuite.shaded.org.springframework.expression.EvaluationContext;
import org.evosuite.shaded.org.springframework.util.Assert;

public class BeanFactoryResolver
implements BeanResolver {
    private final BeanFactory beanFactory;

    public BeanFactoryResolver(BeanFactory beanFactory) {
        Assert.notNull(beanFactory, "BeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    @Override
    public Object resolve(EvaluationContext context, String beanName) throws AccessException {
        try {
            return this.beanFactory.getBean(beanName);
        }
        catch (BeansException ex) {
            throw new AccessException("Could not resolve bean reference against BeanFactory", ex);
        }
    }
}

