/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.beans.factory.annotation;

import org.evosuite.shaded.org.springframework.beans.factory.annotation.Autowire;
import org.evosuite.shaded.org.springframework.beans.factory.annotation.Configurable;
import org.evosuite.shaded.org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.evosuite.shaded.org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.util.ClassUtils;

public class AnnotationBeanWiringInfoResolver
implements BeanWiringInfoResolver {
    @Override
    public BeanWiringInfo resolveWiringInfo(Object beanInstance) {
        Assert.notNull(beanInstance, "Bean instance must not be null");
        Configurable annotation = beanInstance.getClass().getAnnotation(Configurable.class);
        return annotation != null ? this.buildWiringInfo(beanInstance, annotation) : null;
    }

    protected BeanWiringInfo buildWiringInfo(Object beanInstance, Configurable annotation) {
        if (!Autowire.NO.equals((Object)annotation.autowire())) {
            return new BeanWiringInfo(annotation.autowire().value(), annotation.dependencyCheck());
        }
        if (!"".equals(annotation.value())) {
            return new BeanWiringInfo(annotation.value(), false);
        }
        return new BeanWiringInfo(this.getDefaultBeanName(beanInstance), true);
    }

    protected String getDefaultBeanName(Object beanInstance) {
        return ClassUtils.getUserClass(beanInstance).getName();
    }
}

